/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class InputBatch<T> {
    private final Option<T> batch;
    private final String checkpointForNextBatch;
    private final SchemaProvider schemaProvider;

    public InputBatch(Option<T> batch, String checkpointForNextBatch, SchemaProvider schemaProvider) {
        this.batch = batch;
        this.checkpointForNextBatch = checkpointForNextBatch;
        this.schemaProvider = schemaProvider;
    }

    public InputBatch(Option<T> batch, String checkpointForNextBatch) {
        this(batch, checkpointForNextBatch, null);
    }

    public Option<T> getBatch() {
        return this.batch;
    }

    public String getCheckpointForNextBatch() {
        return this.checkpointForNextBatch;
    }

    public SchemaProvider getSchemaProvider() {
        if (this.batch.isPresent() && this.schemaProvider == null) {
            throw new HoodieException("Please provide a valid schema provider class!");
        }
        return Option.ofNullable(this.schemaProvider).orElse(new NullSchemaProvider());
    }

    public static class NullSchemaProvider
    extends SchemaProvider {
        public NullSchemaProvider() {
            this(null, null);
        }

        public NullSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
            super(props, jssc);
        }

        @Override
        public Schema getSourceSchema() {
            return Schema.create((Schema.Type)Schema.Type.NULL);
        }
    }
}

