/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.debezium;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamerMetrics;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.debezium.DebeziumSource;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class PostgresDebeziumSource
extends DebeziumSource {
    public PostgresDebeziumSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, HoodieDeltaStreamerMetrics metrics) {
        super(props, sparkContext, sparkSession, schemaProvider, metrics);
    }

    @Override
    protected Dataset<Row> processDataset(Dataset<Row> rowDataset) {
        if (rowDataset.columns().length > 0) {
            Dataset insertedOrUpdatedData = rowDataset.selectExpr(new String[]{String.format("%s as %s", "op", "_change_operation_type"), String.format("%s as %s", "ts_ms", "_upstream_event_processed_ts_ms"), String.format("%s as %s", "source.name", "db_shard_source_partition"), String.format("%s as %s", "source.ts_ms", "_event_origin_ts_ms"), String.format("%s as %s", "source.txId", "_event_tx_id"), String.format("%s as %s", "source.lsn", "_event_lsn"), String.format("%s as %s", "source.xmin", "_event_xmin"), String.format("%s.*", "after")}).filter(rowDataset.col("op").notEqual((Object)"d"));
            Dataset deletedData = rowDataset.selectExpr(new String[]{String.format("%s as %s", "op", "_change_operation_type"), String.format("%s as %s", "ts_ms", "_upstream_event_processed_ts_ms"), String.format("%s as %s", "source.name", "db_shard_source_partition"), String.format("%s as %s", "source.ts_ms", "_event_origin_ts_ms"), String.format("%s as %s", "source.txId", "_event_tx_id"), String.format("%s as %s", "source.lsn", "_event_lsn"), String.format("%s as %s", "source.xmin", "_event_xmin"), String.format("%s.*", "before")}).filter(rowDataset.col("op").equalTo((Object)"d"));
            return insertedOrUpdatedData.union(deletedData);
        }
        return rowDataset;
    }
}

