/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0001\u0003\u0001=\u0011!\u0003S8pI&,7)\u0019;bY><G+\u00192mK*\u00111\u0001B\u0001\bG\u0006$\u0018\r\\8h\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005mA\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0013\u0001\u0011)\u0019!C\u0001;U\ta\u0004\u0005\u0002 A5\ta!\u0003\u0002\"\r\ta1\u000b]1sWN+7o]5p]\"A1\u0005\u0001B\u0001B\u0003%a$\u0001\u0004ta\u0006\u00148\u000e\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005)A/\u00192mKV\tq\u0005\u0005\u0002)S5\t!!\u0003\u0002+\u0005\ta1)\u0019;bY><G+\u00192mK\"AA\u0006\u0001B\u0001B\u0003%q%\u0001\u0004uC\ndW\r\t\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\n$\u0007\u0005\u0002)\u0001!)\u0011\"\fa\u0001=!)Q%\fa\u0001O!9A\u0007\u0001b\u0001\n\u0013)\u0014A\u00035bI>|\u0007oQ8oMV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!1m\u001c8g\u0015\tY$\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003{a\u0012QbQ8oM&<WO]1uS>t\u0007BB \u0001A\u0003%a'A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0003bB!\u0001\u0005\u0004%\tAQ\u0001\u0011G\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a(b[\u0016,\u0012a\u0011\t\u0003\t\u001es!!E#\n\u0005\u0019\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!A\u0012\n\t\r-\u0003\u0001\u0015!\u0003D\u0003E\u0019\u0017\r^1m_\u001e$\u0016M\u00197f\u001d\u0006lW\r\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0003E\u0019\u0017\r^1m_\u001e\u0004&o\u001c9feRLWm]\u000b\u0002\u001fB!A\tU\"D\u0013\t\t\u0016JA\u0002NCBDaa\u0015\u0001!\u0002\u0013y\u0015AE2bi\u0006dwn\u001a)s_B,'\u000f^5fg\u0002Bq!\u0016\u0001C\u0002\u0013\u0005!)A\u0007uC\ndW\rT8dCRLwN\u001c\u0005\u0007/\u0002\u0001\u000b\u0011B\"\u0002\u001dQ\f'\r\\3M_\u000e\fG/[8oA!9\u0011\f\u0001b\u0001\n\u0003Q\u0016!\u00055p_\u0012LW\rV1cY\u0016,\u00050[:ugV\t1\f\u0005\u0002\u00129&\u0011QL\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019y\u0006\u0001)A\u00057\u0006\u0011\u0002n\\8eS\u0016$\u0016M\u00197f\u000bbL7\u000f^:!\u0011!\t\u0007\u0001#b\u0001\n\u0003\u0011\u0017AC7fi\u0006\u001cE.[3oiV\t1\r\u0005\u0002eU6\tQM\u0003\u0002&M*\u0011q\r[\u0001\u0007G>lWn\u001c8\u000b\u0005%T\u0011\u0001\u00025vI&L!a[3\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\"AQ\u000e\u0001E\u0001B\u0003&1-A\u0006nKR\f7\t\\5f]R\u0004\u0003\u0002C8\u0001\u0011\u000b\u0007I\u0011\u00019\u0002\u0017Q\f'\r\\3D_:4\u0017nZ\u000b\u0002cB\u0011AM]\u0005\u0003g\u0016\u0014\u0011\u0003S8pI&,G+\u00192mK\u000e{gNZ5h\u0011!)\b\u0001#A!B\u0013\t\u0018\u0001\u0004;bE2,7i\u001c8gS\u001e\u0004\u0003\u0002C<\u0001\u0011\u000b\u0007I\u0011\u0001\"\u0002\u0013Q\f'\r\\3OC6,\u0007\u0002C=\u0001\u0011\u0003\u0005\u000b\u0015B\"\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005\u0003\u0005|\u0001!\u0015\r\u0011\"\u0001}\u0003%!\u0018M\u00197f)f\u0004X-F\u0001~!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u00014\u0002\u000b5|G-\u001a7\n\u0007\u0005\u0015qPA\bI_>$\u0017.\u001a+bE2,G+\u001f9f\u0011%\tI\u0001\u0001E\u0001B\u0003&Q0\u0001\u0006uC\ndW\rV=qK\u0002B\u0011\"!\u0004\u0001\u0011\u000b\u0007I\u0011\u0001\"\u0002\u001bQ\f'\r\\3UsB,g*Y7f\u0011%\t\t\u0002\u0001E\u0001B\u0003&1)\u0001\buC\ndW\rV=qK:\u000bW.\u001a\u0011\t\u0015\u0005U\u0001\u0001#b\u0001\n\u0003\t9\"A\u0006qe&l\u0017M]=LKf\u001cXCAA\r!\u0011\t\u00121D\"\n\u0007\u0005u!CA\u0003BeJ\f\u0017\u0010\u0003\u0006\u0002\"\u0001A\t\u0011)Q\u0005\u00033\tA\u0002\u001d:j[\u0006\u0014\u0018pS3zg\u0002B!\"!\n\u0001\u0011\u000b\u0007I\u0011AA\u0014\u00035\u0001(/Z\"p[\nLg.Z&fsV\u0011\u0011\u0011\u0006\t\u0005#\u0005-2)C\u0002\u0002.I\u0011aa\u00149uS>t\u0007BCA\u0019\u0001!\u0005\t\u0015)\u0003\u0002*\u0005q\u0001O]3D_6\u0014\u0017N\\3LKf\u0004\u0003BCA\u001b\u0001!\u0015\r\u0011\"\u0001\u0002\u0018\u0005y\u0001/\u0019:uSRLwN\u001c$jK2$7\u000f\u0003\u0006\u0002:\u0001A\t\u0011)Q\u0005\u00033\t\u0001\u0003]1si&$\u0018n\u001c8GS\u0016dGm\u001d\u0011\t\u0015\u0005u\u0002\u0001#b\u0001\n\u0003\ty$A\u0006uC\ndWmU2iK6\fWCAA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$\r\u0005)A/\u001f9fg&!\u00111JA#\u0005)\u0019FO];diRK\b/\u001a\u0005\u000b\u0003\u001f\u0002\u0001\u0012!Q!\n\u0005\u0005\u0013\u0001\u0004;bE2,7k\u00195f[\u0006\u0004\u0003BCA*\u0001!\u0015\r\u0011\"\u0001\u0002@\u0005aB/\u00192mKN\u001b\u0007.Z7b/&$\bn\\;u\u001b\u0016$\u0018MR5fY\u0012\u001c\bBCA,\u0001!\u0005\t\u0015)\u0003\u0002B\u0005iB/\u00192mKN\u001b\u0007.Z7b/&$\bn\\;u\u001b\u0016$\u0018MR5fY\u0012\u001c\b\u0005\u0003\u0006\u0002\\\u0001A)\u0019!C\u0001\u0003\u007f\t!\u0002Z1uCN\u001b\u0007.Z7b\u0011)\ty\u0006\u0001E\u0001B\u0003&\u0011\u0011I\u0001\fI\u0006$\u0018mU2iK6\f\u0007\u0005\u0003\u0006\u0002d\u0001A)\u0019!C\u0001\u0003\u007f\t1\u0004Z1uCN\u001b\u0007.Z7b/&$\bn\\;u\u001b\u0016$\u0018MR5fY\u0012\u001c\bBCA4\u0001!\u0005\t\u0015)\u0003\u0002B\u0005aB-\u0019;b'\u000eDW-\\1XSRDw.\u001e;NKR\fg)[3mIN\u0004\u0003BCA6\u0001!\u0015\r\u0011\"\u0001\u0002@\u0005y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\r\u0003\u0006\u0002p\u0001A\t\u0011)Q\u0005\u0003\u0003\n\u0001\u0003]1si&$\u0018n\u001c8TG\",W.\u0019\u0011\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005!r-\u001a;BY2\u0004\u0016M\u001d;ji&|g\u000eU1uQN,\"!a\u001e\u0011\u000b\u0005e\u0014\u0011R\"\u000f\t\u0005m\u0014Q\u0011\b\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012bAAD%\u00059\u0001/Y2lC\u001e,\u0017\u0002BAF\u0003\u001b\u00131aU3r\u0015\r\t9I\u0005\u0005\b\u0003#\u0003A\u0011AAJ\u0003=Ig.\u001b;I_>$\u0017.\u001a+bE2,GCAAK!\r\t\u0012qS\u0005\u0004\u00033\u0013\"\u0001B+oSRDq!!(\u0001\t\u0013\ty*A\u000bqCJ\u001cXmU2iK6\f\u0017I\u001c3D_:4\u0017nZ:\u0015\u0005\u0005\u0005\u0006CB\t\u0002$\u0006\u0005s*C\u0002\u0002&J\u0011a\u0001V;qY\u0016\u0014\u0004bBAU\u0001\u0011%\u00111V\u0001\u0011Kb$(/\u0019+bE2,7i\u001c8gS\u001e$raTAW\u0003c\u000b)\fC\u0004\u00020\u0006\u001d\u0006\u0019\u0001\u0010\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u0005M\u0016q\u0015a\u00017\u0006i\u0011n\u001d+bE2,W\t_5tiND\u0011\"a.\u0002(B\u0005\t\u0019A(\u0002#=\u0014\u0018nZ5o)\u0006\u0014G.Z\"p]\u001aLw\rC\u0004\u0002<\u0002!I!!0\u0002!Y,'/\u001b4z\t\u0006$\u0018mU2iK6\fG\u0003CAK\u0003\u007f\u000bY-a5\t\u0011\u0005\u0005\u0017\u0011\u0018a\u0001\u0003\u0007\fq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM\u001d\t\u0005\u0003\u000b\f9-D\u0001\u0005\u0013\r\tI\r\u0002\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"910!/A\u0002\u00055\u0007c\u0001\u0015\u0002P&\u0019\u0011\u0011\u001b\u0002\u0003!\r\u000bG/\u00197pOR\u000b'\r\\3UsB,\u0007\u0002CA.\u0003s\u0003\r!!6\u0011\r\u0005e\u0014\u0011RAl!\u0011\t\u0019%!7\n\t\u0005m\u0017Q\t\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rC\u0005\u0002`\u0002\t\n\u0011\"\u0003\u0002b\u0006QR\r\u001f;sCR\u000b'\r\\3D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u001d\u0016\u0004\u001f\u0006\u00158FAAt!\u0011\tI/a=\u000e\u0005\u0005-(\u0002BAw\u0003_\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E(#\u0001\u0006b]:|G/\u0019;j_:LA!!>\u0002l\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u000f\u0005e(\u0001#\u0001\u0002|\u0006\u0011\u0002j\\8eS\u0016\u001c\u0015\r^1m_\u001e$\u0016M\u00197f!\rA\u0013Q \u0004\u0007\u0003\tA\t!a@\u0014\u0007\u0005u\b\u0003C\u0004/\u0003{$\tAa\u0001\u0015\u0005\u0005m\b\u0002\u0003B\u0004\u0003{$\tA!\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bA\u0012YA!\u0004\t\u000f\u0005=&Q\u0001a\u0001=!A\u0011\u0011\u0019B\u0003\u0001\u0004\t\u0019\r\u0003\u0005\u0003\b\u0005uH\u0011\u0001B\t)\u0015\u0001$1\u0003B\u000b\u0011\u001d\tyKa\u0004A\u0002yAqAa\u0006\u0003\u0010\u0001\u0007q%\u0001\u0007dCR\fGn\\4UC\ndW\r")
public class HoodieCatalogTable
implements Logging {
    private final SparkSession spark;
    private final CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType dataSchemaWithoutMetaFields;
    private StructType partitionSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.hadoopConf()).build();
                this.bitmap$0 |= 1;
            }
            return this.metaClient;
        }
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
            return this.tableConfig;
        }
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
            return this.tableName;
        }
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 8;
            }
            return this.tableType;
        }
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x10;
            }
            return this.tableTypeName;
        }
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x20;
            }
            return this.primaryKeys;
        }
    }

    private Option preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x40;
            }
            return this.preCombineKey;
        }
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x80;
            }
            return this.partitionFields;
        }
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                StructType originSchema = (StructType)HoodieSqlUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;

                    public final StructType apply() {
                        return this.$outer.table().schema();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.tableSchema = StructType$.MODULE$.apply((Seq)originSchema.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(StructField x$2) {
                        boolean x$6 = true;
                        String x$7 = x$2.copy$default$1();
                        DataType x$8 = x$2.copy$default$2();
                        Metadata x$9 = x$2.copy$default$4();
                        return x$2.copy(x$7, x$8, x$6, x$9);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
                this.bitmap$0 |= 0x100;
            }
            return this.tableSchema;
        }
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x200;
            }
            return this.tableSchemaWithoutMetaFields;
        }
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;

                    public final boolean apply(StructField f) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.partitionFields()).contains((Object)f.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.bitmap$0 |= 0x400;
            }
            return this.dataSchema;
        }
    }

    private StructType dataSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.dataSchemaWithoutMetaFields = HoodieSqlUtils$.MODULE$.removeMetaFields(this.dataSchema());
                this.bitmap$0 |= 0x800;
            }
            return this.dataSchemaWithoutMetaFields;
        }
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;

                    public final boolean apply(StructField f) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.partitionFields()).contains((Object)f.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.bitmap$0 |= 0x1000;
            }
            return this.partitionSchema;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    public HoodieTableMetaClient metaClient() {
        return (this.bitmap$0 & 1) == 0 ? this.metaClient$lzycompute() : this.metaClient;
    }

    public HoodieTableConfig tableConfig() {
        return (this.bitmap$0 & 2) == 0 ? this.tableConfig$lzycompute() : this.tableConfig;
    }

    public String tableName() {
        return (this.bitmap$0 & 4) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    public HoodieTableType tableType() {
        return (this.bitmap$0 & 8) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    public String tableTypeName() {
        return (this.bitmap$0 & 0x10) == 0 ? this.tableTypeName$lzycompute() : this.tableTypeName;
    }

    public String[] primaryKeys() {
        return (this.bitmap$0 & 0x20) == 0 ? this.primaryKeys$lzycompute() : this.primaryKeys;
    }

    public Option<String> preCombineKey() {
        return (this.bitmap$0 & 0x40) == 0 ? this.preCombineKey$lzycompute() : this.preCombineKey;
    }

    public String[] partitionFields() {
        return (this.bitmap$0 & 0x80) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    public StructType tableSchema() {
        return (this.bitmap$0 & 0x100) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    public StructType tableSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x200) == 0 ? this.tableSchemaWithoutMetaFields$lzycompute() : this.tableSchemaWithoutMetaFields;
    }

    public StructType dataSchema() {
        return (this.bitmap$0 & 0x400) == 0 ? this.dataSchema$lzycompute() : this.dataSchema;
    }

    public StructType dataSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x800) == 0 ? this.dataSchemaWithoutMetaFields$lzycompute() : this.dataSchemaWithoutMetaFields;
    }

    public StructType partitionSchema() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public Seq<String> getAllPartitionPaths() {
        return HoodieSqlUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table());
    }

    public void initHoodieTable() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieCatalogTable $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Init hoodie.properties for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.table().identifier().unquotedString()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Tuple2<StructType, scala.collection.immutable.Map<String, String>> tuple2 = this.parseSchemaAndConfigs();
        if (tuple2 != null) {
            Tuple2 tuple22;
            StructType finalSchema = (StructType)tuple2._1();
            scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
            StructType finalSchema2 = (StructType)tuple23._1();
            scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple23._2();
            Properties properties = new Properties();
            properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs2).asJava()));
            HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setTableName(this.table().identifier().table()).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema2, SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()).toString()).setPartitionFields(this.table().partitionColumnNames().mkString(",")).initTable(this.hadoopConf(), this.tableLocation());
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        Tuple2 tuple2;
        block8: {
            Tuple2 tuple22;
            block7: {
                boolean bl;
                scala.collection.immutable.Map<String, String> sqlOptions;
                scala.collection.immutable.Map<String, String> globalTableConfigs;
                block6: {
                    scala.collection.immutable.Map globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                    globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
                    scala.collection.immutable.Map<String, String> globalSqlOptions = HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption(globalTableConfigs);
                    sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(this.catalogProperties()));
                    tuple2 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
                    if (tuple2 == null) break block6;
                    CatalogTableType catalogTableType = (CatalogTableType)tuple2._1();
                    boolean bl2 = tuple2._2$mcZ$sp();
                    CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
                    CatalogTableType catalogTableType3 = catalogTableType;
                    if ((catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) || !bl2) break block6;
                    scala.collection.immutable.Map existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                    scala.collection.immutable.Map currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
                    scala.collection.immutable.Map<String, String> catalogTableProps = HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(this.catalogProperties());
                    HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
                    scala.collection.immutable.Map options = this.extraTableConfig(this.spark(), this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
                    ValidationUtils.checkArgument(this.tableSchema().nonEmpty() || this.table().schema().nonEmpty(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing schema for Create Table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()})));
                    StructType schema2 = this.tableSchema().nonEmpty() ? this.tableSchema() : HoodieSqlUtils$.MODULE$.addMetaFields(this.table().schema());
                    tuple22 = new Tuple2((Object)schema2, (Object)options);
                    break block7;
                }
                if (tuple2 == null || (bl = tuple2._2$mcZ$sp())) break block8;
                ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing schema for Create Table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()})));
                StructType schema3 = this.table().schema();
                scala.collection.immutable.Map options = this.extraTableConfig(this.spark(), false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions));
                tuple22 = new Tuple2((Object)HoodieSqlUtils$.MODULE$.addMetaFields(schema3), (Object)options);
            }
            Tuple2 tuple23 = tuple22;
            if (tuple23 != null) {
                Tuple2 tuple24;
                StructType finalSchema = (StructType)tuple23._1();
                scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple23._2();
                Tuple2 tuple25 = tuple24 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
                StructType finalSchema2 = (StructType)tuple25._1();
                scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple25._2();
                HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema2, HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption((scala.collection.immutable.Map<String, String>)tableConfigs2));
                Function2 resolver = this.spark().sessionState().conf().resolver();
                Seq dataSchema2 = (Seq)finalSchema2.filterNot((Function1)new Serializable(this, resolver){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;
                    public final Function2 resolver$1;

                    public final boolean apply(StructField f) {
                        return this.$outer.table().partitionColumnNames().exists((Function1)new Serializable(this, f){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4 $outer;
                            private final StructField f$1;

                            public final boolean apply(String x$5) {
                                return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)x$5, (Object)this.f$1.name()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.f$1 = f$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.resolver$1 = resolver$1;
                    }
                });
                this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema2);
                return new Tuple2((Object)finalSchema2, (Object)tableConfigs2);
            }
            throw new MatchError((Object)tuple23);
        }
        if (tuple2 != null) {
            CatalogTableType catalogTableType = (CatalogTableType)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
            CatalogTableType catalogTableType5 = catalogTableType;
            if (!(catalogTableType4 != null ? !catalogTableType4.equals(catalogTableType5) : catalogTableType5 != null) && bl) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not create the managed table('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". The associated location('", "') already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableLocation()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(SparkSession sparkSession, boolean isTableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (isTableExists) {
            Seq<String> allPartitionPaths = this.getAllPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)ComplexKeyGenerator.class.getCanonicalName());
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema2) {
        CatalogTableType catalogTableType = tableType;
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2)) {
            Seq invalidChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ":", ";"}));
            dataSchema2.foreach((Function1)new Serializable(this, tableIdentifier, invalidChars){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HoodieCatalogTable $outer;
                private final TableIdentifier tableIdentifier$1;
                private final Seq invalidChars$1;

                public final void apply(StructField f) {
                    DataType dataType = f.dataType();
                    if (f.name().contains(",")) {
                        throw new AnalysisException(new StringBuilder().append((Object)"Cannot create a table having a column whose name ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"contains commas in Hive metastore. Table: ", "; Column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentifier$1, f.name()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(structType, this.tableIdentifier$1, this.invalidChars$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tableIdentifier$1 = tableIdentifier$1;
                    this.invalidChars$1 = invalidChars$1;
                }
            });
        }
    }

    public final void org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(StructType schema2, TableIdentifier tableIdentifier$1, Seq invalidChars$1) {
        schema2.foreach((Function1)new Serializable(this, tableIdentifier$1, invalidChars$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieCatalogTable $outer;
            private final TableIdentifier tableIdentifier$1;
            private final Seq invalidChars$1;

            public final void apply(StructField f) {
                DataType dataType = f.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(structType, this.tableIdentifier$1, this.invalidChars$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (this.invalidChars$1.exists((Function1)new Serializable(this, f){
                        public static final long serialVersionUID = 0L;
                        private final StructField f$2;

                        public final boolean apply(CharSequence x$1) {
                            return this.f$2.name().contains(x$1);
                        }
                        {
                            this.f$2 = f$2;
                        }
                    })) {
                        String invalidCharsString = ((TraversableOnce)this.invalidChars$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String c) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                        String errMsg = new StringBuilder().append((Object)"Cannot create a table having a nested column whose name contains ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid characters (", ") in Hive metastore. Table: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidCharsString, this.tableIdentifier$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name()}))).toString();
                        throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableIdentifier$1 = tableIdentifier$1;
                this.invalidChars$1 = invalidChars$1;
            }
        });
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.class.$init$((Logging)this);
        Object object = table.provider().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT);
            }
        }).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "It's not a Hudi table";
            }
        });
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = table.qualifiedName();
        this.catalogProperties = table.storage().properties().$plus$plus((GenTraversableOnce)table.properties());
        this.tableLocation = HoodieSqlUtils$.MODULE$.getTableLocation(table, spark);
        this.hoodieTableExists = HoodieSqlUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }
}

