/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001>\u00111%\u00117uKJDun\u001c3jKR\u000b'\r\\3DQ\u0006tw-Z\"pYVlgnQ8n[\u0006tGM\u0003\u0002\u0004\t\u000591m\\7nC:$'BA\u0003\u0007\u0003\u0011AW\u000fZ5\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"$I\u0014\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u00037}i\u0011\u0001\b\u0006\u0003\u0007uQ!A\b\u0004\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001\u0011\u001d\u0005=\u0011VO\u001c8bE2,7i\\7nC:$\u0007C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#a\u0002)s_\u0012,8\r\u001e\t\u0003E!J!!K\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011-\u0002!Q3A\u0005\u00021\nq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM]\u000b\u0002[A\u0011afL\u0007\u0002-%\u0011\u0001G\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"A!\u0007\u0001B\tB\u0003%Q&\u0001\tuC\ndW-\u00133f]RLg-[3sA!AA\u0007\u0001BK\u0002\u0013\u0005Q'\u0001\u0006d_2,XN\u001c(b[\u0016,\u0012A\u000e\t\u0003oir!A\t\u001d\n\u0005e\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!O\u0012\t\u0011y\u0002!\u0011#Q\u0001\nY\n1bY8mk6tg*Y7fA!A\u0001\t\u0001BK\u0002\u0013\u0005\u0011)A\u0005oK^\u001cu\u000e\\;n]V\t!\t\u0005\u0002D\r6\tAI\u0003\u0002F\r\u0005)A/\u001f9fg&\u0011q\t\u0012\u0002\f'R\u0014Xo\u0019;GS\u0016dG\r\u0003\u0005J\u0001\tE\t\u0015!\u0003C\u0003)qWm^\"pYVlg\u000e\t\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5{\u0005+\u0015\t\u0003\u001d\u0002i\u0011A\u0001\u0005\u0006W)\u0003\r!\f\u0005\u0006i)\u0003\rA\u000e\u0005\u0006\u0001*\u0003\rA\u0011\u0005\u0006'\u0002!\t\u0005V\u0001\u0004eVtGCA+f!\r1f,\u0019\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013BA/$\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0007M+\u0017O\u0003\u0002^GA\u0011!mY\u0007\u0002\r%\u0011AM\u0002\u0002\u0004%><\b\"\u00024S\u0001\u00049\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u00012i\u0013\tIgA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003l\u0001\u0011%A.\u0001\bwC2LG-\u0019;f'\u000eDW-\\1\u0015\u00075\u0004\b\u0010\u0005\u0002#]&\u0011qn\t\u0002\u0005+:LG\u000fC\u0003rU\u0002\u0007!/A\u0005oK^\u001c6\r[3nCB\u00111O^\u0007\u0002i*\u0011QOC\u0001\u0005CZ\u0014x.\u0003\u0002xi\n11k\u00195f[\u0006DQ!\u001f6A\u0002i\f!\"\\3uC\u000ec\u0017.\u001a8u!\rY\u00181A\u0007\u0002y*\u0011QP`\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0004\u007f\u0006\u0005\u0011AB2p[6|gN\u0003\u0002\u0006\u0015%\u0019\u0011Q\u0001?\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\"I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00111B\u0001\u0005G>\u0004\u0018\u0010F\u0004N\u0003\u001b\ty!!\u0005\t\u0011-\n9\u0001%AA\u00025B\u0001\u0002NA\u0004!\u0003\u0005\rA\u000e\u0005\t\u0001\u0006\u001d\u0001\u0013!a\u0001\u0005\"I\u0011Q\u0003\u0001\u0012\u0002\u0013\u0005\u0011qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIBK\u0002.\u00037Y#!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\u0019\u0013AC1o]>$\u0018\r^5p]&!\u00111FA\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003_\u0001\u0011\u0013!C\u0001\u0003c\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00024)\u001aa'a\u0007\t\u0013\u0005]\u0002!%A\u0005\u0002\u0005e\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003wQ3AQA\u000e\u0011%\ty\u0004AA\u0001\n\u0003\n\t%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0003mC:<'BAA'\u0003\u0011Q\u0017M^1\n\u0007m\n9\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u000b\t\u0004E\u0005e\u0013bAA.G\t\u0019\u0011J\u001c;\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003G\nI\u0007E\u0002#\u0003KJ1!a\u001a$\u0005\r\te.\u001f\u0005\u000b\u0003W\ni&!AA\u0002\u0005]\u0013a\u0001=%c!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0013\u0011O\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000f\t\u0007\u0003k\nY(a\u0019\u000e\u0005\u0005]$bAA=G\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0014q\u000f\u0002\t\u0013R,'/\u0019;pe\"I\u0011\u0011\u0011\u0001\u0002\u0002\u0013\u0005\u00111Q\u0001\tG\u0006tW)];bYR!\u0011QQAF!\r\u0011\u0013qQ\u0005\u0004\u0003\u0013\u001b#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003W\ny(!AA\u0002\u0005\r\u0004\"CAH\u0001\u0005\u0005I\u0011IAI\u0003\u0019)\u0017/^1mgR!\u0011QQAJ\u0011)\tY'!$\u0002\u0002\u0003\u0007\u00111M\u0004\n\u0003/\u0013\u0011\u0011!E\u0001\u00033\u000b1%\u00117uKJDun\u001c3jKR\u000b'\r\\3DQ\u0006tw-Z\"pYVlgnQ8n[\u0006tG\rE\u0002O\u000373\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QT\n\u0006\u00037\u000byj\n\t\t\u0003C\u000b9+\f\u001cC\u001b6\u0011\u00111\u0015\u0006\u0004\u0003K\u001b\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003S\u000b\u0019KA\tBEN$(/Y2u\rVt7\r^5p]NBqaSAN\t\u0003\ti\u000b\u0006\u0002\u0002\u001a\"Q\u0011\u0011WAN\u0003\u0003%)%a-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0011\t\u0015\u0005]\u00161TA\u0001\n\u0003\u000bI,A\u0003baBd\u0017\u0010F\u0004N\u0003w\u000bi,a0\t\r-\n)\f1\u0001.\u0011\u0019!\u0014Q\u0017a\u0001m!1\u0001)!.A\u0002\tC!\"a1\u0002\u001c\u0006\u0005I\u0011QAc\u0003\u001d)h.\u00199qYf$B!a2\u0002TB)!%!3\u0002N&\u0019\u00111Z\u0012\u0003\r=\u0003H/[8o!\u0019\u0011\u0013qZ\u00177\u0005&\u0019\u0011\u0011[\u0012\u0003\rQ+\b\u000f\\34\u0011%\t).!1\u0002\u0002\u0003\u0007Q*A\u0002yIAB!\"!7\u0002\u001c\u0006\u0005I\u0011BAn\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0007\u0003BA#\u0003?LA!!9\u0002H\t1qJ\u00196fGR\u0004")
public class AlterHoodieTableChangeColumnCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableIdentifier;
    private final String columnName;
    private final StructField newColumn;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand) {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.unapply(alterHoodieTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterHoodieTableChangeColumnCommand> tupled() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterHoodieTableChangeColumnCommand>>> curried() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = this;
        synchronized (alterHoodieTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.class.metrics((RunnableCommand)this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Row> run(SparkSession sparkSession) {
        Tuple2 tuple2;
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)this.columnName(), (Object)this.newColumn().name()))) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not support change column name for hudi table currently."})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        StructType newTableSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.tableSchema().fields()).map((Function1)new Serializable(this, resolver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterHoodieTableChangeColumnCommand $outer;
            private final Function2 resolver$1;

            public final StructField apply(StructField field) {
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)field.name(), (Object)this.$outer.columnName())) ? this.$outer.newColumn() : field;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$1 = resolver$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        StructType newDataSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fields()).map((Function1)new Serializable(this, resolver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterHoodieTableChangeColumnCommand $outer;
            private final Function2 resolver$1;

            public final StructField apply(StructField field) {
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)field.name(), (Object)this.$outer.columnName())) ? this.$outer.newColumn() : field;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$1 = resolver$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Tuple2<String, String> tuple22 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tableIdentifier().table());
        if (tuple22 == null) throw new MatchError(tuple22);
        String structName = (String)tuple22._1();
        String nameSpace = (String)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)structName, (Object)nameSpace);
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        Schema newSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(newTableSchema, structName2, nameSpace2);
        this.validateSchema(newSchema, hoodieCatalogTable.metaClient());
        AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(newSchema, hoodieCatalogTable, sparkSession);
        try {
            sparkSession.catalog().uncacheTable(this.tableIdentifier().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentifier().quotedString()})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        sparkSession.sessionState().catalog().alterTableDataSchema(this.tableIdentifier(), newDataSchema);
        return (Seq)Seq$.MODULE$.empty();
    }

    private void validateSchema(Schema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        Schema tableSchema2 = HoodieAvroUtils.createHoodieWriteSchema(schemaUtil.getTableAvroSchemaWithoutMetadataFields());
        if (TableSchemaResolver.isSchemaCompatible(tableSchema2, newSchema)) {
            return;
        }
        throw new HoodieException(new StringBuilder().append((Object)"Failed schema compatibility check for newSchema :").append((Object)newSchema).append((Object)", origin table schema :").append((Object)tableSchema2).append((Object)", base path :").append((Object)metaClient.getBasePath()).toString());
    }

    public AlterHoodieTableChangeColumnCommand copy(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        return new AlterHoodieTableChangeColumnCommand(tableIdentifier, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterHoodieTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 0: {
                object = this.tableIdentifier();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = (AlterHoodieTableChangeColumnCommand)((Object)x$1);
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = alterHoodieTableChangeColumnCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterHoodieTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterHoodieTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterHoodieTableChangeColumnCommand.canEqual((Object)this)) return false;
        return true;
    }

    public AlterHoodieTableChangeColumnCommand(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        this.tableIdentifier = tableIdentifier;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.class.$init$((Command)this);
        RunnableCommand.class.$init$((RunnableCommand)this);
    }
}

