/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.subject;

import io.confluent.kafka.serializers.AvroSchemaUtils;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.kafka.common.errors.SerializationException;

public class RecordNameStrategy
implements io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy<Schema>,
SubjectNameStrategy {
    @Override
    public void configure(Map<String, ?> config) {
    }

    @Override
    public String subjectName(String topic, boolean isKey, Schema schema2) {
        return this.getRecordName(schema2, isKey);
    }

    protected String getRecordName(Schema schema2, boolean isKey) {
        if (schema2 != null && schema2.getType() == Schema.Type.RECORD) {
            return schema2.getFullName();
        }
        if (isKey) {
            throw new SerializationException("In configuration key.subject.name.strategy = " + this.getClass().getName() + ", the message key must only be an Avro record schema");
        }
        throw new SerializationException("In configuration value.subject.name.strategy = " + this.getClass().getName() + ", the message value must only be an Avro record schema");
    }

    @Override
    @Deprecated
    public String getSubjectName(String topic, boolean isKey, Object value) {
        return this.subjectName(topic, isKey, AvroSchemaUtils.getSchema(value));
    }
}

