/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.runtime.ObjectRef;

public final class HoodieCLIUtils$ {
    public static final HoodieCLIUtils$ MODULE$;

    static {
        new HoodieCLIUtils$();
    }

    public SparkRDDWriteClient<?> createHoodieClientFromPath(SparkSession sparkSession, String basePath, Map<String, String> conf) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(sparkSession.sessionState().newHadoopConf()).build();
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        String schemaStr = schemaUtil.getTableAvroSchemaWithoutMetadataFields().toString();
        Map<String, String> finalParameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(HoodieSqlCommonUtils$.MODULE$.withSparkConf(sparkSession, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)conf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)metaClient.getTableType().name()))));
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        return DataSourceUtils.createHoodieClient(jsc, schemaStr, basePath, metaClient.getTableConfig().getTableName(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(finalParameters).asJava());
    }

    public String extractPartitions(Seq<HoodieClusteringGroup> clusteringGroups) {
        ObjectRef partitionPaths = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
        clusteringGroups.foreach((Function1)new Serializable(partitionPaths){
            public static final long serialVersionUID = 0L;
            public final ObjectRef partitionPaths$1;

            public final void apply(HoodieClusteringGroup g) {
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(g.getSlices()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.extractPartitions.1 $outer;

                    public final void apply(HoodieSliceInfo slice) {
                        this.$outer.partitionPaths$1.elem = (Seq)((Seq)this.$outer.partitionPaths$1.elem).$colon$plus((Object)slice.getPartitionPath(), Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.partitionPaths$1 = partitionPaths$1;
            }
        });
        return ((TraversableOnce)((Seq)partitionPaths.elem).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public HoodieCatalogTable getHoodieCatalogTable(SparkSession sparkSession, String table) {
        block4: {
            HoodieCatalogTable hoodieCatalogTable;
            block3: {
                WrappedArray wrappedArray;
                block2: {
                    WrappedArray seq = Predef$.MODULE$.wrapRefArray((Object[])new StringOps(Predef$.MODULE$.augmentString(table)).split('.'));
                    wrappedArray = seq;
                    Some some = Seq$.MODULE$.unapplySeq((Seq)wrappedArray);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) break block2;
                    String tableName = (String)((SeqLike)some.get()).apply(0);
                    hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, TableIdentifier$.MODULE$.apply(tableName));
                    break block3;
                }
                Some some = Seq$.MODULE$.unapplySeq((Seq)wrappedArray);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block4;
                String database = (String)((SeqLike)some.get()).apply(0);
                String tableName = (String)((SeqLike)some.get()).apply(1);
                hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, new TableIdentifier(tableName, (Option)new Some((Object)database)));
            }
            return hoodieCatalogTable;
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported identifier ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
    }

    private HoodieCLIUtils$() {
        MODULE$ = this;
    }
}

