/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class OptimisticConsistencyGuard
extends FailSafeConsistencyGuard {
    private static final Logger LOG = LogManager.getLogger(OptimisticConsistencyGuard.class);

    public OptimisticConsistencyGuard(FileSystem fs, ConsistencyGuardConfig consistencyGuardConfig) {
        super(fs, consistencyGuardConfig);
    }

    @Override
    public void waitTillFileAppears(Path filePath) throws TimeoutException {
        try {
            if (!this.checkFileVisibility(filePath, ConsistencyGuard.FileVisibility.APPEAR)) {
                Thread.sleep(this.consistencyGuardConfig.getOptimisticConsistencyGuardSleepTimeMs());
            }
        }
        catch (IOException | InterruptedException ioe) {
            LOG.warn((Object)"Got IOException or InterruptedException waiting for file visibility. Ignoring", (Throwable)ioe);
        }
    }

    @Override
    public void waitTillFileDisappears(Path filePath) throws TimeoutException {
    }

    @Override
    public void waitTillAllFilesAppear(String dirPath, List<String> files) throws TimeoutException {
        try {
            if (!this.checkFilesVisibility(1, new Path(dirPath), this.getFilesWithoutSchemeAndAuthority(files), ConsistencyGuard.FileVisibility.APPEAR)) {
                Thread.sleep(this.consistencyGuardConfig.getOptimisticConsistencyGuardSleepTimeMs());
            }
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)"Got InterruptedException waiting for file visibility. Ignoring", (Throwable)ie);
        }
    }

    @Override
    public void waitTillAllFilesDisappear(String dirPath, List<String> files) throws TimeoutException {
    }
}

