/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.debezium.AbstractDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PostgresDebeziumAvroPayload
extends AbstractDebeziumAvroPayload {
    private static final Logger LOG = LogManager.getLogger(PostgresDebeziumAvroPayload.class);
    public static final String DEBEZIUM_TOASTED_VALUE = "__debezium_unavailable_value";

    public PostgresDebeziumAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public PostgresDebeziumAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    private Long extractLSN(IndexedRecord record) {
        GenericRecord genericRecord = (GenericRecord)record;
        return (Long)genericRecord.get("_event_lsn");
    }

    @Override
    protected boolean shouldPickCurrentRecord(IndexedRecord currentRecord, IndexedRecord insertRecord, Schema schema2) throws IOException {
        Long currentSourceLSN = this.extractLSN(currentRecord);
        Long insertSourceLSN = this.extractLSN(insertRecord);
        return insertSourceLSN < currentSourceLSN;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema2, Properties properties) throws IOException {
        Option<IndexedRecord> insertOrDeleteRecord = super.combineAndGetUpdateValue(currentValue, schema2, properties);
        if (insertOrDeleteRecord.isPresent()) {
            this.mergeToastedValuesIfPresent(insertOrDeleteRecord.get(), currentValue);
        }
        return insertOrDeleteRecord;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema2) throws IOException {
        Option<IndexedRecord> insertOrDeleteRecord = super.combineAndGetUpdateValue(currentValue, schema2);
        if (insertOrDeleteRecord.isPresent()) {
            this.mergeToastedValuesIfPresent(insertOrDeleteRecord.get(), currentValue);
        }
        return insertOrDeleteRecord;
    }

    private void mergeToastedValuesIfPresent(IndexedRecord incomingRecord, IndexedRecord currentRecord) {
        List fields = incomingRecord.getSchema().getFields();
        fields.forEach(field -> {
            if (((GenericData.Record)incomingRecord).get(field.name()) != null && (this.containsStringToastedValues(incomingRecord, (Schema.Field)field) || this.containsBytesToastedValues(incomingRecord, (Schema.Field)field))) {
                ((GenericData.Record)incomingRecord).put(field.name(), ((GenericData.Record)currentRecord).get(field.name()));
            }
        });
    }

    private boolean containsStringToastedValues(IndexedRecord incomingRecord, Schema.Field field) {
        return (field.schema().getType() == Schema.Type.STRING || field.schema().getType() == Schema.Type.UNION && field.schema().getTypes().stream().anyMatch(s -> s.getType() == Schema.Type.STRING)) && ((CharSequence)((GenericData.Record)incomingRecord).get(field.name())).length() == DEBEZIUM_TOASTED_VALUE.length() && DEBEZIUM_TOASTED_VALUE.equals(((CharSequence)((GenericData.Record)incomingRecord).get(field.name())).toString());
    }

    private boolean containsBytesToastedValues(IndexedRecord incomingRecord, Schema.Field field) {
        return (field.schema().getType() == Schema.Type.BYTES || field.schema().getType() == Schema.Type.UNION && field.schema().getTypes().stream().anyMatch(s -> s.getType() == Schema.Type.BYTES)) && ((ByteBuffer)((GenericData.Record)incomingRecord).get(field.name())).array().length == DEBEZIUM_TOASTED_VALUE.length() && DEBEZIUM_TOASTED_VALUE.equals(new String(((ByteBuffer)((GenericData.Record)incomingRecord).get(field.name())).array(), StandardCharsets.UTF_8));
    }
}

