/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;

public class HoodieFileSliceReader<T extends HoodieRecordPayload>
implements Iterator<HoodieRecord<T>> {
    private final Iterator<HoodieRecord<T>> recordsIterator;

    public static HoodieFileSliceReader getFileSliceReader(Option<HoodieFileReader> baseFileReader, HoodieMergedLogRecordScanner scanner, Schema schema2, String payloadClass, String preCombineField, Option<Pair<String, String>> simpleKeyGenFieldsOpt) throws IOException {
        if (baseFileReader.isPresent()) {
            ClosableIterator baseIterator = baseFileReader.get().getRecordIterator(schema2);
            while (baseIterator.hasNext()) {
                GenericRecord record = (GenericRecord)baseIterator.next();
                HoodieRecord<HoodieRecordPayload> hoodieRecord = HoodieFileSliceReader.transform(record, scanner, payloadClass, preCombineField, simpleKeyGenFieldsOpt);
                scanner.processNextRecord(hoodieRecord);
            }
            return new HoodieFileSliceReader(scanner.iterator());
        }
        Iterable iterable = () -> scanner.iterator();
        HoodiePayloadConfig payloadConfig = HoodiePayloadConfig.newBuilder().withPayloadOrderingField(preCombineField).build();
        return new HoodieFileSliceReader(StreamSupport.stream(iterable.spliterator(), false).map(e -> {
            try {
                GenericRecord record = (GenericRecord)((HoodieRecordPayload)e.getData()).getInsertValue(schema2, payloadConfig.getProps()).get();
                return HoodieFileSliceReader.transform(record, scanner, payloadClass, preCombineField, simpleKeyGenFieldsOpt);
            }
            catch (IOException io) {
                throw new HoodieIOException("Error while creating reader for file slice with no base file.", io);
            }
        }).iterator());
    }

    private static HoodieRecord<? extends HoodieRecordPayload> transform(GenericRecord record, HoodieMergedLogRecordScanner scanner, String payloadClass, String preCombineField, Option<Pair<String, String>> simpleKeyGenFieldsOpt) {
        return simpleKeyGenFieldsOpt.isPresent() ? (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(record, payloadClass, preCombineField, simpleKeyGenFieldsOpt.get(), scanner.isWithOperationField(), Option.empty()) : (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(record, payloadClass, preCombineField, scanner.isWithOperationField(), scanner.getPartitionName());
    }

    private HoodieFileSliceReader(Iterator<HoodieRecord<T>> recordsItr) {
        this.recordsIterator = recordsItr;
    }

    @Override
    public boolean hasNext() {
        return this.recordsIterator.hasNext();
    }

    @Override
    public HoodieRecord<T> next() {
        return this.recordsIterator.next();
    }
}

