/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieWriteStat;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CommitUtils {
    private static final Logger LOG = LogManager.getLogger(CommitUtils.class);
    private static final String NULL_SCHEMA_STR = Schema.create((Schema.Type)Schema.Type.NULL).toString();

    public static String getCommitActionType(WriteOperationType operation, HoodieTableType tableType) {
        if (operation == WriteOperationType.INSERT_OVERWRITE || operation == WriteOperationType.INSERT_OVERWRITE_TABLE || operation == WriteOperationType.DELETE_PARTITION) {
            return "replacecommit";
        }
        return CommitUtils.getCommitActionType(tableType);
    }

    public static String getCommitActionType(HoodieTableType tableType) {
        switch (tableType) {
            case COPY_ON_WRITE: {
                return "commit";
            }
            case MERGE_ON_READ: {
                return "deltacommit";
            }
        }
        throw new HoodieException("Could not commit on unknown table type " + (Object)((Object)tableType));
    }

    public static HoodieCommitMetadata buildMetadata(List<org.apache.hudi.common.model.HoodieWriteStat> writeStats, Map<String, List<String>> partitionToReplaceFileIds, Option<Map<String, String>> extraMetadata, WriteOperationType operationType, String schemaToStoreInCommit, String commitActionType) {
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadataFromStats(writeStats, partitionToReplaceFileIds, commitActionType, operationType);
        if (extraMetadata.isPresent()) {
            extraMetadata.get().forEach(commitMetadata::addMetadata);
        }
        commitMetadata.addMetadata("schema", schemaToStoreInCommit == null || schemaToStoreInCommit.equals(NULL_SCHEMA_STR) ? "" : schemaToStoreInCommit);
        commitMetadata.setOperationType(operationType);
        return commitMetadata;
    }

    private static HoodieCommitMetadata buildMetadataFromStats(List<org.apache.hudi.common.model.HoodieWriteStat> writeStats, Map<String, List<String>> partitionToReplaceFileIds, String commitActionType, WriteOperationType operationType) {
        HoodieCommitMetadata commitMetadata;
        if ("replacecommit".equals(commitActionType)) {
            HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
            replaceMetadata.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
            commitMetadata = replaceMetadata;
        } else {
            commitMetadata = new HoodieCommitMetadata();
        }
        for (org.apache.hudi.common.model.HoodieWriteStat writeStat : writeStats) {
            String partition = writeStat.getPartitionPath();
            commitMetadata.addWriteStat(partition, writeStat);
        }
        LOG.info((Object)("Creating  metadata for " + (Object)((Object)operationType) + " numWriteStats:" + writeStats.size() + " numReplaceFileIds:" + partitionToReplaceFileIds.values().stream().mapToInt(e -> e.size()).sum()));
        return commitMetadata;
    }

    public static HashMap<String, String> getFileIdWithoutSuffixAndRelativePathsFromSpecificRecord(Map<String, List<HoodieWriteStat>> partitionToWriteStats) {
        HashMap<String, String> fileIdToPath = new HashMap<String, String>();
        for (Map.Entry<String, List<HoodieWriteStat>> entry : partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat stat : entry.getValue()) {
                fileIdToPath.put(stat.getFileId(), stat.getPath());
            }
        }
        return fileIdToPath;
    }

    public static HashMap<String, String> getFileIdWithoutSuffixAndRelativePaths(Map<String, List<org.apache.hudi.common.model.HoodieWriteStat>> partitionToWriteStats) {
        HashMap<String, String> fileIdToPath = new HashMap<String, String>();
        for (Map.Entry<String, List<org.apache.hudi.common.model.HoodieWriteStat>> entry : partitionToWriteStats.entrySet()) {
            for (org.apache.hudi.common.model.HoodieWriteStat stat : entry.getValue()) {
                fileIdToPath.put(stat.getFileId(), stat.getPath());
            }
        }
        return fileIdToPath;
    }

    public static Option<HoodieCommitMetadata> getLatestCommitMetadataWithValidCheckpointInfo(HoodieTimeline timeline, String checkpointKey) {
        return timeline.getReverseOrderedInstants().map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class);
                if (StringUtils.nonEmpty(commitMetadata.getMetadata(checkpointKey))) {
                    return Option.of(commitMetadata);
                }
                return Option.empty();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to parse HoodieCommitMetadata for " + instant.toString(), e);
            }
        }).filter(Option::isPresent).findFirst().orElse(Option.empty());
    }
}

