/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.RewriteAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.execution.bulkinsert.SpatialCurveSortPartitionerBase;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class RDDSpatialCurveSortPartitioner<T extends HoodieRecordPayload>
extends SpatialCurveSortPartitionerBase<JavaRDD<HoodieRecord<T>>> {
    private final transient HoodieSparkEngineContext sparkEngineContext;
    private final SerializableSchema schema;

    public RDDSpatialCurveSortPartitioner(HoodieSparkEngineContext sparkEngineContext, String[] orderByColumns, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, HoodieClusteringConfig.SpatialCurveCompositionStrategyType curveCompositionStrategyType, Schema schema2) {
        super(orderByColumns, layoutOptStrategy, curveCompositionStrategyType);
        this.sparkEngineContext = sparkEngineContext;
        this.schema = new SerializableSchema(schema2);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        JavaRDD genericRecordsRDD = records.map((Function & Serializable)f -> (GenericRecord)((HoodieRecordPayload)f.getData()).getInsertValue(this.schema.get()).get());
        Dataset<Row> sourceDataset = AvroConversionUtils.createDataFrame((RDD<GenericRecord>)genericRecordsRDD.rdd(), this.schema.toString(), this.sparkEngineContext.getSqlContext().sparkSession());
        Dataset<Row> sortedDataset = this.reorder(sourceDataset, outputSparkPartitions);
        return HoodieSparkUtils.createRdd(sortedDataset, this.schema.get().getName(), this.schema.get().getNamespace(), false, Option.empty()).toJavaRDD().map((Function & Serializable)record -> {
            String key = record.get("_hoodie_record_key").toString();
            String partition = record.get("_hoodie_partition_path").toString();
            HoodieKey hoodieKey = new HoodieKey(key, partition);
            HoodieAvroRecord<RewriteAvroPayload> hoodieRecord = new HoodieAvroRecord<RewriteAvroPayload>(hoodieKey, new RewriteAvroPayload((GenericRecord)record));
            return hoodieRecord;
        });
    }
}

