/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.BucketIndexLocationMapper;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieSimpleBucketIndex
extends HoodieBucketIndex {
    private static final Logger LOG = LogManager.getLogger(HoodieSimpleBucketIndex.class);

    public HoodieSimpleBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    private Map<Integer, HoodieRecordLocation> loadPartitionBucketIdFileIdMapping(HoodieTable hoodieTable, String partition) {
        HashMap<Integer, HoodieRecordLocation> bucketIdToFileIdMapping = new HashMap<Integer, HoodieRecordLocation>();
        hoodieTable.getMetaClient().reloadActiveTimeline();
        HoodieIndexUtils.getLatestFileSlicesForPartition(partition, hoodieTable).forEach(fileSlice -> {
            String fileId = fileSlice.getFileId();
            String commitTime = fileSlice.getBaseInstantTime();
            int bucketId = BucketIdentifier.bucketIdFromFileId(fileId);
            if (bucketIdToFileIdMapping.containsKey(bucketId)) {
                throw new HoodieIOException("Find multiple files at partition path=" + partition + " belongs to the same bucket id = " + bucketId);
            }
            bucketIdToFileIdMapping.put(bucketId, new HoodieRecordLocation(commitTime, fileId));
        });
        return bucketIdToFileIdMapping;
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    protected BucketIndexLocationMapper getLocationMapper(HoodieTable table, List<String> partitionPath) {
        return new SimpleBucketIndexLocationMapper(table, partitionPath);
    }

    public class SimpleBucketIndexLocationMapper
    implements BucketIndexLocationMapper {
        private final Map<String, Map<Integer, HoodieRecordLocation>> partitionPathFileIDList;

        public SimpleBucketIndexLocationMapper(HoodieTable table, List<String> partitions) {
            this.partitionPathFileIDList = partitions.stream().collect(Collectors.toMap(p -> p, p -> HoodieSimpleBucketIndex.this.loadPartitionBucketIdFileIdMapping(table, p)));
        }

        @Override
        public Option<HoodieRecordLocation> getRecordLocation(HoodieKey key, String partitionPath) {
            int bucketId = BucketIdentifier.getBucketId(key, HoodieSimpleBucketIndex.this.indexKeyFields, HoodieSimpleBucketIndex.this.numBuckets);
            Map<Integer, HoodieRecordLocation> bucketIdToFileIdMapping = this.partitionPathFileIDList.get(partitionPath);
            return Option.ofNullable(bucketIdToFileIdMapping.getOrDefault(bucketId, null));
        }
    }
}

