/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.visitor.InternalSchemaVisitor;
import org.apache.hudi.internal.schema.visitor.NameToIDVisitor;

public class InternalSchemaBuilder
implements Serializable {
    private static final InternalSchemaBuilder INSTANCE = new InternalSchemaBuilder();

    public static InternalSchemaBuilder getBuilder() {
        return INSTANCE;
    }

    private InternalSchemaBuilder() {
    }

    public Map<Integer, String> buildIdToName(Type type) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        this.buildNameToId(type).forEach((k, v) -> result.put((Integer)v, (String)k));
        return result;
    }

    public Map<String, Integer> buildNameToId(Type type) {
        return this.visit(type, new NameToIDVisitor());
    }

    public <T> T visit(InternalSchema schema2, InternalSchemaVisitor<T> visitor) {
        return visitor.schema(schema2, this.visit(schema2.getRecord(), visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T visit(Type type, InternalSchemaVisitor<T> visitor) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                ArrayList<T> results = new ArrayList<T>();
                for (Types.Field f : record.fields()) {
                    T result;
                    visitor.beforeField(f);
                    try {
                        result = this.visit(f.type(), visitor);
                    }
                    finally {
                        visitor.afterField(f);
                    }
                    results.add(visitor.field(f, result));
                }
                return visitor.record(record, results);
            }
            case ARRAY: {
                T elementResult;
                Types.ArrayType array2 = (Types.ArrayType)type;
                Types.Field elementField = array2.field(array2.elementId());
                visitor.beforeArrayElement(elementField);
                try {
                    elementResult = this.visit(elementField.type(), visitor);
                }
                finally {
                    visitor.afterArrayElement(elementField);
                }
                return visitor.array(array2, elementResult);
            }
            case MAP: {
                T valueResult;
                T keyResult;
                Types.MapType map = (Types.MapType)type;
                Types.Field keyField = map.field(map.keyId());
                visitor.beforeMapKey(keyField);
                try {
                    keyResult = this.visit(map.keyType(), visitor);
                }
                finally {
                    visitor.afterMapKey(keyField);
                }
                Types.Field valueField = map.field(map.valueId());
                visitor.beforeMapValue(valueField);
                try {
                    valueResult = this.visit(map.valueType(), visitor);
                }
                finally {
                    visitor.afterMapValue(valueField);
                }
                return visitor.map(map, keyResult, valueResult);
            }
        }
        return visitor.primitive((Type.PrimitiveType)type);
    }

    public Map<Integer, Types.Field> buildIdToField(Type type) {
        HashMap<Integer, Types.Field> idToField = new HashMap<Integer, Types.Field>();
        this.visitIdToField(type, idToField);
        return idToField;
    }

    private void visitIdToField(Type type, Map<Integer, Types.Field> index) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                for (Types.Field field : record.fields()) {
                    this.visitIdToField(field.type(), index);
                    index.put(field.fieldId(), field);
                }
                return;
            }
            case ARRAY: {
                Types.ArrayType array2 = (Types.ArrayType)type;
                this.visitIdToField(array2.elementType(), index);
                for (Types.Field field : array2.fields()) {
                    index.put(field.fieldId(), field);
                }
                return;
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                this.visitIdToField(map.keyType(), index);
                this.visitIdToField(map.valueType(), index);
                for (Types.Field field : map.fields()) {
                    index.put(field.fieldId(), field);
                }
                return;
            }
        }
    }

    public Map<Integer, Integer> index2Parents(Types.RecordType record) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        LinkedList<Integer> parentIds = new LinkedList<Integer>();
        this.index2Parents(record, parentIds, result);
        return result;
    }

    private void index2Parents(Type type, Deque<Integer> pids, Map<Integer, Integer> id2p) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                for (Types.Field f : record.fields()) {
                    pids.push(f.fieldId());
                    this.index2Parents(f.type(), pids, id2p);
                    pids.pop();
                }
                for (Types.Field f : record.fields()) {
                    if (pids.isEmpty()) continue;
                    Integer pid = pids.peek();
                    id2p.put(f.fieldId(), pid);
                }
                return;
            }
            case ARRAY: {
                Types.ArrayType array2 = (Types.ArrayType)type;
                Types.Field elementField = array2.field(array2.elementId());
                pids.push(elementField.fieldId());
                this.index2Parents(elementField.type(), pids, id2p);
                pids.pop();
                id2p.put(array2.elementId(), pids.peek());
                return;
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                Types.Field keyField = map.field(map.keyId());
                Types.Field valueField = map.field(map.valueId());
                pids.push(map.keyId());
                this.index2Parents(keyField.type(), pids, id2p);
                pids.pop();
                pids.push(map.valueId());
                this.index2Parents(valueField.type(), pids, id2p);
                pids.pop();
                id2p.put(map.keyId(), pids.peek());
                id2p.put(map.valueId(), pids.peek());
                return;
            }
        }
    }

    public Type refreshNewId(Type type, AtomicInteger nextId) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                List<Types.Field> oldFields = record.fields();
                int currentId = nextId.get();
                nextId.set(currentId + record.fields().size());
                ArrayList<Types.Field> internalFields = new ArrayList<Types.Field>();
                for (int i = 0; i < oldFields.size(); ++i) {
                    Types.Field oldField = oldFields.get(i);
                    Type fieldType = this.refreshNewId(oldField.type(), nextId);
                    internalFields.add(Types.Field.get(currentId++, oldField.isOptional(), oldField.name(), fieldType, oldField.doc()));
                }
                return Types.RecordType.get(internalFields);
            }
            case ARRAY: {
                Types.ArrayType array2 = (Types.ArrayType)type;
                int elementId = nextId.get();
                nextId.set(elementId + 1);
                Type elementType = this.refreshNewId(array2.elementType(), nextId);
                return Types.ArrayType.get(elementId, array2.isElementOptional(), elementType);
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                int keyId = nextId.get();
                int valueId = keyId + 1;
                nextId.set(keyId + 2);
                Type keyType = this.refreshNewId(map.keyType(), nextId);
                Type valueType = this.refreshNewId(map.valueType(), nextId);
                return Types.MapType.get(keyId, valueId, keyType, valueType, map.isValueOptional());
            }
        }
        return type;
    }
}

