/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class HoodieParquetConfig<T> {
    private final T writeSupport;
    private final CompressionCodecName compressionCodecName;
    private final int blockSize;
    private final int pageSize;
    private final long maxFileSize;
    private final Configuration hadoopConf;
    private final double compressionRatio;
    private final boolean dictionaryEnabled;

    public HoodieParquetConfig(T writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, long maxFileSize, Configuration hadoopConf, double compressionRatio) {
        this(writeSupport, compressionCodecName, blockSize, pageSize, maxFileSize, hadoopConf, compressionRatio, false);
    }

    public HoodieParquetConfig(T writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, long maxFileSize, Configuration hadoopConf, double compressionRatio, boolean dictionaryEnabled) {
        this.writeSupport = writeSupport;
        this.compressionCodecName = compressionCodecName;
        this.blockSize = blockSize;
        this.pageSize = pageSize;
        this.maxFileSize = maxFileSize;
        this.hadoopConf = hadoopConf;
        this.compressionRatio = compressionRatio;
        this.dictionaryEnabled = dictionaryEnabled;
    }

    public CompressionCodecName getCompressionCodecName() {
        return this.compressionCodecName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    public T getWriteSupport() {
        return this.writeSupport;
    }

    public boolean dictionaryEnabled() {
        return this.dictionaryEnabled;
    }
}

