/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class ComplexKeyGenerator
extends BuiltinKeyGenerator {
    private final ComplexAvroKeyGenerator complexAvroKeyGenerator;

    public ComplexKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.complexAvroKeyGenerator = new ComplexAvroKeyGenerator(props);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.complexAvroKeyGenerator.getRecordKey(record);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.complexAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.tryInitRowAccessor(row.schema());
        return this.combineCompositeRecordKey(this.rowAccessor.getRecordKeyParts(row));
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema2) {
        this.tryInitRowAccessor(schema2);
        return this.combineCompositeRecordKeyUnsafe(this.rowAccessor.getRecordKeyParts(internalRow));
    }

    @Override
    public String getPartitionPath(Row row) {
        this.tryInitRowAccessor(row.schema());
        return this.combinePartitionPath(this.rowAccessor.getRecordPartitionPathValues(row));
    }

    @Override
    public UTF8String getPartitionPath(InternalRow row, StructType schema2) {
        this.tryInitRowAccessor(schema2);
        return this.combinePartitionPathUnsafe(this.rowAccessor.getRecordPartitionPathValues(row));
    }
}

