/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.primitives.Longs;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MetaCellComparator
extends CellComparatorImpl {
    public static final MetaCellComparator META_COMPARATOR = new MetaCellComparator();

    @Override
    public int compareRows(Cell left, Cell right) {
        return MetaCellComparator.compareRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
    }

    @Override
    public int compareRows(Cell left, byte[] right, int roffset, int rlength) {
        return MetaCellComparator.compareRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right, roffset, rlength);
    }

    @Override
    public int compareRows(byte[] leftRow, byte[] rightRow) {
        return MetaCellComparator.compareRows(leftRow, 0, leftRow.length, rightRow, 0, rightRow.length);
    }

    @Override
    public int compare(Cell a, Cell b, boolean ignoreSequenceid) {
        int diff = this.compareRows(a, b);
        if (diff != 0) {
            return diff;
        }
        diff = this.compareWithoutRow(a, b);
        if (diff != 0) {
            return diff;
        }
        return ignoreSequenceid ? diff : Longs.compare(b.getSequenceId(), a.getSequenceId());
    }

    private static int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
        int rightFarDelimiter;
        int leftFarDelimiter;
        int rightDelimiter;
        int rpart;
        int leftDelimiter = Bytes.searchDelimiterIndex(left, loffset, llength, 44);
        int lpart = leftDelimiter < 0 ? llength : leftDelimiter - loffset;
        int result = Bytes.compareTo(left, loffset, lpart, right, roffset, rpart = (rightDelimiter = Bytes.searchDelimiterIndex(right, roffset, rlength, 44)) < 0 ? rlength : rightDelimiter - roffset);
        if (result != 0) {
            return result;
        }
        if (leftDelimiter < 0 && rightDelimiter >= 0) {
            return -1;
        }
        if (rightDelimiter < 0 && leftDelimiter >= 0) {
            return 1;
        }
        if (leftDelimiter < 0) {
            return 0;
        }
        if ((result = Bytes.compareTo(left, leftDelimiter, lpart = ((leftFarDelimiter = Bytes.searchDelimiterIndexInReverse(left, ++leftDelimiter, llength - (leftDelimiter - loffset), 44)) < 0 ? llength + loffset : leftFarDelimiter) - leftDelimiter, right, rightDelimiter, rpart = ((rightFarDelimiter = Bytes.searchDelimiterIndexInReverse(right, ++rightDelimiter, rlength - (rightDelimiter - roffset), 44)) < 0 ? rlength + roffset : rightFarDelimiter) - rightDelimiter)) != 0) {
            return result;
        }
        if (leftDelimiter < 0 && rightDelimiter >= 0) {
            return -1;
        }
        if (rightDelimiter < 0 && leftDelimiter >= 0) {
            return 1;
        }
        if (leftDelimiter < 0) {
            return 0;
        }
        result = Bytes.compareTo(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
        return result;
    }

    @Override
    public int compareRows(ByteBuffer row, Cell cell) {
        int offset;
        byte[] array2;
        int len = row.remaining();
        if (row.hasArray()) {
            array2 = row.array();
            offset = row.position() + row.arrayOffset();
        } else {
            array2 = new byte[len];
            offset = 0;
            ByteBufferUtils.copyFromBufferToArray(array2, row, row.position(), 0, len);
        }
        return -this.compareRows(cell, array2, offset, len);
    }

    @Override
    public Comparator getSimpleComparator() {
        return this;
    }
}

