/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.CompareOperator;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hudi.org.apache.hadoop.hbase.client.Append;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncClientScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncTableBuilderBase;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncTableResultScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hudi.org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.Delete;
import org.apache.hudi.org.apache.hadoop.hbase.client.Get;
import org.apache.hudi.org.apache.hadoop.hbase.client.Increment;
import org.apache.hudi.org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionCoprocessorRpcChannelImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.apache.hudi.org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.ServiceCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RawAsyncTableImpl
implements AsyncTable<AdvancedScanResultConsumer> {
    private static final Logger LOG = LoggerFactory.getLogger(RawAsyncTableImpl.class);
    private final AsyncConnectionImpl conn;
    private final Timer retryTimer;
    private final TableName tableName;
    private final int defaultScannerCaching;
    private final long defaultScannerMaxResultSize;
    private final long rpcTimeoutNs;
    private final long readRpcTimeoutNs;
    private final long writeRpcTimeoutNs;
    private final long operationTimeoutNs;
    private final long scanTimeoutNs;
    private final long pauseNs;
    private final long pauseForCQTBENs;
    private final int maxAttempts;
    private final int startLogErrorsCnt;

    RawAsyncTableImpl(AsyncConnectionImpl conn, Timer retryTimer, AsyncTableBuilderBase<?> builder) {
        this.conn = conn;
        this.retryTimer = retryTimer;
        this.tableName = builder.tableName;
        this.rpcTimeoutNs = builder.rpcTimeoutNs;
        this.readRpcTimeoutNs = builder.readRpcTimeoutNs;
        this.writeRpcTimeoutNs = builder.writeRpcTimeoutNs;
        this.operationTimeoutNs = builder.operationTimeoutNs;
        this.scanTimeoutNs = builder.scanTimeoutNs;
        this.pauseNs = builder.pauseNs;
        if (builder.pauseForCQTBENs < builder.pauseNs) {
            LOG.warn("Configured value of pauseForCQTBENs is {} ms, which is less than the normal pause value {} ms, use the greater one instead", (Object)TimeUnit.NANOSECONDS.toMillis(builder.pauseForCQTBENs), (Object)TimeUnit.NANOSECONDS.toMillis(builder.pauseNs));
            this.pauseForCQTBENs = builder.pauseNs;
        } else {
            this.pauseForCQTBENs = builder.pauseForCQTBENs;
        }
        this.maxAttempts = builder.maxAttempts;
        this.startLogErrorsCnt = builder.startLogErrorsCnt;
        this.defaultScannerCaching = this.tableName.isSystemTable() ? conn.connConf.getMetaScannerCaching() : conn.connConf.getScannerCaching();
        this.defaultScannerMaxResultSize = conn.connConf.getScannerMaxResultSize();
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conn.getConfiguration();
    }

    @Override
    public CompletableFuture<TableDescriptor> getDescriptor() {
        return this.conn.getAdmin().getDescriptor(this.tableName);
    }

    @Override
    public AsyncTableRegionLocator getRegionLocator() {
        return this.conn.getRegionLocator(this.tableName);
    }

    private static <REQ, PREQ, PRESP, RESP> CompletableFuture<RESP> call(final HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, Converter<PREQ, byte[], REQ> reqConvert, RpcCall<PRESP, PREQ> rpcCall, final Converter<RESP, HBaseRpcController, PRESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        try {
            rpcCall.call(stub, controller, reqConvert.convert(loc.getRegion().getRegionName(), req), new RpcCallback<PRESP>(){

                @Override
                public void run(PRESP resp) {
                    if (controller.failed()) {
                        future.completeExceptionally(controller.getFailed());
                    } else {
                        try {
                            future.complete(respConverter.convert(controller, resp));
                        }
                        catch (IOException e) {
                            future.completeExceptionally(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static <REQ, RESP> CompletableFuture<RESP> mutate(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, Converter<ClientProtos.MutateRequest, byte[], REQ> reqConvert, Converter<RESP, HBaseRpcController, ClientProtos.MutateResponse> respConverter) {
        return RawAsyncTableImpl.call(controller, loc, stub, req, reqConvert, (s, c, r, done) -> s.mutate(c, (ClientProtos.MutateRequest)r, done), respConverter);
    }

    private static <REQ> CompletableFuture<Void> voidMutate(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, Converter<ClientProtos.MutateRequest, byte[], REQ> reqConvert) {
        return RawAsyncTableImpl.mutate(controller, loc, stub, req, reqConvert, (c, resp) -> null);
    }

    private static Result toResult(HBaseRpcController controller, ClientProtos.MutateResponse resp) throws IOException {
        if (!resp.hasResult()) {
            return null;
        }
        return ProtobufUtil.toResult(resp.getResult(), controller.cellScanner());
    }

    private <REQ, RESP> CompletableFuture<RESP> noncedMutate(long nonceGroup, long nonce, HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, NoncedConverter<ClientProtos.MutateRequest, byte[], REQ> reqConvert, Converter<RESP, HBaseRpcController, ClientProtos.MutateResponse> respConverter) {
        return RawAsyncTableImpl.mutate(controller, loc, stub, req, (info, src) -> (ClientProtos.MutateRequest)reqConvert.convert((byte[])info, (Object)src, nonceGroup, nonce), respConverter);
    }

    private <T> AsyncRpcRetryingCallerFactory.SingleRequestCallerBuilder<T> newCaller(byte[] row, int priority, long rpcTimeoutNs) {
        return this.conn.callerFactory.single().table(this.tableName).row(row).priority(priority).rpcTimeout(rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).pauseForCQTBE(this.pauseForCQTBENs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt);
    }

    private <T, R extends OperationWithAttributes> AsyncRpcRetryingCallerFactory.SingleRequestCallerBuilder<T> newCaller(R row, long rpcTimeoutNs) {
        return this.newCaller(((Row)((Object)row)).getRow(), row.getPriority(), rpcTimeoutNs);
    }

    private CompletableFuture<Result> get(Get get2, int replicaId) {
        return this.newCaller(get2, this.readRpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.call(controller, loc, stub, get2, RequestConverter::buildGetRequest, (s, c, req, done) -> s.get(c, (ClientProtos.GetRequest)req, done), (c, resp) -> ProtobufUtil.toResult(resp.getResult(), c.cellScanner()))).replicaId(replicaId).call();
    }

    @Override
    public CompletableFuture<Result> get(Get get2) {
        return ConnectionUtils.timelineConsistentRead(this.conn.getLocator(), this.tableName, get2, get2.getRow(), RegionLocateType.CURRENT, replicaId -> this.get(get2, (int)replicaId), this.readRpcTimeoutNs, this.conn.connConf.getPrimaryCallTimeoutNs(), this.retryTimer, this.conn.getConnectionMetrics());
    }

    @Override
    public CompletableFuture<Void> put(Put put2) {
        ConnectionUtils.validatePut(put2, this.conn.connConf.getMaxKeyValueSize());
        return this.newCaller(put2, this.writeRpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.voidMutate(controller, loc, stub, put2, RequestConverter::buildMutateRequest)).call();
    }

    @Override
    public CompletableFuture<Void> delete(Delete delete) {
        return this.newCaller(delete, this.writeRpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.voidMutate(controller, loc, stub, delete, RequestConverter::buildMutateRequest)).call();
    }

    @Override
    public CompletableFuture<Result> append(Append append) {
        ConnectionUtils.checkHasFamilies(append);
        long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
        long nonce = this.conn.getNonceGenerator().newNonce();
        return this.newCaller(append, this.rpcTimeoutNs).action((controller, loc, stub) -> this.noncedMutate(nonceGroup, nonce, controller, loc, stub, append, RequestConverter::buildMutateRequest, RawAsyncTableImpl::toResult)).call();
    }

    @Override
    public CompletableFuture<Result> increment(Increment increment) {
        ConnectionUtils.checkHasFamilies(increment);
        long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
        long nonce = this.conn.getNonceGenerator().newNonce();
        return this.newCaller(increment, this.rpcTimeoutNs).action((controller, loc, stub) -> this.noncedMutate(nonceGroup, nonce, controller, loc, stub, increment, RequestConverter::buildMutateRequest, RawAsyncTableImpl::toResult)).call();
    }

    @Override
    public AsyncTable.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(row, family);
    }

    @Override
    public AsyncTable.CheckAndMutateWithFilterBuilder checkAndMutate(byte[] row, Filter filter) {
        return new CheckAndMutateWithFilterBuilderImpl(row, filter);
    }

    @Override
    public CompletableFuture<CheckAndMutateResult> checkAndMutate(CheckAndMutate checkAndMutate) {
        if (checkAndMutate.getAction() instanceof Put || checkAndMutate.getAction() instanceof Delete || checkAndMutate.getAction() instanceof Increment || checkAndMutate.getAction() instanceof Append) {
            Mutation mutation = (Mutation)checkAndMutate.getAction();
            if (mutation instanceof Put) {
                ConnectionUtils.validatePut((Put)mutation, this.conn.connConf.getMaxKeyValueSize());
            }
            long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
            long nonce = this.conn.getNonceGenerator().newNonce();
            return this.newCaller(checkAndMutate.getRow(), mutation.getPriority(), this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutate(controller, loc, stub, mutation, (rn, m) -> RequestConverter.buildMutateRequest(rn, checkAndMutate.getRow(), checkAndMutate.getFamily(), checkAndMutate.getQualifier(), checkAndMutate.getCompareOp(), checkAndMutate.getValue(), checkAndMutate.getFilter(), checkAndMutate.getTimeRange(), m, nonceGroup, nonce), (c, r) -> ResponseConverter.getCheckAndMutateResult(r, c.cellScanner()))).call();
        }
        if (checkAndMutate.getAction() instanceof RowMutations) {
            RowMutations rowMutations = (RowMutations)checkAndMutate.getAction();
            ConnectionUtils.validatePutsInRowMutations(rowMutations, this.conn.connConf.getMaxKeyValueSize());
            long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
            long nonce = this.conn.getNonceGenerator().newNonce();
            return this.newCaller(checkAndMutate.getRow(), rowMutations.getMaxPriority(), this.rpcTimeoutNs).action((controller, loc, stub) -> this.mutateRow(controller, loc, stub, rowMutations, (rn, rm) -> RequestConverter.buildMultiRequest(rn, checkAndMutate.getRow(), checkAndMutate.getFamily(), checkAndMutate.getQualifier(), checkAndMutate.getCompareOp(), checkAndMutate.getValue(), checkAndMutate.getFilter(), checkAndMutate.getTimeRange(), rm, nonceGroup, nonce), resp -> resp)).call();
        }
        CompletableFuture<CheckAndMutateResult> future = new CompletableFuture<CheckAndMutateResult>();
        future.completeExceptionally(new DoNotRetryIOException("CheckAndMutate doesn't support " + checkAndMutate.getAction().getClass().getName()));
        return future;
    }

    @Override
    public List<CompletableFuture<CheckAndMutateResult>> checkAndMutate(List<CheckAndMutate> checkAndMutates) {
        return this.batch(checkAndMutates, this.rpcTimeoutNs).stream().map(f -> f.thenApply(r -> (CheckAndMutateResult)r)).collect(Collectors.toList());
    }

    private <RES, RESP> CompletableFuture<RESP> mutateRow(final HBaseRpcController controller, final HRegionLocation loc, ClientProtos.ClientService.Interface stub, final RowMutations mutation, Converter<ClientProtos.MultiRequest, byte[], RowMutations> reqConvert, final Function<RES, RESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        try {
            final byte[] regionName = loc.getRegion().getRegionName();
            final ClientProtos.MultiRequest req = reqConvert.convert(regionName, mutation);
            stub.multi(controller, req, new RpcCallback<ClientProtos.MultiResponse>(){

                @Override
                public void run(ClientProtos.MultiResponse resp) {
                    if (controller.failed()) {
                        future.completeExceptionally(controller.getFailed());
                    } else {
                        try {
                            MultiResponse multiResp = ResponseConverter.getResults(req, resp, controller.cellScanner());
                            ConnectionUtils.updateStats(RawAsyncTableImpl.this.conn.getStatisticsTracker(), RawAsyncTableImpl.this.conn.getConnectionMetrics(), loc.getServerName(), multiResp);
                            Throwable ex = multiResp.getException(regionName);
                            if (ex != null) {
                                future.completeExceptionally(ex instanceof IOException ? ex : new IOException("Failed to mutate row: " + Bytes.toStringBinary(mutation.getRow()), ex));
                            } else {
                                future.complete(respConverter.apply(multiResp.getResults().get((Object)regionName).result.get(0)));
                            }
                        }
                        catch (IOException e) {
                            future.completeExceptionally(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<Result> mutateRow(RowMutations mutations) {
        ConnectionUtils.validatePutsInRowMutations(mutations, this.conn.connConf.getMaxKeyValueSize());
        long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
        long nonce = this.conn.getNonceGenerator().newNonce();
        return this.newCaller(mutations.getRow(), mutations.getMaxPriority(), this.writeRpcTimeoutNs).action((controller, loc, stub) -> this.mutateRow(controller, loc, stub, mutations, (rn, rm) -> RequestConverter.buildMultiRequest(rn, rm, nonceGroup, nonce), resp -> resp)).call();
    }

    private Scan setDefaultScanConfig(Scan scan) {
        Scan newScan = (Scan)ReflectionUtils.newInstance(scan.getClass(), scan);
        if (newScan.getCaching() <= 0) {
            newScan.setCaching(this.defaultScannerCaching);
        }
        if (newScan.getMaxResultSize() <= 0L) {
            newScan.setMaxResultSize(this.defaultScannerMaxResultSize);
        }
        return newScan;
    }

    @Override
    public void scan(Scan scan, AdvancedScanResultConsumer consumer2) {
        new AsyncClientScanner(this.setDefaultScanConfig(scan), consumer2, this.tableName, this.conn, this.retryTimer, this.pauseNs, this.pauseForCQTBENs, this.maxAttempts, this.scanTimeoutNs, this.readRpcTimeoutNs, this.startLogErrorsCnt).start();
    }

    private long resultSize2CacheSize(long maxResultSize) {
        return maxResultSize > 0x3FFFFFFFFFFFFFFFL ? maxResultSize : maxResultSize * 2L;
    }

    @Override
    public ResultScanner getScanner(Scan scan) {
        return new AsyncTableResultScanner(this, (Scan)ReflectionUtils.newInstance(scan.getClass(), scan), this.resultSize2CacheSize(scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : this.defaultScannerMaxResultSize));
    }

    @Override
    public CompletableFuture<List<Result>> scanAll(Scan scan) {
        final CompletableFuture<List<Result>> future = new CompletableFuture<List<Result>>();
        final ArrayList scanResults = new ArrayList();
        this.scan(scan, new AdvancedScanResultConsumer(){

            @Override
            public void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
                scanResults.addAll(Arrays.asList(results));
            }

            @Override
            public void onError(Throwable error) {
                future.completeExceptionally(error);
            }

            @Override
            public void onComplete() {
                future.complete(scanResults);
            }
        });
        return future;
    }

    @Override
    public List<CompletableFuture<Result>> get(List<Get> gets) {
        return this.batch(gets, this.readRpcTimeoutNs);
    }

    @Override
    public List<CompletableFuture<Void>> put(List<Put> puts) {
        return this.voidMutate(puts);
    }

    @Override
    public List<CompletableFuture<Void>> delete(List<Delete> deletes) {
        return this.voidMutate(deletes);
    }

    @Override
    public <T> List<CompletableFuture<T>> batch(List<? extends Row> actions) {
        return this.batch(actions, this.rpcTimeoutNs);
    }

    private List<CompletableFuture<Void>> voidMutate(List<? extends Row> actions) {
        return this.batch(actions, this.writeRpcTimeoutNs).stream().map(f -> f.thenApply(r -> null)).collect(Collectors.toList());
    }

    private <T> List<CompletableFuture<T>> batch(List<? extends Row> actions, long rpcTimeoutNs) {
        for (Row row : actions) {
            if (row instanceof Put) {
                ConnectionUtils.validatePut((Put)row, this.conn.connConf.getMaxKeyValueSize());
                continue;
            }
            if (row instanceof CheckAndMutate) {
                CheckAndMutate checkAndMutate = (CheckAndMutate)row;
                if (checkAndMutate.getAction() instanceof Put) {
                    ConnectionUtils.validatePut((Put)checkAndMutate.getAction(), this.conn.connConf.getMaxKeyValueSize());
                    continue;
                }
                if (!(checkAndMutate.getAction() instanceof RowMutations)) continue;
                ConnectionUtils.validatePutsInRowMutations((RowMutations)checkAndMutate.getAction(), this.conn.connConf.getMaxKeyValueSize());
                continue;
            }
            if (!(row instanceof RowMutations)) continue;
            ConnectionUtils.validatePutsInRowMutations((RowMutations)row, this.conn.connConf.getMaxKeyValueSize());
        }
        return this.conn.callerFactory.batch().table(this.tableName).actions(actions).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).rpcTimeout(rpcTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).pauseForCQTBE(this.pauseForCQTBENs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).call();
    }

    @Override
    public long getRpcTimeout(TimeUnit unit) {
        return unit.convert(this.rpcTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getReadRpcTimeout(TimeUnit unit) {
        return unit.convert(this.readRpcTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getWriteRpcTimeout(TimeUnit unit) {
        return unit.convert(this.writeRpcTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getOperationTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getScanTimeout(TimeUnit unit) {
        return unit.convert(this.scanTimeoutNs, TimeUnit.NANOSECONDS);
    }

    private <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, RegionInfo region, byte[] row) {
        RegionCoprocessorRpcChannelImpl channel = new RegionCoprocessorRpcChannelImpl(this.conn, this.tableName, region, row, this.rpcTimeoutNs, this.operationTimeoutNs);
        S stub = stubMaker.apply(channel);
        CompletableFuture future = new CompletableFuture();
        ClientCoprocessorRpcController controller = new ClientCoprocessorRpcController();
        callable.call(stub, controller, resp -> {
            if (controller.failed()) {
                future.completeExceptionally(controller.getFailed());
            } else {
                future.complete(resp);
            }
        });
        return future;
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, byte[] row) {
        return this.coprocessorService(stubMaker, callable, null, row);
    }

    private boolean locateFinished(RegionInfo region, byte[] endKey, boolean endKeyInclusive) {
        if (ConnectionUtils.isEmptyStopRow(endKey)) {
            return ConnectionUtils.isEmptyStopRow(region.getEndKey());
        }
        if (ConnectionUtils.isEmptyStopRow(region.getEndKey())) {
            return true;
        }
        int c = Bytes.compareTo(endKey, region.getEndKey());
        return c < 0 || c == 0 && !endKeyInclusive;
    }

    private <S, R> void onLocateComplete(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, AsyncTable.CoprocessorCallback<R> callback, List<HRegionLocation> locs, byte[] endKey, boolean endKeyInclusive, AtomicBoolean locateFinished, AtomicInteger unfinishedRequest, HRegionLocation loc, Throwable error) {
        if (error != null) {
            callback.onError(error);
            return;
        }
        unfinishedRequest.incrementAndGet();
        RegionInfo region = loc.getRegion();
        if (this.locateFinished(region, endKey, endKeyInclusive)) {
            locateFinished.set(true);
        } else {
            FutureUtils.addListener(this.conn.getLocator().getRegionLocation(this.tableName, region.getEndKey(), RegionLocateType.CURRENT, this.operationTimeoutNs), (l, e) -> this.onLocateComplete(stubMaker, callable, callback, locs, endKey, endKeyInclusive, locateFinished, unfinishedRequest, (HRegionLocation)l, (Throwable)e));
        }
        FutureUtils.addListener(this.coprocessorService(stubMaker, callable, region, region.getStartKey()), (r, e) -> {
            if (e != null) {
                callback.onRegionError(region, (Throwable)e);
            } else {
                callback.onRegionComplete(region, r);
            }
            if (unfinishedRequest.decrementAndGet() == 0 && locateFinished.get()) {
                callback.onComplete();
            }
        });
    }

    @Override
    public <S, R> AsyncTable.CoprocessorServiceBuilder<S, R> coprocessorService(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, AsyncTable.CoprocessorCallback<R> callback) {
        return new CoprocessorServiceBuilderImpl<S, R>(stubMaker, callable, callback);
    }

    private final class CoprocessorServiceBuilderImpl<S, R>
    implements AsyncTable.CoprocessorServiceBuilder<S, R> {
        private final Function<RpcChannel, S> stubMaker;
        private final ServiceCaller<S, R> callable;
        private final AsyncTable.CoprocessorCallback<R> callback;
        private byte[] startKey = HConstants.EMPTY_START_ROW;
        private boolean startKeyInclusive;
        private byte[] endKey = HConstants.EMPTY_END_ROW;
        private boolean endKeyInclusive;

        public CoprocessorServiceBuilderImpl(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, AsyncTable.CoprocessorCallback<R> callback) {
            this.stubMaker = Preconditions.checkNotNull(stubMaker, "stubMaker is null");
            this.callable = Preconditions.checkNotNull(callable, "callable is null");
            this.callback = Preconditions.checkNotNull(callback, "callback is null");
        }

        @Override
        public CoprocessorServiceBuilderImpl<S, R> fromRow(byte[] startKey, boolean inclusive) {
            this.startKey = Preconditions.checkNotNull(startKey, "startKey is null. Consider using an empty byte array, or just do not call this method if you want to start selection from the first region");
            this.startKeyInclusive = inclusive;
            return this;
        }

        @Override
        public CoprocessorServiceBuilderImpl<S, R> toRow(byte[] endKey, boolean inclusive) {
            this.endKey = Preconditions.checkNotNull(endKey, "endKey is null. Consider using an empty byte array, or just do not call this method if you want to continue selection to the last region");
            this.endKeyInclusive = inclusive;
            return this;
        }

        @Override
        public void execute() {
            FutureUtils.addListener(RawAsyncTableImpl.this.conn.getLocator().getRegionLocation(RawAsyncTableImpl.this.tableName, this.startKey, this.startKeyInclusive ? RegionLocateType.CURRENT : RegionLocateType.AFTER, RawAsyncTableImpl.this.operationTimeoutNs), (loc, error) -> RawAsyncTableImpl.this.onLocateComplete(this.stubMaker, this.callable, this.callback, new ArrayList(), this.endKey, this.endKeyInclusive, new AtomicBoolean(false), new AtomicInteger(0), loc, error));
        }
    }

    private final class CheckAndMutateWithFilterBuilderImpl
    implements AsyncTable.CheckAndMutateWithFilterBuilder {
        private final byte[] row;
        private final Filter filter;
        private TimeRange timeRange;

        public CheckAndMutateWithFilterBuilderImpl(byte[] row, Filter filter) {
            this.row = Preconditions.checkNotNull(row, "row is null");
            this.filter = Preconditions.checkNotNull(filter, "filter is null");
        }

        @Override
        public AsyncTable.CheckAndMutateWithFilterBuilder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public CompletableFuture<Boolean> thenPut(Put put2) {
            ConnectionUtils.validatePut(put2, ((RawAsyncTableImpl)RawAsyncTableImpl.this).conn.connConf.getMaxKeyValueSize());
            return RawAsyncTableImpl.this.newCaller(this.row, put2.getPriority(), RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutate(controller, loc, stub, put2, (rn, p) -> RequestConverter.buildMutateRequest(rn, this.row, null, null, null, null, this.filter, this.timeRange, p, 0L, 0L), (c, r) -> r.getProcessed())).call();
        }

        @Override
        public CompletableFuture<Boolean> thenDelete(Delete delete) {
            return RawAsyncTableImpl.this.newCaller(this.row, delete.getPriority(), RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutate(controller, loc, stub, delete, (rn, d) -> RequestConverter.buildMutateRequest(rn, this.row, null, null, null, null, this.filter, this.timeRange, d, 0L, 0L), (c, r) -> r.getProcessed())).call();
        }

        @Override
        public CompletableFuture<Boolean> thenMutate(RowMutations mutation) {
            ConnectionUtils.validatePutsInRowMutations(mutation, ((RawAsyncTableImpl)RawAsyncTableImpl.this).conn.connConf.getMaxKeyValueSize());
            return RawAsyncTableImpl.this.newCaller(this.row, mutation.getMaxPriority(), RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.this.mutateRow(controller, loc, stub, mutation, (rn, rm) -> RequestConverter.buildMultiRequest(rn, this.row, null, null, null, null, this.filter, this.timeRange, rm, 0L, 0L), CheckAndMutateResult::isSuccess)).call();
        }
    }

    private final class CheckAndMutateBuilderImpl
    implements AsyncTable.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private TimeRange timeRange;
        private CompareOperator op;
        private byte[] value;

        public CheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = Preconditions.checkNotNull(row, "row is null");
            this.family = Preconditions.checkNotNull(family, "family is null");
        }

        @Override
        public AsyncTable.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = Preconditions.checkNotNull(qualifier, "qualifier is null. Consider using an empty byte array, or just do not call this method if you want a null qualifier");
            return this;
        }

        @Override
        public AsyncTable.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public AsyncTable.CheckAndMutateBuilder ifNotExists() {
            this.op = CompareOperator.EQUAL;
            this.value = null;
            return this;
        }

        @Override
        public AsyncTable.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            this.op = Preconditions.checkNotNull(compareOp, "compareOp is null");
            this.value = Preconditions.checkNotNull(value, "value is null");
            return this;
        }

        private void preCheck() {
            Preconditions.checkNotNull(this.op, "condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
        }

        @Override
        public CompletableFuture<Boolean> thenPut(Put put2) {
            ConnectionUtils.validatePut(put2, ((RawAsyncTableImpl)RawAsyncTableImpl.this).conn.connConf.getMaxKeyValueSize());
            this.preCheck();
            return RawAsyncTableImpl.this.newCaller(this.row, put2.getPriority(), RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutate(controller, loc, stub, put2, (rn, p) -> RequestConverter.buildMutateRequest(rn, this.row, this.family, this.qualifier, this.op, this.value, null, this.timeRange, p, 0L, 0L), (c, r) -> r.getProcessed())).call();
        }

        @Override
        public CompletableFuture<Boolean> thenDelete(Delete delete) {
            this.preCheck();
            return RawAsyncTableImpl.this.newCaller(this.row, delete.getPriority(), RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutate(controller, loc, stub, delete, (rn, d) -> RequestConverter.buildMutateRequest(rn, this.row, this.family, this.qualifier, this.op, this.value, null, this.timeRange, d, 0L, 0L), (c, r) -> r.getProcessed())).call();
        }

        @Override
        public CompletableFuture<Boolean> thenMutate(RowMutations mutation) {
            this.preCheck();
            ConnectionUtils.validatePutsInRowMutations(mutation, ((RawAsyncTableImpl)RawAsyncTableImpl.this).conn.connConf.getMaxKeyValueSize());
            return RawAsyncTableImpl.this.newCaller(this.row, mutation.getMaxPriority(), RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.this.mutateRow(controller, loc, stub, mutation, (rn, rm) -> RequestConverter.buildMultiRequest(rn, this.row, this.family, this.qualifier, this.op, this.value, null, this.timeRange, rm, 0L, 0L), CheckAndMutateResult::isSuccess)).call();
        }
    }

    @FunctionalInterface
    private static interface NoncedConverter<D, I, S> {
        public D convert(I var1, S var2, long var3, long var5) throws IOException;
    }

    @FunctionalInterface
    private static interface RpcCall<RESP, REQ> {
        public void call(ClientProtos.ClientService.Interface var1, HBaseRpcController var2, REQ var3, RpcCallback<RESP> var4);
    }

    @FunctionalInterface
    private static interface Converter<D, I, S> {
        public D convert(I var1, S var2) throws IOException;
    }
}

