/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.Call;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CallCancelledException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerTooBusyException;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.FastThreadLocal;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class IPCUtil {
    private static final FastThreadLocal<MutableInt> DEPTH = new FastThreadLocal<MutableInt>(){

        @Override
        protected MutableInt initialValue() throws Exception {
            return new MutableInt(0);
        }
    };
    static final int MAX_DEPTH = 4;

    IPCUtil() {
    }

    public static int write(OutputStream dos, Message header, Message param, ByteBuf cellBlock) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        if (cellBlock != null) {
            totalSize += cellBlock.readableBytes();
        }
        return IPCUtil.write(dos, header, param, cellBlock, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param, ByteBuf cellBlock, int totalSize) throws IOException {
        dos.write(Bytes.toBytes(totalSize));
        header.writeDelimitedTo(dos);
        if (param != null) {
            param.writeDelimitedTo(dos);
        }
        if (cellBlock != null) {
            cellBlock.readBytes(dos, cellBlock.readableBytes());
        }
        dos.flush();
        return totalSize;
    }

    public static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m : messages) {
            if (m == null) continue;
            totalSize += m.getSerializedSize();
            totalSize += CodedOutputStream.computeUInt32SizeNoTag(m.getSerializedSize());
        }
        Preconditions.checkArgument(totalSize < Integer.MAX_VALUE);
        return totalSize;
    }

    static RPCProtos.RequestHeader buildRequestHeader(Call call2, RPCProtos.CellBlockMeta cellBlockMeta) {
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        builder.setCallId(call2.id);
        builder.setMethodName(call2.md.getName());
        builder.setRequestParam(call2.param != null);
        if (cellBlockMeta != null) {
            builder.setCellBlockMeta(cellBlockMeta);
        }
        if (call2.priority != -1) {
            builder.setPriority(call2.priority);
        }
        builder.setTimeout(call2.timeout);
        return builder.build();
    }

    static RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
        String innerExceptionClassName = e.getExceptionClassName();
        boolean doNotRetry = e.getDoNotRetry();
        return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
    }

    static boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
        return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
    }

    static IOException toIOE(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    private static String getCallTarget(InetSocketAddress addr, RegionInfo regionInfo) {
        return "address=" + addr + (regionInfo != null ? ", region=" + regionInfo.getRegionNameAsString() : "");
    }

    static IOException wrapException(InetSocketAddress addr, RegionInfo regionInfo, Throwable error) {
        if (error instanceof ConnectException) {
            return (IOException)new ConnectException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on connection exception: " + error).initCause(error);
        }
        if (error instanceof SocketTimeoutException) {
            return (IOException)new SocketTimeoutException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed because " + error).initCause(error);
        }
        if (error instanceof ConnectionClosingException) {
            return new ConnectionClosingException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error, error);
        }
        if (error instanceof ServerTooBusyException) {
            return (IOException)error;
        }
        if (error instanceof DoNotRetryIOException) {
            try {
                return (IOException)error.getClass().asSubclass(DoNotRetryIOException.class).getConstructor(String.class).newInstance("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error).initCause(error);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                return new DoNotRetryIOException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error, error);
            }
        }
        if (error instanceof ConnectionClosedException) {
            return new ConnectionClosedException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error, error);
        }
        if (error instanceof CallTimeoutException) {
            return new CallTimeoutException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error, error);
        }
        if (error instanceof ClosedChannelException) {
            return (IOException)error;
        }
        if (error instanceof TimeoutException) {
            return new TimeoutIOException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error, error);
        }
        if (error instanceof IOException) {
            try {
                return (IOException)error.getClass().asSubclass(IOException.class).getConstructor(String.class).newInstance("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error).initCause(error);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return new HBaseIOException("Call to " + IPCUtil.getCallTarget(addr, regionInfo) + " failed on local exception: " + error, error);
    }

    static void setCancelled(Call call2) {
        call2.setException(new CallCancelledException(call2.toShortString() + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call2.getStartTime()) + ", rpcTimeout=" + call2.timeout));
    }

    static void execute(EventLoop eventLoop, Runnable action) {
        if (eventLoop.inEventLoop()) {
            MutableInt depth = DEPTH.get();
            if (depth.intValue() < 4) {
                depth.increment();
                try {
                    action.run();
                }
                finally {
                    depth.decrement();
                }
            } else {
                eventLoop.execute(action);
            }
        } else {
            eventLoop.execute(action);
        }
    }
}

