/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import org.apache.hudi.org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hudi.org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hudi.org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hudi.org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hudi.org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.MetricsHBaseServerSourceFactory;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsHBaseServer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsHBaseServer.class);
    private MetricsHBaseServerSource source;
    private MetricsHBaseServerWrapper serverWrapper;

    public MetricsHBaseServer(String serverName, MetricsHBaseServerWrapper wrapper) {
        this.serverWrapper = wrapper;
        this.source = CompatibilitySingletonFactory.getInstance(MetricsHBaseServerSourceFactory.class).create(serverName, wrapper);
    }

    void authorizationSuccess() {
        this.source.authorizationSuccess();
    }

    void authorizationFailure() {
        this.source.authorizationFailure();
    }

    void authenticationFailure() {
        this.source.authenticationFailure();
    }

    void authenticationSuccess() {
        this.source.authenticationSuccess();
    }

    void authenticationFallback() {
        this.source.authenticationFallback();
    }

    void sentBytes(long count2) {
        this.source.sentBytes(count2);
    }

    void receivedBytes(int count2) {
        this.source.receivedBytes(count2);
    }

    void sentResponse(long count2) {
        this.source.sentResponse(count2);
    }

    void receivedRequest(long count2) {
        this.source.receivedRequest(count2);
    }

    void dequeuedCall(int qTime) {
        this.source.dequeuedCall(qTime);
    }

    void processedCall(int processingTime) {
        this.source.processedCall(processingTime);
    }

    void totalCall(int totalTime) {
        this.source.queuedAndProcessedCall(totalTime);
    }

    public void exception(Throwable throwable) {
        this.source.exception();
        if (throwable != null) {
            if (throwable instanceof OutOfOrderScannerNextException) {
                this.source.outOfOrderException();
            } else if (throwable instanceof RegionTooBusyException) {
                this.source.tooBusyException();
            } else if (throwable instanceof UnknownScannerException) {
                this.source.unknownScannerException();
            } else if (throwable instanceof ScannerResetException) {
                this.source.scannerResetException();
            } else if (throwable instanceof RegionMovedException) {
                this.source.movedRegionException();
            } else if (throwable instanceof NotServingRegionException) {
                this.source.notServingRegionException();
            } else if (throwable instanceof FailedSanityCheckException) {
                this.source.failedSanityException();
            } else if (throwable instanceof MultiActionResultTooLarge) {
                this.source.multiActionTooLargeException();
            } else if (throwable instanceof CallQueueTooBigException) {
                this.source.callQueueTooBigException();
            } else if (throwable instanceof QuotaExceededException) {
                this.source.quotaExceededException();
            } else if (throwable instanceof RpcThrottlingException) {
                this.source.rpcThrottlingException();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Unknown exception type", throwable);
            }
        }
    }

    public MetricsHBaseServerSource getMetricsSource() {
        return this.source;
    }

    public MetricsHBaseServerWrapper getHBaseServerWrapper() {
        return this.serverWrapper;
    }
}

