/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.assignment;

import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hudi.org.apache.hadoop.hbase.master.RegionState;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionStateNode
implements Comparable<RegionStateNode> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionStateNode.class);
    final Lock lock = new ReentrantLock();
    private final RegionInfo regionInfo;
    private final ProcedureEvent<?> event;
    private final ConcurrentMap<RegionInfo, RegionStateNode> ritMap;
    private volatile TransitRegionStateProcedure procedure = null;
    private volatile ServerName regionLocation = null;
    private volatile ServerName lastHost = null;
    private volatile RegionState.State state = RegionState.State.OFFLINE;
    private volatile long lastUpdate = 0L;
    private volatile long openSeqNum = -1L;

    RegionStateNode(RegionInfo regionInfo, ConcurrentMap<RegionInfo, RegionStateNode> ritMap) {
        this.regionInfo = regionInfo;
        this.event = new AssignmentProcedureEvent(regionInfo);
        this.ritMap = ritMap;
    }

    public boolean setState(RegionState.State update2, RegionState.State ... expected) {
        if (!this.isInState(expected)) {
            return false;
        }
        this.state = update2;
        this.lastUpdate = EnvironmentEdgeManager.currentTime();
        return true;
    }

    public ServerName offline() {
        this.setState(RegionState.State.OFFLINE, new RegionState.State[0]);
        return this.setRegionLocation(null);
    }

    public void transitionState(RegionState.State update2, RegionState.State ... expected) throws UnexpectedStateException {
        if (!this.setState(update2, expected)) {
            throw new UnexpectedStateException("Expected " + Arrays.toString((Object[])expected) + " so could move to " + (Object)((Object)update2) + " but current state=" + (Object)((Object)this.getState()));
        }
    }

    public boolean isInState(RegionState.State ... expected) {
        if (expected.length == 0) {
            return true;
        }
        return this.getState().matches(expected);
    }

    public boolean isStuck() {
        return this.isInState(RegionState.State.FAILED_OPEN) && this.getProcedure() != null;
    }

    public boolean isInTransition() {
        return this.getProcedure() != null;
    }

    public long getLastUpdate() {
        TransitRegionStateProcedure proc = this.procedure;
        return proc != null ? proc.getLastUpdate() : this.lastUpdate;
    }

    public void setLastHost(ServerName serverName) {
        this.lastHost = serverName;
    }

    public void setOpenSeqNum(long seqId) {
        this.openSeqNum = seqId;
    }

    public ServerName setRegionLocation(ServerName serverName) {
        ServerName lastRegionLocation = this.regionLocation;
        if (LOG.isTraceEnabled() && serverName == null) {
            LOG.trace("Tracking when we are set to null " + this, new Throwable("TRACE"));
        }
        this.regionLocation = serverName;
        this.lastUpdate = EnvironmentEdgeManager.currentTime();
        return lastRegionLocation;
    }

    public TransitRegionStateProcedure setProcedure(TransitRegionStateProcedure proc) {
        assert (this.procedure == null);
        this.procedure = proc;
        this.ritMap.put(this.regionInfo, this);
        return proc;
    }

    public void unsetProcedure(TransitRegionStateProcedure proc) {
        assert (this.procedure == proc);
        this.procedure = null;
        this.ritMap.remove(this.regionInfo, this);
    }

    public TransitRegionStateProcedure getProcedure() {
        return this.procedure;
    }

    public ProcedureEvent<?> getProcedureEvent() {
        return this.event;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public TableName getTable() {
        return this.getRegionInfo().getTable();
    }

    public boolean isSystemTable() {
        return this.getTable().isSystemTable();
    }

    public ServerName getLastHost() {
        return this.lastHost;
    }

    public ServerName getRegionLocation() {
        return this.regionLocation;
    }

    public RegionState.State getState() {
        return this.state;
    }

    public long getOpenSeqNum() {
        return this.openSeqNum;
    }

    public int getFormatVersion() {
        return 0;
    }

    public RegionState toRegionState() {
        return new RegionState(this.getRegionInfo(), this.getState(), this.getLastUpdate(), this.getRegionLocation());
    }

    @Override
    public int compareTo(RegionStateNode other) {
        return RegionInfo.COMPARATOR.compare(this.getRegionInfo(), other.getRegionInfo());
    }

    public int hashCode() {
        return this.getRegionInfo().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegionStateNode)) {
            return false;
        }
        return this.compareTo((RegionStateNode)other) == 0;
    }

    public String toString() {
        return this.toDescriptiveString();
    }

    public String toShortString() {
        return String.format("state=%s, location=%s", new Object[]{this.getState(), this.getRegionLocation()});
    }

    public String toDescriptiveString() {
        return String.format("%s, table=%s, region=%s", this.toShortString(), this.getTable(), this.getRegionInfo().getEncodedName());
    }

    public void checkOnline() throws DoNotRetryRegionException {
        RegionInfo ri = this.getRegionInfo();
        RegionState.State s = this.state;
        if (s != RegionState.State.OPEN) {
            throw new DoNotRetryRegionException(ri.getEncodedName() + " is not OPEN; state=" + (Object)((Object)s));
        }
        if (ri.isSplitParent()) {
            throw new DoNotRetryRegionException(ri.getEncodedName() + " is not online (splitParent=true)");
        }
        if (ri.isSplit()) {
            throw new DoNotRetryRegionException(ri.getEncodedName() + " has split=true");
        }
        if (ri.isOffline()) {
            throw new DoNotRetryRegionException(new RegionOfflineException(ri.getEncodedName()));
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    private static final class AssignmentProcedureEvent
    extends ProcedureEvent<RegionInfo> {
        public AssignmentProcedureEvent(RegionInfo regionInfo) {
            super((Object)regionInfo);
        }
    }
}

