/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.balancer;

import java.util.function.Consumer;
import org.apache.hudi.org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class DoubleArrayCost {
    private double[] costs;
    private boolean costsChanged;
    private double cost;

    DoubleArrayCost() {
    }

    void prepare(int length) {
        if (this.costs == null || this.costs.length != length) {
            this.costs = new double[length];
        }
    }

    void applyCostsChange(Consumer<double[]> consumer2) {
        consumer2.accept(this.costs);
        this.costsChanged = true;
    }

    double cost() {
        if (this.costsChanged) {
            this.cost = DoubleArrayCost.computeCost(this.costs);
            this.costsChanged = false;
        }
        return this.cost;
    }

    private static double computeCost(double[] stats) {
        if (stats == null || stats.length == 0) {
            return 0.0;
        }
        double totalCost = 0.0;
        double total = DoubleArrayCost.getSum(stats);
        double count2 = stats.length;
        double mean = total / count2;
        for (int i = 0; i < stats.length; ++i) {
            double n = stats[i];
            double diff = (mean - n) * (mean - n);
            totalCost += diff;
        }
        totalCost = Math.sqrt(totalCost);
        return StochasticLoadBalancer.scale(DoubleArrayCost.getMinSkew(total, count2), DoubleArrayCost.getMaxSkew(total, count2), totalCost);
    }

    private static double getSum(double[] stats) {
        double total = 0.0;
        for (double s : stats) {
            total += s;
        }
        return total;
    }

    public static double getMinSkew(double total, double numServers) {
        double min;
        if (numServers == 0.0) {
            return 0.0;
        }
        double mean = total / numServers;
        if (numServers > total) {
            min = (numServers - total) * mean * mean + (1.0 - mean) * (1.0 - mean) * total;
        } else {
            int numHigh = (int)(total - Math.floor(mean) * numServers);
            int numLow = (int)(numServers - (double)numHigh);
            min = (double)numHigh * (Math.ceil(mean) - mean) * (Math.ceil(mean) - mean) + (double)numLow * (mean - Math.floor(mean)) * (mean - Math.floor(mean));
        }
        return Math.sqrt(min);
    }

    public static double getMaxSkew(double total, double numServers) {
        if (numServers == 0.0) {
            return 0.0;
        }
        double mean = total / numServers;
        return Math.sqrt((total - mean) * (total - mean) + (numServers - 1.0) * mean * mean);
    }
}

