/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.webapp;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hudi.org.apache.hadoop.hbase.CompareOperator;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hudi.org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hudi.org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hudi.org.apache.hadoop.hbase.master.RegionState;
import org.apache.hudi.org.apache.hadoop.hbase.master.webapp.RegionReplicaInfo;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.http.QueryStringEncoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetaBrowser {
    public static final String NAME_PARAM = "name";
    public static final String SCAN_LIMIT_PARAM = "scan_limit";
    public static final String SCAN_REGION_STATE_PARAM = "scan_region_state";
    public static final String SCAN_START_PARAM = "scan_start";
    public static final String SCAN_TABLE_PARAM = "scan_table";
    public static final int SCAN_LIMIT_DEFAULT = 10;
    public static final int SCAN_LIMIT_MAX = 10000;
    private final AsyncConnection connection;
    private final HttpServletRequest request;
    private final List<String> errorMessages;
    private final String name;
    private final Integer scanLimit;
    private final RegionState.State scanRegionState;
    private final byte[] scanStart;
    private final TableName scanTable;

    public MetaBrowser(AsyncConnection connection, HttpServletRequest request) {
        this.connection = connection;
        this.request = request;
        this.errorMessages = new LinkedList<String>();
        this.name = MetaBrowser.resolveName(request);
        this.scanLimit = this.resolveScanLimit(request);
        this.scanRegionState = this.resolveScanRegionState(request);
        this.scanStart = MetaBrowser.resolveScanStart(request);
        this.scanTable = MetaBrowser.resolveScanTable(request);
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public String getName() {
        return this.name;
    }

    public Integer getScanLimit() {
        return this.scanLimit;
    }

    public byte[] getScanStart() {
        return this.scanStart;
    }

    public RegionState.State getScanRegionState() {
        return this.scanRegionState;
    }

    public TableName getScanTable() {
        return this.scanTable;
    }

    public Results getResults() {
        AsyncTable<AdvancedScanResultConsumer> asyncTable = this.connection.getTable(TableName.META_TABLE_NAME);
        return new Results(asyncTable.getScanner(this.buildScan()));
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("scanStart", this.scanStart).append("scanLimit", (Object)this.scanLimit).append("scanTable", (Object)this.scanTable).append("scanRegionState", (Object)this.scanRegionState).toString();
    }

    private static String resolveName(HttpServletRequest request) {
        return MetaBrowser.resolveRequestParameter(request, NAME_PARAM);
    }

    private Integer resolveScanLimit(HttpServletRequest request) {
        String requestValueStr = MetaBrowser.resolveRequestParameter(request, SCAN_LIMIT_PARAM);
        if (StringUtils.isBlank((CharSequence)requestValueStr)) {
            return null;
        }
        Integer requestValue = MetaBrowser.tryParseInt(requestValueStr);
        if (requestValue == null) {
            this.errorMessages.add(MetaBrowser.buildScanLimitMalformedErrorMessage(requestValueStr));
            return null;
        }
        if (requestValue <= 0) {
            this.errorMessages.add(MetaBrowser.buildScanLimitLTEQZero(requestValue));
            return 10;
        }
        int truncatedValue = Math.min(requestValue, 10000);
        if (requestValue != truncatedValue) {
            this.errorMessages.add(MetaBrowser.buildScanLimitExceededErrorMessage(requestValue));
        }
        return truncatedValue;
    }

    private RegionState.State resolveScanRegionState(HttpServletRequest request) {
        String requestValueStr = MetaBrowser.resolveRequestParameter(request, SCAN_REGION_STATE_PARAM);
        if (requestValueStr == null) {
            return null;
        }
        RegionState.State requestValue = MetaBrowser.tryValueOf(RegionState.State.class, requestValueStr);
        if (requestValue == null) {
            this.errorMessages.add(MetaBrowser.buildScanRegionStateMalformedErrorMessage(requestValueStr));
            return null;
        }
        return requestValue;
    }

    private static byte[] resolveScanStart(HttpServletRequest request) {
        String requestValue = MetaBrowser.resolveRequestParameter(request, SCAN_START_PARAM);
        if (requestValue == null) {
            return null;
        }
        return Bytes.toBytesBinary(requestValue);
    }

    private static TableName resolveScanTable(HttpServletRequest request) {
        String requestValue = MetaBrowser.resolveRequestParameter(request, SCAN_TABLE_PARAM);
        if (requestValue == null) {
            return null;
        }
        return TableName.valueOf(requestValue);
    }

    private static String resolveRequestParameter(HttpServletRequest request, String param) {
        if (request == null) {
            return null;
        }
        String requestValueStrEnc = request.getParameter(param);
        if (StringUtils.isBlank((CharSequence)requestValueStrEnc)) {
            return null;
        }
        return MetaBrowser.urlDecode(requestValueStrEnc);
    }

    private static Filter buildTableFilter(TableName tableName) {
        return new PrefixFilter(tableName.toBytes());
    }

    private static Filter buildScanRegionStateFilter(RegionState.State state) {
        return new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, CompareOperator.EQUAL, Bytes.toBytes(state.name()));
    }

    private Filter buildScanFilter() {
        if (this.scanTable == null && this.scanRegionState == null) {
            return null;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>(2);
        if (this.scanTable != null) {
            filters.add(MetaBrowser.buildTableFilter(this.scanTable));
        }
        if (this.scanRegionState != null) {
            filters.add(MetaBrowser.buildScanRegionStateFilter(this.scanRegionState));
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
    }

    private Scan buildScan() {
        Filter filter;
        Scan metaScan = new Scan().addFamily(HConstants.CATALOG_FAMILY).readVersions(1).setLimit((this.scanLimit != null ? this.scanLimit : 10) + 1);
        if (this.scanStart != null) {
            metaScan.withStartRow(this.scanStart, false);
        }
        if ((filter = this.buildScanFilter()) != null) {
            metaScan.setFilter(filter);
        }
        return metaScan;
    }

    private void addParam(QueryStringEncoder encoder2, String paramName, Object value) {
        if (value != null) {
            encoder2.addParam(paramName, value.toString());
        }
    }

    private QueryStringEncoder buildFirstPageEncoder() {
        QueryStringEncoder encoder2 = new QueryStringEncoder(this.request.getRequestURI());
        this.addParam(encoder2, NAME_PARAM, this.name);
        this.addParam(encoder2, SCAN_LIMIT_PARAM, this.scanLimit);
        this.addParam(encoder2, SCAN_REGION_STATE_PARAM, (Object)this.scanRegionState);
        this.addParam(encoder2, SCAN_TABLE_PARAM, this.scanTable);
        return encoder2;
    }

    public String buildFirstPageUrl() {
        return this.buildFirstPageEncoder().toString();
    }

    static String buildStartParamFrom(byte[] lastRow) {
        if (lastRow == null) {
            return null;
        }
        return MetaBrowser.urlEncode(Bytes.toStringBinary(lastRow));
    }

    public String buildNextPageUrl(byte[] lastRow) {
        QueryStringEncoder encoder2 = this.buildFirstPageEncoder();
        String startRow = MetaBrowser.buildStartParamFrom(lastRow);
        this.addParam(encoder2, SCAN_START_PARAM, startRow);
        return encoder2.toString();
    }

    private static String urlEncode(String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        try {
            return URLEncoder.encode(val, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String urlDecode(String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        try {
            return URLDecoder.decode(val, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static Integer tryParseInt(String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static <T extends Enum<T>> T tryValueOf(Class<T> clazz, String value) {
        if (clazz == null || value == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String buildScanLimitExceededErrorMessage(int requestValue) {
        return String.format("Requested SCAN_LIMIT value %d exceeds maximum value %d.", requestValue, 10000);
    }

    private static String buildScanLimitMalformedErrorMessage(String requestValue) {
        return String.format("Requested SCAN_LIMIT value '%s' cannot be parsed as an integer.", requestValue);
    }

    private static String buildScanLimitLTEQZero(int requestValue) {
        return String.format("Requested SCAN_LIMIT value %d is <= 0.", requestValue);
    }

    private static String buildScanRegionStateMalformedErrorMessage(String requestValue) {
        return String.format("Requested SCAN_REGION_STATE value '%s' cannot be parsed as a RegionState.", requestValue);
    }

    public final class Results
    implements AutoCloseable,
    Iterable<RegionReplicaInfo> {
        private final ResultScanner resultScanner;
        private final Iterator<RegionReplicaInfo> sourceIterator;

        private Results(ResultScanner resultScanner) {
            this.resultScanner = resultScanner;
            this.sourceIterator = StreamSupport.stream(resultScanner.spliterator(), false).map(RegionReplicaInfo::from).flatMap(Collection::stream).iterator();
        }

        public boolean hasMoreResults() {
            return this.sourceIterator.hasNext();
        }

        @Override
        public void close() {
            if (this.resultScanner != null) {
                this.resultScanner.close();
            }
        }

        @Override
        public Iterator<RegionReplicaInfo> iterator() {
            return Iterators.limit(this.sourceIterator, MetaBrowser.this.scanLimit != null ? MetaBrowser.this.scanLimit : 10);
        }
    }
}

