/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class CellFlatMap
implements NavigableMap<Cell, Cell> {
    private static final Logger LOG = LoggerFactory.getLogger(CellFlatMap.class);
    private final Comparator<? super Cell> comparator;
    protected int minCellIdx = 0;
    protected int maxCellIdx = 0;
    private boolean descending = false;

    public CellFlatMap(Comparator<? super Cell> comparator, int min, int max, boolean d) {
        this.comparator = comparator;
        this.minCellIdx = min;
        this.maxCellIdx = max;
        this.descending = d;
    }

    protected abstract CellFlatMap createSubCellFlatMap(int var1, int var2, boolean var3);

    protected abstract Cell getCell(int var1);

    private int find(Cell needle) {
        int begin = this.minCellIdx;
        int end = this.maxCellIdx - 1;
        while (begin <= end) {
            int mid = begin + (end - begin >> 1);
            Cell midCell = this.getCell(mid);
            int compareRes = this.comparator.compare(midCell, needle);
            if (compareRes == 0) {
                return mid;
            }
            if (compareRes < 0 ^ this.descending) {
                begin = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return -1 * begin - 1;
    }

    private int getValidIndex(Cell key, boolean inclusive, boolean tail) {
        int insertionPoint;
        int index = this.find(key);
        int n = insertionPoint = index < 0 ? ~index : index;
        if (index >= 0) {
            if (this.descending && !(tail ^ inclusive)) {
                ++insertionPoint;
            } else if (!this.descending && tail ^ inclusive) {
                ++insertionPoint;
            }
        }
        return Math.min(Math.max(insertionPoint, this.minCellIdx), this.maxCellIdx);
    }

    @Override
    public Comparator<? super Cell> comparator() {
        return this.comparator;
    }

    @Override
    public int size() {
        return this.maxCellIdx - this.minCellIdx;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public NavigableMap<Cell, Cell> subMap(Cell fromKey, boolean fromInclusive, Cell toKey, boolean toInclusive) {
        int lessCellIndex = this.getValidIndex(fromKey, fromInclusive, true);
        int greaterCellIndex = this.getValidIndex(toKey, toInclusive, false);
        if (this.descending) {
            return this.createSubCellFlatMap(greaterCellIndex, lessCellIndex, this.descending);
        }
        return this.createSubCellFlatMap(lessCellIndex, greaterCellIndex, this.descending);
    }

    @Override
    public NavigableMap<Cell, Cell> headMap(Cell toKey, boolean inclusive) {
        if (this.descending) {
            return this.createSubCellFlatMap(this.getValidIndex(toKey, inclusive, false), this.maxCellIdx, this.descending);
        }
        return this.createSubCellFlatMap(this.minCellIdx, this.getValidIndex(toKey, inclusive, false), this.descending);
    }

    @Override
    public NavigableMap<Cell, Cell> tailMap(Cell fromKey, boolean inclusive) {
        if (this.descending) {
            return this.createSubCellFlatMap(this.minCellIdx, this.getValidIndex(fromKey, inclusive, true), this.descending);
        }
        return this.createSubCellFlatMap(this.getValidIndex(fromKey, inclusive, true), this.maxCellIdx, this.descending);
    }

    @Override
    public NavigableMap<Cell, Cell> descendingMap() {
        return this.createSubCellFlatMap(this.minCellIdx, this.maxCellIdx, true);
    }

    @Override
    public NavigableMap<Cell, Cell> subMap(Cell k1, Cell k2) {
        return this.subMap(k1, true, k2, true);
    }

    @Override
    public NavigableMap<Cell, Cell> headMap(Cell k) {
        return this.headMap(k, true);
    }

    @Override
    public NavigableMap<Cell, Cell> tailMap(Cell k) {
        return this.tailMap(k, true);
    }

    @Override
    public Cell firstKey() {
        if (this.isEmpty()) {
            return null;
        }
        return this.descending ? this.getCell(this.maxCellIdx - 1) : this.getCell(this.minCellIdx);
    }

    @Override
    public Cell lastKey() {
        if (this.isEmpty()) {
            return null;
        }
        return this.descending ? this.getCell(this.minCellIdx) : this.getCell(this.maxCellIdx - 1);
    }

    @Override
    public Cell lowerKey(Cell k) {
        if (this.isEmpty()) {
            return null;
        }
        int index = this.find(k);
        index = index >= 0 ? index - 1 : -index;
        return index < this.minCellIdx || index >= this.maxCellIdx ? null : this.getCell(index);
    }

    @Override
    public Cell floorKey(Cell k) {
        if (this.isEmpty()) {
            return null;
        }
        int index = this.find(k);
        index = index >= 0 ? index : -index;
        return index < this.minCellIdx || index >= this.maxCellIdx ? null : this.getCell(index);
    }

    @Override
    public Cell ceilingKey(Cell k) {
        if (this.isEmpty()) {
            return null;
        }
        int index = this.find(k);
        index = index >= 0 ? index : -index + 1;
        return index < this.minCellIdx || index >= this.maxCellIdx ? null : this.getCell(index);
    }

    @Override
    public Cell higherKey(Cell k) {
        if (this.isEmpty()) {
            return null;
        }
        int index = this.find(k);
        index = index >= 0 ? index + 1 : -index + 1;
        return index < this.minCellIdx || index >= this.maxCellIdx ? null : this.getCell(index);
    }

    @Override
    public boolean containsKey(Object o) {
        int index = this.find((Cell)o);
        return index >= 0;
    }

    @Override
    public boolean containsValue(Object o) {
        throw new UnsupportedOperationException("Use containsKey(Object o) instead");
    }

    @Override
    public Cell get(Object o) {
        int index = this.find((Cell)o);
        return index >= 0 ? this.getCell(index) : null;
    }

    @Override
    public Map.Entry<Cell, Cell> lowerEntry(Cell k) {
        Cell cell = this.lowerKey(k);
        if (cell == null) {
            return null;
        }
        return new CellFlatMapEntry(cell);
    }

    @Override
    public Map.Entry<Cell, Cell> higherEntry(Cell k) {
        Cell cell = this.higherKey(k);
        if (cell == null) {
            return null;
        }
        return new CellFlatMapEntry(cell);
    }

    @Override
    public Map.Entry<Cell, Cell> ceilingEntry(Cell k) {
        Cell cell = this.ceilingKey(k);
        if (cell == null) {
            return null;
        }
        return new CellFlatMapEntry(cell);
    }

    @Override
    public Map.Entry<Cell, Cell> floorEntry(Cell k) {
        Cell cell = this.floorKey(k);
        if (cell == null) {
            return null;
        }
        return new CellFlatMapEntry(cell);
    }

    @Override
    public Map.Entry<Cell, Cell> firstEntry() {
        Cell cell = this.firstKey();
        if (cell == null) {
            return null;
        }
        return new CellFlatMapEntry(cell);
    }

    @Override
    public Map.Entry<Cell, Cell> lastEntry() {
        Cell cell = this.lastKey();
        if (cell == null) {
            return null;
        }
        return new CellFlatMapEntry(cell);
    }

    @Override
    public Map.Entry<Cell, Cell> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<Cell, Cell> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell put(Cell k, Cell v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Cell, ? extends Cell> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Cell> navigableKeySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Cell> descendingKeySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Cell> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Cell> values() {
        return new CellFlatMapCollection();
    }

    @Override
    public Set<Map.Entry<Cell, Cell>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private final class CellFlatMapCollection
    implements Collection<Cell> {
        private CellFlatMapCollection() {
        }

        @Override
        public int size() {
            return CellFlatMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CellFlatMap.this.isEmpty();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return CellFlatMap.this.containsKey(o);
        }

        @Override
        public Iterator<Cell> iterator() {
            return new CellFlatMapIterator();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Cell k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Cell> collection2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection2) {
            throw new UnsupportedOperationException();
        }
    }

    private final class CellFlatMapIterator
    implements Iterator<Cell> {
        int index;

        private CellFlatMapIterator() {
            this.index = CellFlatMap.this.descending ? CellFlatMap.this.maxCellIdx - 1 : CellFlatMap.this.minCellIdx;
        }

        @Override
        public boolean hasNext() {
            return CellFlatMap.this.descending ? this.index >= CellFlatMap.this.minCellIdx : this.index < CellFlatMap.this.maxCellIdx;
        }

        @Override
        public Cell next() {
            Cell result = CellFlatMap.this.getCell(this.index);
            this.index = CellFlatMap.this.descending ? --this.index : ++this.index;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CellFlatMapEntry
    implements Map.Entry<Cell, Cell> {
        private final Cell cell;

        public CellFlatMapEntry(Cell cell) {
            this.cell = cell;
        }

        @Override
        public Cell getKey() {
            return this.cell;
        }

        @Override
        public Cell getValue() {
            return this.cell;
        }

        @Override
        public Cell setValue(Cell value) {
            throw new UnsupportedOperationException();
        }
    }
}

