/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.NewVersionBehaviorTracker;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class VisibilityNewVersionBehaivorTracker
extends NewVersionBehaviorTracker {
    private static final Logger LOG = LoggerFactory.getLogger(VisibilityNewVersionBehaivorTracker.class);

    public VisibilityNewVersionBehaivorTracker(NavigableSet<byte[]> columns, CellComparator cellComparator, int minVersion, int maxVersion, int resultMaxVersions, long oldestUnexpiredTS) {
        super(columns, cellComparator, minVersion, maxVersion, resultMaxVersions, oldestUnexpiredTS);
    }

    @Override
    public void add(Cell cell) {
        this.prepare(cell);
        byte type = cell.getTypeByte();
        switch (KeyValue.Type.codeToType(type)) {
            case DeleteFamily: {
                this.delFamMap.put(cell.getSequenceId(), new VisibilityDeleteVersionsNode(cell.getTimestamp(), cell.getSequenceId(), new TagInfo(cell)));
                break;
            }
            case DeleteFamilyVersion: {
                ((NewVersionBehaviorTracker.DeleteVersionsNode)this.delFamMap.ceilingEntry(cell.getSequenceId()).getValue()).addVersionDelete(cell);
                break;
            }
            case DeleteColumn: {
                this.delColMap.put(cell.getSequenceId(), new VisibilityDeleteVersionsNode(cell.getTimestamp(), cell.getSequenceId(), new TagInfo(cell)));
                break;
            }
            case Delete: {
                ((NewVersionBehaviorTracker.DeleteVersionsNode)this.delColMap.ceilingEntry(cell.getSequenceId()).getValue()).addVersionDelete(cell);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown delete marker type for " + cell));
            }
        }
    }

    private boolean tagMatched(Cell put2, TagInfo delInfo) throws IOException {
        ArrayList<Tag> putVisTags = new ArrayList<Tag>();
        Byte putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(put2, putVisTags);
        return putVisTags.isEmpty() == delInfo.tags.isEmpty() && (putVisTags.isEmpty() && delInfo.tags.isEmpty() || VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, delInfo.tags, delInfo.format));
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        try {
            long duplicateMvcc = this.prepare(cell);
            for (Map.Entry e : this.delColMap.tailMap(cell.getSequenceId()).entrySet()) {
                VisibilityDeleteVersionsNode node = (VisibilityDeleteVersionsNode)e.getValue();
                long deleteMvcc = Long.MAX_VALUE;
                SortedMap deleteVersionMvccs = (SortedMap)node.deletesMap.get(cell.getTimestamp());
                if (deleteVersionMvccs != null) {
                    SortedMap tail = deleteVersionMvccs.tailMap(cell.getSequenceId());
                    for (Map.Entry entry : tail.entrySet()) {
                        if (!this.tagMatched(cell, (TagInfo)entry.getValue())) continue;
                        deleteMvcc = tail.firstKey();
                        break;
                    }
                }
                NavigableMap subMap = node.mvccCountingMap.subMap(cell.getSequenceId(), true, Math.min(duplicateMvcc, deleteMvcc), true);
                for (Map.Entry entry : subMap.entrySet()) {
                    if (((SortedSet)entry.getValue()).size() >= this.maxVersions) {
                        return DeleteTracker.DeleteResult.VERSION_MASKED;
                    }
                    ((SortedSet)entry.getValue()).add(cell.getSequenceId());
                }
                if (deleteMvcc < Long.MAX_VALUE) {
                    return DeleteTracker.DeleteResult.VERSION_DELETED;
                }
                if (cell.getTimestamp() > node.ts || !this.tagMatched(cell, node.tagInfo)) continue;
                return DeleteTracker.DeleteResult.COLUMN_DELETED;
            }
            if (duplicateMvcc < Long.MAX_VALUE) {
                return DeleteTracker.DeleteResult.VERSION_MASKED;
            }
        }
        catch (IOException e) {
            LOG.error("Error in isDeleted() check! Will treat cell as not deleted", (Throwable)e);
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    protected void resetInternal() {
        this.delFamMap.put(Long.MAX_VALUE, new VisibilityDeleteVersionsNode(Long.MIN_VALUE, Long.MAX_VALUE, new TagInfo()));
    }

    private class VisibilityDeleteVersionsNode
    extends NewVersionBehaviorTracker.DeleteVersionsNode {
        private TagInfo tagInfo;
        private Map<Long, SortedMap<Long, TagInfo>> deletesMap = new HashMap<Long, SortedMap<Long, TagInfo>>();
        private NavigableMap<Long, SortedSet<Long>> mvccCountingMap = new TreeMap<Long, SortedSet<Long>>();

        protected VisibilityDeleteVersionsNode(long ts, long mvcc, TagInfo tagInfo) {
            this.tagInfo = tagInfo;
            this.ts = ts;
            this.mvcc = mvcc;
            this.mvccCountingMap.put(Long.MAX_VALUE, new TreeSet());
        }

        @Override
        protected VisibilityDeleteVersionsNode getDeepCopy() {
            VisibilityDeleteVersionsNode node = new VisibilityDeleteVersionsNode(this.ts, this.mvcc, this.tagInfo);
            for (Map.Entry<Long, SortedMap<Long, TagInfo>> entry : this.deletesMap.entrySet()) {
                node.deletesMap.put(entry.getKey(), new TreeMap<Long, TagInfo>(entry.getValue()));
            }
            for (Map.Entry<Long, SortedMap<Long, TagInfo>> entry : this.mvccCountingMap.entrySet()) {
                node.mvccCountingMap.put(entry.getKey(), new TreeSet((SortedSet)((Object)entry.getValue())));
            }
            return node;
        }

        @Override
        public void addVersionDelete(Cell cell) {
            SortedMap<Long, TagInfo> set = this.deletesMap.get(cell.getTimestamp());
            if (set == null) {
                set = new TreeMap<Long, TagInfo>();
                this.deletesMap.put(cell.getTimestamp(), set);
            }
            set.put(cell.getSequenceId(), new TagInfo(cell));
            SortedSet<Long> nextValue = this.mvccCountingMap.ceilingEntry(cell.getSequenceId()).getValue();
            TreeSet<Long> thisValue = new TreeSet<Long>(nextValue.headSet(cell.getSequenceId()));
            this.mvccCountingMap.put(cell.getSequenceId(), thisValue);
        }
    }

    private static class TagInfo {
        List<Tag> tags = new ArrayList<Tag>();
        Byte format;

        private TagInfo(Cell c) {
            this.format = VisibilityUtils.extractVisibilityTags(c, this.tags);
        }

        private TagInfo() {
        }
    }
}

