/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.NonReversedNonLazyKeyValueScanner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CollectionBackedScanner
extends NonReversedNonLazyKeyValueScanner {
    private final Iterable<Cell> data;
    final CellComparator comparator;
    private Iterator<Cell> iter;
    private Cell current;

    public CollectionBackedScanner(SortedSet<Cell> set) {
        this(set, CellComparator.getInstance());
    }

    public CollectionBackedScanner(SortedSet<Cell> set, CellComparator comparator) {
        this.comparator = comparator;
        this.data = set;
        this.init();
    }

    public CollectionBackedScanner(List<Cell> list) {
        this(list, CellComparator.getInstance());
    }

    public CollectionBackedScanner(List<Cell> list, CellComparator comparator) {
        Collections.sort(list, comparator);
        this.comparator = comparator;
        this.data = list;
        this.init();
    }

    public CollectionBackedScanner(CellComparator comparator, Cell ... array2) {
        this.comparator = comparator;
        ArrayList<Cell> tmp = new ArrayList<Cell>(array2.length);
        Collections.addAll(tmp, array2);
        Collections.sort(tmp, comparator);
        this.data = tmp;
        this.init();
    }

    private void init() {
        this.iter = this.data.iterator();
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
        }
    }

    @Override
    public Cell peek() {
        return this.current;
    }

    @Override
    public Cell next() {
        Cell oldCurrent = this.current;
        this.current = this.iter.hasNext() ? this.iter.next() : null;
        return oldCurrent;
    }

    @Override
    public boolean seek(Cell seekCell) {
        this.iter = this.data.iterator();
        return this.reseek(seekCell);
    }

    @Override
    public boolean reseek(Cell seekCell) {
        while (this.iter.hasNext()) {
            Cell next = this.iter.next();
            int ret = this.comparator.compare(next, seekCell);
            if (ret < 0) continue;
            this.current = next;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }
}

