/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class FSRegionScanner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FSRegionScanner.class);
    private Path regionPath;
    private FileSystem fs;
    private final Map<String, String> regionToBestLocalityRSMapping;
    private Map<String, Map<String, Float>> regionDegreeLocalityMapping;

    FSRegionScanner(FileSystem fs, Path regionPath, Map<String, String> regionToBestLocalityRSMapping, Map<String, Map<String, Float>> regionDegreeLocalityMapping) {
        this.fs = fs;
        this.regionPath = regionPath;
        this.regionToBestLocalityRSMapping = regionToBestLocalityRSMapping;
        this.regionDegreeLocalityMapping = regionDegreeLocalityMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            HashMap<String, AtomicInteger> blockCountMap = new HashMap<String, AtomicInteger>();
            String tableName = this.regionPath.getParent().getName();
            int totalBlkCount = 0;
            FileStatus[] cfList = this.fs.listStatus(this.regionPath, (PathFilter)new FSUtils.FamilyDirFilter(this.fs));
            if (null == cfList) {
                return;
            }
            for (FileStatus fileStatus : cfList) {
                FileStatus[] storeFileLists;
                if (!fileStatus.isDirectory() || null == (storeFileLists = this.fs.listStatus(fileStatus.getPath()))) continue;
                for (FileStatus storeFile : storeFileLists) {
                    BlockLocation[] blkLocations = this.fs.getFileBlockLocations(storeFile, 0L, storeFile.getLen());
                    if (null == blkLocations) continue;
                    totalBlkCount += blkLocations.length;
                    for (BlockLocation blk : blkLocations) {
                        for (String host : blk.getHosts()) {
                            AtomicInteger count2 = (AtomicInteger)blockCountMap.get(host);
                            if (count2 == null) {
                                count2 = new AtomicInteger(0);
                                blockCountMap.put(host, count2);
                            }
                            count2.incrementAndGet();
                        }
                    }
                }
            }
            if (this.regionToBestLocalityRSMapping != null) {
                int largestBlkCount = 0;
                String hostToRun = null;
                for (Map.Entry entry : blockCountMap.entrySet()) {
                    String host = (String)entry.getKey();
                    int tmp = ((AtomicInteger)entry.getValue()).get();
                    if (tmp <= largestBlkCount) continue;
                    largestBlkCount = tmp;
                    hostToRun = host;
                }
                if (null == hostToRun) {
                    return;
                }
                if (hostToRun.endsWith(".")) {
                    hostToRun = hostToRun.substring(0, hostToRun.length() - 1);
                }
                String name = tableName + ":" + this.regionPath.getName();
                Map<String, String> map = this.regionToBestLocalityRSMapping;
                synchronized (map) {
                    this.regionToBestLocalityRSMapping.put(name, hostToRun);
                }
            }
            if (this.regionDegreeLocalityMapping != null && totalBlkCount > 0) {
                HashMap<void, Float> hostLocalityMap = new HashMap<void, Float>();
                for (Map.Entry entry : blockCountMap.entrySet()) {
                    void var8_23;
                    String string = (String)entry.getKey();
                    if (string.endsWith(".")) {
                        String string2 = string.substring(0, string.length() - 1);
                    }
                    float locality = (float)((AtomicInteger)entry.getValue()).get() / (float)totalBlkCount;
                    hostLocalityMap.put(var8_23, Float.valueOf(locality));
                }
                this.regionDegreeLocalityMapping.put(this.regionPath.getName(), hostLocalityMap);
            }
        }
        catch (IOException e) {
            LOG.warn("Problem scanning file system", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.warn("Problem scanning file system", (Throwable)e);
        }
    }
}

