/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JVM {
    private static final Logger LOG = LoggerFactory.getLogger(JVM.class);
    private OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
    private static final boolean ibmvendor = System.getProperty("java.vendor") != null && System.getProperty("java.vendor").contains("IBM");
    private static final boolean windows = System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows");
    private static final boolean linux = System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Linux");
    private static final boolean amd64 = System.getProperty("os.arch") != null && System.getProperty("os.arch").contains("amd64");
    private static final String JVMVersion = System.getProperty("java.version");
    private static final String JVM_SPEC_VERSION_STRING = System.getProperty("java.specification.version");
    private static final int JVM_SPEC_VERSION = JVM_SPEC_VERSION_STRING.contains(".") ? (int)(Float.parseFloat(JVM_SPEC_VERSION_STRING) * 10.0f % 10.0f) : Integer.parseInt(JVM_SPEC_VERSION_STRING);

    public static boolean isUnix() {
        if (windows) {
            return false;
        }
        return ibmvendor ? linux : true;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isAmd64() {
        return amd64;
    }

    public static boolean isGZIPOutputStreamFinishBroken() {
        return ibmvendor && JVMVersion.contains("1.6.0");
    }

    public static int getJVMSpecVersion() {
        return JVM_SPEC_VERSION;
    }

    private Long runUnixMXBeanMethod(String mBeanMethodName) {
        try {
            Class<?> classRef = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            if (classRef.isInstance(this.osMbean)) {
                Method mBeanMethod = classRef.getMethod(mBeanMethodName, new Class[0]);
                Object unixos = classRef.cast(this.osMbean);
                return (Long)mBeanMethod.invoke(unixos, new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn("Not able to load class or method for com.sun.management.UnixOperatingSystemMXBean.", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOpenFileDescriptorCount() {
        if (!ibmvendor) {
            Long ofdc = this.runUnixMXBeanMethod("getOpenFileDescriptorCount");
            return ofdc != null ? ofdc : -1L;
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            RuntimeMXBean rtmbean = ManagementFactory.getRuntimeMXBean();
            String rtname = rtmbean.getName();
            String[] pidhost = rtname.split("@");
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ls /proc/" + pidhost[0] + "/fdinfo | wc -l"});
            inputStream = p.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            String openFileDesCount = bufferedReader.readLine();
            if (openFileDesCount != null) {
                long l = Long.parseLong(openFileDesCount);
                return l;
            }
        }
        catch (IOException ie) {
            LOG.warn("Not able to get the number of open file descriptors", (Throwable)ie);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the BufferedReader", (Throwable)e);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStreamReader", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStream", (Throwable)e);
                }
            }
        }
        return -1L;
    }

    public double getSystemLoadAverage() {
        return this.osMbean.getSystemLoadAverage();
    }

    public long getFreeMemory() {
        if (ibmvendor) {
            return 0L;
        }
        Long r = this.runUnixMXBeanMethod("getFreePhysicalMemorySize");
        return r != null ? r : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE"}, justification="used by testing")
    public int getNumberOfRunningProcess() {
        if (!JVM.isUnix()) {
            return 0;
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            int count2 = 0;
            Process p = Runtime.getRuntime().exec("ps -e");
            inputStream = p.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            while (bufferedReader.readLine() != null) {
                ++count2;
            }
            int n = count2 - 1;
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the BufferedReader", (Throwable)e);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStreamReader", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxFileDescriptorCount() {
        if (!ibmvendor) {
            Long mfdc = this.runUnixMXBeanMethod("getMaxFileDescriptorCount");
            return mfdc != null ? mfdc : -1L;
        }
        InputStream in = null;
        BufferedReader output = null;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ulimit -n"});
            in = p.getInputStream();
            output = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String maxFileDesCount = output.readLine();
            if (maxFileDesCount != null) {
                long l = Long.parseLong(maxFileDesCount);
                return l;
            }
        }
        catch (IOException ie) {
            LOG.warn("Not able to get the max number of file descriptors", (Throwable)ie);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the reader", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStream", (Throwable)e);
                }
            }
        }
        return -1L;
    }
}

