/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.annotations.GwtCompatible;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Objects;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Collections2;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ForwardingObject;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ObjectArrays;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public abstract class ForwardingCollection<E>
extends ForwardingObject
implements Collection<E> {
    protected ForwardingCollection() {
    }

    @Override
    protected abstract Collection<E> delegate();

    @Override
    public Iterator<E> iterator() {
        return this.delegate().iterator();
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeAll(Collection<?> collection2) {
        return this.delegate().removeAll(collection2);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate().contains(object);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean add(E element) {
        return this.delegate().add(element);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(Object object) {
        return this.delegate().remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection2) {
        return this.delegate().containsAll(collection2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addAll(Collection<? extends E> collection2) {
        return this.delegate().addAll(collection2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean retainAll(Collection<?> collection2) {
        return this.delegate().retainAll(collection2);
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    @Override
    @CanIgnoreReturnValue
    public <T> T[] toArray(T[] array2) {
        return this.delegate().toArray(array2);
    }

    protected boolean standardContains(@Nullable Object object) {
        return Iterators.contains(this.iterator(), object);
    }

    protected boolean standardContainsAll(Collection<?> collection2) {
        return Collections2.containsAllImpl(this, collection2);
    }

    protected boolean standardAddAll(Collection<? extends E> collection2) {
        return Iterators.addAll(this, collection2.iterator());
    }

    protected boolean standardRemove(@Nullable Object object) {
        Iterator<E> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (!Objects.equal(iterator2.next(), object)) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    protected boolean standardRemoveAll(Collection<?> collection2) {
        return Iterators.removeAll(this.iterator(), collection2);
    }

    protected boolean standardRetainAll(Collection<?> collection2) {
        return Iterators.retainAll(this.iterator(), collection2);
    }

    protected void standardClear() {
        Iterators.clear(this.iterator());
    }

    protected boolean standardIsEmpty() {
        return !this.iterator().hasNext();
    }

    protected String standardToString() {
        return Collections2.toStringImpl(this);
    }

    protected Object[] standardToArray() {
        Object[] newArray = new Object[this.size()];
        return this.toArray(newArray);
    }

    protected <T> T[] standardToArray(T[] array2) {
        return ObjectArrays.toArrayImpl(this, array2);
    }
}

