/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.protobuf;

import com.google.protobuf.nano.MessageNano;
import java.util.List;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = ObjectUtil.checkNotNull(clazz, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array2;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array2 = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array2 = ByteBufUtil.getBytes(msg, msg.readerIndex(), length, false);
            offset = 0;
        }
        MessageNano prototype = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        out.add(MessageNano.mergeFrom((MessageNano)prototype, (byte[])array2, (int)offset, (int)length));
    }
}

