/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.fs.OptimisticConsistencyGuard;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.bootstrap.HoodieBootstrapWriteMetadata;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.storage.HoodieLayoutFactory;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class HoodieTable<T extends HoodieRecordPayload, I, K, O>
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieTable.class);
    protected final HoodieWriteConfig config;
    protected final HoodieTableMetaClient metaClient;
    protected final HoodieIndex<?, ?> index;
    private SerializableConfiguration hadoopConfiguration;
    protected final TaskContextSupplier taskContextSupplier;
    private final HoodieTableMetadata metadata;
    private final HoodieStorageLayout storageLayout;
    private transient FileSystemViewManager viewManager;
    protected final transient HoodieEngineContext context;

    protected HoodieTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        this.config = config;
        this.hadoopConfiguration = context.getHadoopConf();
        this.context = context;
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(config.getMetadataConfig().getProps()).build();
        this.metadata = HoodieTableMetadata.create(context, metadataConfig, config.getBasePath(), FileSystemViewStorageConfig.SPILLABLE_DIR.defaultValue());
        this.viewManager = FileSystemViewManager.createViewManager(context, config.getMetadataConfig(), config.getViewStorageConfig(), config.getCommonConfig(), () -> this.metadata);
        this.metaClient = metaClient;
        this.index = this.getIndex(config, context);
        this.storageLayout = this.getStorageLayout(config);
        this.taskContextSupplier = context.getTaskContextSupplier();
    }

    protected abstract HoodieIndex<?, ?> getIndex(HoodieWriteConfig var1, HoodieEngineContext var2);

    protected HoodieStorageLayout getStorageLayout(HoodieWriteConfig config) {
        return HoodieLayoutFactory.createLayout(config);
    }

    private synchronized FileSystemViewManager getViewManager() {
        if (null == this.viewManager) {
            this.viewManager = FileSystemViewManager.createViewManager(this.getContext(), this.config.getMetadataConfig(), this.config.getViewStorageConfig(), this.config.getCommonConfig(), () -> this.metadata);
        }
        return this.viewManager;
    }

    public HoodieTableMetadata getMetadata() {
        return this.metadata;
    }

    public abstract HoodieWriteMetadata<O> upsert(HoodieEngineContext var1, String var2, I var3);

    public abstract HoodieWriteMetadata<O> insert(HoodieEngineContext var1, String var2, I var3);

    public abstract HoodieWriteMetadata<O> bulkInsert(HoodieEngineContext var1, String var2, I var3, Option<BulkInsertPartitioner> var4);

    public abstract HoodieWriteMetadata<O> delete(HoodieEngineContext var1, String var2, K var3);

    public abstract HoodieWriteMetadata deletePartitions(HoodieEngineContext var1, String var2, List<String> var3);

    public abstract HoodieWriteMetadata<O> upsertPrepped(HoodieEngineContext var1, String var2, I var3);

    public abstract HoodieWriteMetadata<O> insertPrepped(HoodieEngineContext var1, String var2, I var3);

    public abstract HoodieWriteMetadata<O> bulkInsertPrepped(HoodieEngineContext var1, String var2, I var3, Option<BulkInsertPartitioner> var4);

    public abstract HoodieWriteMetadata<O> insertOverwrite(HoodieEngineContext var1, String var2, I var3);

    public abstract HoodieWriteMetadata<O> insertOverwriteTable(HoodieEngineContext var1, String var2, I var3);

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieTableMetaClient getMetaClient() {
        return this.metaClient;
    }

    public Configuration getHadoopConf() {
        return this.metaClient.getHadoopConf();
    }

    public TableFileSystemView getFileSystemView() {
        return new HoodieTableFileSystemView(this.metaClient, this.getCompletedCommitsTimeline());
    }

    public TableFileSystemView.BaseFileOnlyView getBaseFileOnlyView() {
        return this.getViewManager().getFileSystemView(this.metaClient);
    }

    public TableFileSystemView.SliceView getSliceView() {
        return this.getViewManager().getFileSystemView(this.metaClient);
    }

    public SyncableFileSystemView getHoodieView() {
        return this.getViewManager().getFileSystemView(this.metaClient);
    }

    public HoodieTimeline getCompletedCommitsTimeline() {
        return this.metaClient.getCommitsTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getCompletedCommitTimeline() {
        return this.metaClient.getCommitTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getPendingCommitTimeline() {
        return this.metaClient.getCommitsTimeline().filterPendingExcludingCompaction();
    }

    public HoodieTimeline getCompletedCleanTimeline() {
        return this.getActiveTimeline().getCleanerTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getCleanTimeline() {
        return this.getActiveTimeline().getCleanerTimeline();
    }

    public HoodieTimeline getRollbackTimeline() {
        return this.getActiveTimeline().getRollbackTimeline();
    }

    public HoodieTimeline getRestoreTimeline() {
        return this.getActiveTimeline().getRestoreTimeline();
    }

    public HoodieTimeline getCompletedSavepointTimeline() {
        return this.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
    }

    public Set<String> getSavepointTimestamps() {
        return this.getCompletedSavepointTimeline().getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
    }

    public HoodieActiveTimeline getActiveTimeline() {
        return this.metaClient.getActiveTimeline();
    }

    public HoodieIndex<?, ?> getIndex() {
        return this.index;
    }

    public HoodieStorageLayout getStorageLayout() {
        return this.storageLayout;
    }

    public abstract Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext var1, String var2, Option<Map<String, String>> var3);

    public abstract HoodieWriteMetadata<O> compact(HoodieEngineContext var1, String var2);

    public abstract Option<HoodieClusteringPlan> scheduleClustering(HoodieEngineContext var1, String var2, Option<Map<String, String>> var3);

    public abstract HoodieWriteMetadata<O> cluster(HoodieEngineContext var1, String var2);

    public abstract HoodieBootstrapWriteMetadata<O> bootstrap(HoodieEngineContext var1, Option<Map<String, String>> var2);

    public abstract void rollbackBootstrap(HoodieEngineContext var1, String var2);

    public abstract Option<HoodieCleanerPlan> scheduleCleaning(HoodieEngineContext var1, String var2, Option<Map<String, String>> var3);

    public abstract HoodieCleanMetadata clean(HoodieEngineContext var1, String var2, boolean var3);

    public abstract Option<HoodieRollbackPlan> scheduleRollback(HoodieEngineContext var1, String var2, HoodieInstant var3, boolean var4, boolean var5);

    public abstract HoodieRollbackMetadata rollback(HoodieEngineContext var1, String var2, HoodieInstant var3, boolean var4, boolean var5);

    public abstract Option<HoodieIndexPlan> scheduleIndexing(HoodieEngineContext var1, String var2, List<MetadataPartitionType> var3);

    public abstract Option<HoodieIndexCommitMetadata> index(HoodieEngineContext var1, String var2);

    public abstract HoodieSavepointMetadata savepoint(HoodieEngineContext var1, String var2, String var3, String var4);

    public abstract HoodieRestoreMetadata restore(HoodieEngineContext var1, String var2, String var3);

    public abstract Option<HoodieRestorePlan> scheduleRestore(HoodieEngineContext var1, String var2, String var3);

    public void rollbackInflightCompaction(HoodieInstant inflightInstant) {
        this.rollbackInflightCompaction(inflightInstant, s -> Option.empty());
    }

    public void rollbackInflightCompaction(HoodieInstant inflightInstant, Function<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInstantFunc) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("compaction"));
        this.rollbackInflightInstant(inflightInstant, getPendingRollbackInstantFunc);
    }

    public void rollbackInflightClustering(HoodieInstant inflightInstant, Function<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInstantFunc) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("replacecommit"));
        this.rollbackInflightInstant(inflightInstant, getPendingRollbackInstantFunc);
    }

    private void rollbackInflightInstant(HoodieInstant inflightInstant, Function<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInstantFunc) {
        String commitTime = getPendingRollbackInstantFunc.apply(inflightInstant.getTimestamp()).map(entry -> entry.getRollbackInstant().getTimestamp()).orElse(HoodieActiveTimeline.createNewInstantTime());
        this.scheduleRollback(this.context, commitTime, inflightInstant, false, this.config.shouldRollbackUsingMarkers());
        this.rollback(this.context, commitTime, inflightInstant, false, false);
        this.getActiveTimeline().revertInstantFromInflightToRequested(inflightInstant);
    }

    public void finalizeWrite(HoodieEngineContext context, String instantTs, List<HoodieWriteStat> stats) throws HoodieIOException {
        this.reconcileAgainstMarkers(context, instantTs, stats, this.config.getConsistencyGuardConfig().isConsistencyCheckEnabled());
    }

    private void deleteInvalidFilesByPartitions(HoodieEngineContext context, Map<String, List<Pair<String, String>>> invalidFilesByPartition) {
        context.setJobStatus(this.getClass().getSimpleName(), "Delete invalid files generated during the write operation: " + this.config.getTableName());
        context.map(new ArrayList<List<Pair<String, String>>>(invalidFilesByPartition.values()), partitionWithFileList -> {
            HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
            LOG.info((Object)("Deleting invalid data files=" + partitionWithFileList));
            if (partitionWithFileList.isEmpty()) {
                return true;
            }
            partitionWithFileList.stream().map(Pair::getValue).forEach(file -> {
                try {
                    fileSystem.delete(new Path(file), false);
                }
                catch (IOException e) {
                    throw new HoodieIOException(e.getMessage(), e);
                }
            });
            return true;
        }, this.config.getFinalizeWriteParallelism());
    }

    protected Set<String> getInvalidDataPaths(WriteMarkers markers) throws IOException {
        return markers.createdAndMergedDataPaths(this.context, this.config.getFinalizeWriteParallelism());
    }

    protected void reconcileAgainstMarkers(HoodieEngineContext context, String instantTs, List<HoodieWriteStat> stats, boolean consistencyCheckEnabled) throws HoodieIOException {
        try {
            String basePath = this.getMetaClient().getBasePath();
            WriteMarkers markers = WriteMarkersFactory.get(this.config.getMarkersType(), this, instantTs);
            if (!markers.doesMarkerDirExist()) {
                return;
            }
            Set<String> invalidDataPaths = this.getInvalidDataPaths(markers);
            Set validDataPaths = stats.stream().map(HoodieWriteStat::getPath).filter(p -> p.endsWith(this.getBaseFileExtension())).collect(Collectors.toSet());
            invalidDataPaths.removeAll(validDataPaths);
            if (!invalidDataPaths.isEmpty()) {
                LOG.info((Object)("Removing duplicate data files created due to task retries before committing. Paths=" + invalidDataPaths));
                Map<String, List<Pair<String, String>>> invalidPathsByPartition = invalidDataPaths.stream().map(dp -> Pair.of(new Path(basePath, dp).getParent().toString(), new Path(basePath, dp).toString())).collect(Collectors.groupingBy(Pair::getKey));
                if (consistencyCheckEnabled) {
                    this.waitForAllFiles(context, invalidPathsByPartition, ConsistencyGuard.FileVisibility.APPEAR);
                }
                context.setJobStatus(this.getClass().getSimpleName(), "Delete all partially written files: " + this.config.getTableName());
                this.deleteInvalidFilesByPartitions(context, invalidPathsByPartition);
                if (consistencyCheckEnabled) {
                    this.waitForAllFiles(context, invalidPathsByPartition, ConsistencyGuard.FileVisibility.DISAPPEAR);
                }
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    private void waitForAllFiles(HoodieEngineContext context, Map<String, List<Pair<String, String>>> groupByPartition, ConsistencyGuard.FileVisibility visibility) {
        context.setJobStatus(this.getClass().getSimpleName(), "Wait for all files to appear/disappear: " + this.config.getTableName());
        boolean checkPassed = context.map(new ArrayList<Map.Entry<String, List<Pair<String, String>>>>(groupByPartition.entrySet()), partitionWithFileList -> this.waitForCondition((String)partitionWithFileList.getKey(), ((List)partitionWithFileList.getValue()).stream(), visibility), this.config.getFinalizeWriteParallelism()).stream().allMatch(x -> x);
        if (!checkPassed) {
            throw new HoodieIOException("Consistency check failed to ensure all files " + (Object)((Object)visibility));
        }
    }

    private boolean waitForCondition(String partitionPath, Stream<Pair<String, String>> partitionFilePaths, ConsistencyGuard.FileVisibility visibility) {
        FileSystem fileSystem = this.metaClient.getRawFs();
        List<String> fileList = partitionFilePaths.map(Pair::getValue).collect(Collectors.toList());
        try {
            HoodieTable.getConsistencyGuard(fileSystem, this.config.getConsistencyGuardConfig()).waitTill(partitionPath, fileList, visibility);
        }
        catch (IOException | TimeoutException ioe) {
            LOG.error((Object)"Got exception while waiting for files to show up", (Throwable)ioe);
            return false;
        }
        return true;
    }

    public static ConsistencyGuard getConsistencyGuard(FileSystem fs, ConsistencyGuardConfig consistencyGuardConfig) throws IOException {
        try {
            return consistencyGuardConfig.shouldEnableOptimisticConsistencyGuard() ? new OptimisticConsistencyGuard(fs, consistencyGuardConfig) : new FailSafeConsistencyGuard(fs, consistencyGuardConfig);
        }
        catch (Throwable e) {
            throw new IOException("Could not load ConsistencyGuard ", e);
        }
    }

    public TaskContextSupplier getTaskContextSupplier() {
        return this.taskContextSupplier;
    }

    private void validateSchema() throws HoodieUpsertException, HoodieInsertException {
        boolean isValid;
        Schema tableSchema;
        Schema writerSchema;
        if (!this.config.getAvroSchemaValidate() || this.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().empty()) {
            return;
        }
        try {
            TableSchemaResolver schemaResolver = new TableSchemaResolver(this.getMetaClient());
            writerSchema = HoodieAvroUtils.createHoodieWriteSchema(this.config.getSchema());
            tableSchema = HoodieAvroUtils.createHoodieWriteSchema(schemaResolver.getTableAvroSchemaWithoutMetadataFields());
            isValid = TableSchemaResolver.isSchemaCompatible(tableSchema, writerSchema);
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema/check compatibility for base path " + this.metaClient.getBasePath(), e);
        }
        if (!isValid) {
            throw new HoodieException("Failed schema compatibility check for writerSchema :" + writerSchema + ", table schema :" + tableSchema + ", base path :" + this.metaClient.getBasePath());
        }
    }

    public void validateUpsertSchema() throws HoodieUpsertException {
        try {
            this.validateSchema();
        }
        catch (HoodieException e) {
            throw new HoodieUpsertException("Failed upsert schema compatibility check.", e);
        }
    }

    public void validateInsertSchema() throws HoodieInsertException {
        try {
            this.validateSchema();
        }
        catch (HoodieException e) {
            throw new HoodieInsertException("Failed insert schema compability check.", e);
        }
    }

    public HoodieFileFormat getBaseFileFormat() {
        return this.metaClient.getTableConfig().getBaseFileFormat();
    }

    public HoodieFileFormat getLogFileFormat() {
        return this.metaClient.getTableConfig().getLogFileFormat();
    }

    public Option<HoodieFileFormat> getPartitionMetafileFormat() {
        return this.metaClient.getTableConfig().getPartitionMetafileFormat();
    }

    public String getBaseFileExtension() {
        return this.getBaseFileFormat().getFileExtension();
    }

    public boolean requireSortedRecords() {
        return this.getBaseFileFormat() == HoodieFileFormat.HFILE;
    }

    public HoodieEngineContext getContext() {
        return this.context == null ? new HoodieLocalEngineContext(this.hadoopConfiguration.get()) : this.context;
    }

    public final Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstantTimestamp) {
        return this.getMetadataWriter(triggeringInstantTimestamp, Option.empty());
    }

    public abstract boolean isTableServiceAction(String var1);

    public <R extends SpecificRecordBase> Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstantTimestamp, Option<R> actionMetadata) {
        return Option.empty();
    }

    public void maybeDeleteMetadataTable() {
        if (this.shouldExecuteMetadataTableDeletion()) {
            try {
                LOG.info((Object)"Deleting metadata table because it is disabled in writer.");
                HoodieTableMetadataUtil.deleteMetadataTable(this.config.getBasePath(), this.context);
                this.clearMetadataTablePartitionsConfig(Option.empty(), true);
            }
            catch (HoodieMetadataException e) {
                throw new HoodieException("Failed to delete metadata table.", e);
            }
        }
    }

    public void deleteMetadataIndexIfNecessary() {
        Stream.of(MetadataPartitionType.values()).forEach(partitionType -> {
            if (this.shouldDeleteMetadataPartition((MetadataPartitionType)((Object)partitionType))) {
                try {
                    LOG.info((Object)("Deleting metadata partition because it is disabled in writer: " + partitionType.name()));
                    if (HoodieTableMetadataUtil.metadataPartitionExists(this.metaClient.getBasePath(), this.context, partitionType)) {
                        HoodieTableMetadataUtil.deleteMetadataPartition(this.metaClient.getBasePath(), this.context, partitionType);
                    }
                    this.clearMetadataTablePartitionsConfig(Option.of(partitionType), false);
                }
                catch (HoodieMetadataException e) {
                    throw new HoodieException("Failed to delete metadata partition: " + partitionType.name(), e);
                }
            }
        });
    }

    private boolean shouldDeleteMetadataPartition(MetadataPartitionType partitionType) {
        boolean metadataIndexDisabled;
        if (HoodieTableMetadata.isMetadataTable(this.metaClient.getBasePath()) || !this.config.isMetadataTableEnabled()) {
            return false;
        }
        switch (partitionType) {
            case COLUMN_STATS: {
                metadataIndexDisabled = !this.config.isMetadataColumnStatsIndexEnabled();
                break;
            }
            case BLOOM_FILTERS: {
                metadataIndexDisabled = !this.config.isMetadataBloomFilterIndexEnabled();
                break;
            }
            default: {
                LOG.debug((Object)("Not a valid metadata partition type: " + partitionType.name()));
                return false;
            }
        }
        return metadataIndexDisabled && this.metaClient.getTableConfig().getMetadataPartitions().contains(partitionType.getPartitionPath());
    }

    private boolean shouldExecuteMetadataTableDeletion() {
        return !HoodieTableMetadata.isMetadataTable(this.metaClient.getBasePath()) && !this.config.isMetadataTableEnabled() && !this.metaClient.getTableConfig().getMetadataPartitions().isEmpty();
    }

    private void clearMetadataTablePartitionsConfig(Option<MetadataPartitionType> partitionType, boolean clearAll) {
        Set<String> partitions = this.metaClient.getTableConfig().getMetadataPartitions();
        if (clearAll && partitions.size() > 0) {
            LOG.info((Object)"Clear hoodie.table.metadata.partitions in hoodie.properties");
            this.metaClient.getTableConfig().setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS.key(), "");
            HoodieTableConfig.update(this.metaClient.getFs(), new Path(this.metaClient.getMetaPath()), this.metaClient.getTableConfig().getProps());
        } else if (partitions.remove(partitionType.get().getPartitionPath())) {
            this.metaClient.getTableConfig().setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS.key(), String.join((CharSequence)",", partitions));
            HoodieTableConfig.update(this.metaClient.getFs(), new Path(this.metaClient.getMetaPath()), this.metaClient.getTableConfig().getProps());
        }
    }

    public HoodieTableMetadata getMetadataTable() {
        return this.metadata;
    }

    public Runnable getPreExecuteRunnable() {
        return Functions.noop();
    }
}

