/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.exception.HoodieSchemaProviderException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Option;

public class HiveSchemaProvider
extends SchemaProvider {
    private final Schema sourceSchema;
    private Schema targetSchema;

    public HiveSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        DataSourceUtils.checkRequiredProperties(props, Collections.singletonList("hoodie.deltastreamer.schemaprovider.source.schema.hive.table"));
        String sourceSchemaDatabaseName = props.getString("hoodie.deltastreamer.schemaprovider.source.schema.hive.database", "default");
        String sourceSchemaTableName = props.getString("hoodie.deltastreamer.schemaprovider.source.schema.hive.table");
        SparkSession spark = SparkSession.builder().config(jssc.getConf()).enableHiveSupport().getOrCreate();
        try {
            TableIdentifier sourceSchemaTable = new TableIdentifier(sourceSchemaTableName, Option.apply((Object)sourceSchemaDatabaseName));
            StructType sourceSchema = spark.sessionState().catalog().getTableMetadata(sourceSchemaTable).schema();
            this.sourceSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)sourceSchema, sourceSchemaTableName, "hoodie." + sourceSchemaDatabaseName);
        }
        catch (NoSuchDatabaseException | NoSuchTableException e) {
            throw new HoodieSchemaProviderException(String.format("Can't find Hive table: %s.%s", sourceSchemaDatabaseName, sourceSchemaTableName), e);
        }
        if (props.containsKey("hoodie.deltastreamer.schemaprovider.target.schema.hive.table")) {
            String targetSchemaDatabaseName = props.getString("hoodie.deltastreamer.schemaprovider.target.schema.hive.database", "default");
            String targetSchemaTableName = props.getString("hoodie.deltastreamer.schemaprovider.target.schema.hive.table");
            try {
                TableIdentifier targetSchemaTable = new TableIdentifier(targetSchemaTableName, Option.apply((Object)targetSchemaDatabaseName));
                StructType targetSchema = spark.sessionState().catalog().getTableMetadata(targetSchemaTable).schema();
                this.targetSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)targetSchema, targetSchemaTableName, "hoodie." + targetSchemaDatabaseName);
            }
            catch (NoSuchDatabaseException | NoSuchTableException e) {
                throw new HoodieSchemaProviderException(String.format("Can't find Hive table: %s.%s", targetSchemaDatabaseName, targetSchemaTableName), e);
            }
        }
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }

    public static class Config {
        private static final String SOURCE_SCHEMA_DATABASE_PROP = "hoodie.deltastreamer.schemaprovider.source.schema.hive.database";
        private static final String SOURCE_SCHEMA_TABLE_PROP = "hoodie.deltastreamer.schemaprovider.source.schema.hive.table";
        private static final String TARGET_SCHEMA_DATABASE_PROP = "hoodie.deltastreamer.schemaprovider.target.schema.hive.database";
        private static final String TARGET_SCHEMA_TABLE_PROP = "hoodie.deltastreamer.schemaprovider.target.schema.hive.table";
    }
}

