/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.postprocessor.add;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.utilities.exception.HoodieSchemaPostProcessException;
import org.apache.hudi.utilities.schema.SchemaPostProcessor;
import org.apache.hudi.utilities.schema.postprocessor.add.BaseSchemaPostProcessorConfig;
import org.apache.spark.api.java.JavaSparkContext;

public class AddPrimitiveColumnSchemaPostProcessor
extends SchemaPostProcessor {
    public AddPrimitiveColumnSchemaPostProcessor(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
    }

    @Override
    public Schema processSchema(Schema schema2) {
        String newColumnName = this.config.getString(BaseSchemaPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NAME_PROP.key());
        if (schema2.getField(newColumnName) != null) {
            throw new HoodieSchemaPostProcessException(String.format("Column %s already exist!", newColumnName));
        }
        List sourceFields = schema2.getFields();
        ArrayList<Schema.Field> targetFields = new ArrayList<Schema.Field>(sourceFields.size() + 1);
        for (Schema.Field sourceField : sourceFields) {
            targetFields.add(new Schema.Field(sourceField.name(), sourceField.schema(), sourceField.doc(), sourceField.defaultVal()));
        }
        targetFields.add(this.buildNewColumn());
        return Schema.createRecord((String)schema2.getName(), (String)schema2.getDoc(), (String)schema2.getNamespace(), (boolean)false, targetFields);
    }

    private Schema.Field buildNewColumn() {
        String columnName = this.config.getString(BaseSchemaPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NAME_PROP.key());
        String type = this.config.getString(BaseSchemaPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_TYPE_PROP.key()).toUpperCase(Locale.ROOT);
        String doc = this.config.getString(BaseSchemaPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_DOC_PROP.key(), null);
        Object defaultValue = this.config.getOrDefault((Object)BaseSchemaPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_DEFAULT_PROP.key(), (Object)null);
        boolean nullable = this.config.getBoolean(BaseSchemaPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NULLABLE_PROP.key(), BaseSchemaPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NULLABLE_PROP.defaultValue());
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(columnName));
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(type));
        ValidationUtils.checkArgument(!Schema.Type.NULL.getName().equals(type));
        Schema newSchema = this.createSchema(type, nullable);
        return new Schema.Field(columnName, newSchema, doc, defaultValue);
    }

    private Schema createSchema(String type, boolean nullable) {
        Schema schema2 = Schema.create((Schema.Type)Schema.Type.valueOf((String)type));
        if (nullable) {
            schema2 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema2});
        }
        return schema2;
    }
}

