/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ExportInstantsProcedure$;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001E\u0011q#\u0012=q_J$\u0018J\\:uC:$8\u000f\u0015:pG\u0016$WO]3\u000b\u0005\r!\u0011A\u00039s_\u000e,G-\u001e:fg*\u0011QAB\u0001\bG>lW.\u00198e\u0015\t9\u0001\"\u0001\u0003ik\u0012L'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0013-e\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0019r#\u0003\u0002\u0019\u0005\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\t\u00035ui\u0011a\u0007\u0006\u00039)\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0003\u0001\u0005\nI\u0001\u0001\r\u00111A\u0005\u0002\u0015\nAc]8si\nKh)[3mIB\u000b'/Y7fi\u0016\u0014X#\u0001\u0014\u0011\u0005M9\u0013B\u0001\u0015\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\u0013)\u0002\u0001\u0019!a\u0001\n\u0003Y\u0013\u0001G:peR\u0014\u0015PR5fY\u0012\u0004\u0016M]1nKR,'o\u0018\u0013fcR\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000fC\u00044S\u0005\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013\u0007\u0003\u00046\u0001\u0001\u0006KAJ\u0001\u0016g>\u0014HOQ=GS\u0016dG\rU1sC6,G/\u001a:!\u0011\u001d9\u0004A1A\u0005\u0002a\na\u0002Z3gCVdG/Q2uS>t7/F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u0015;sS:<\u0007B\u0002\"\u0001A\u0003%\u0011(A\beK\u001a\fW\u000f\u001c;BGRLwN\\:!\u0011\u001d!\u0005A1A\u0005\n\u0015\u000b!\u0002U!S\u00036+E+\u0012*T+\u00051\u0005cA\u0017HM%\u0011\u0001J\f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002$\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000b\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!\u0015\u0005\u0002\u000bQL\b/Z:\n\u0005M\u0003&AC*ueV\u001cG\u000fV=qK\"1Q\u000b\u0001Q\u0001\n9\u000bAbT+U!V#v\fV-Q\u000b\u0002BQa\u0016\u0001\u0005\u0002\u0015\u000b!\u0002]1sC6,G/\u001a:t\u0011\u0015I\u0006\u0001\"\u0001N\u0003)yW\u000f\u001e9viRK\b/\u001a\u0005\u00067\u0002!\t\u0005X\u0001\u0005G\u0006dG\u000e\u0006\u0002^[B\u0019aLZ5\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012\u0011\u0003\u0019a$o\\8u}%\tq&\u0003\u0002f]\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\r\u0019V-\u001d\u0006\u0003K:\u0002\"A[6\u000e\u0003!I!\u0001\u001c\u0005\u0003\u0007I{w\u000fC\u0003o5\u0002\u0007q.\u0001\u0003be\u001e\u001c\bCA\nq\u0013\t\t(AA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm\u001d\u0005\u0006g\u0002!I\u0001^\u0001\u0015G>\u0004\u00180\u0011:dQ&4X\rZ%ogR\fg\u000e^:\u0015\u0015UD\u0018\u0011AA\u0011\u0003W\ty\u0003\u0005\u0002.m&\u0011qO\f\u0002\u0004\u0013:$\b\"B=s\u0001\u0004Q\u0018\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\u0011\u0005mthBA\u0017}\u0013\tih&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001~T!! \u0018\t\u000f\u0005\r!\u000f1\u0001\u0002\u0006\u0005A1\u000f^1ukN,7\u000f\u0005\u0004\u0002\b\u00055\u0011\u0011C\u0007\u0003\u0003\u0013Q1!a\u0003>\u0003\u0011)H/\u001b7\n\t\u0005=\u0011\u0011\u0002\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0005\u0019\u001c(bAA\u000e\u0019\u00051\u0001.\u00193p_BLA!a\b\u0002\u0016\tQa)\u001b7f'R\fG/^:\t\u000f\u0005\r\"\u000f1\u0001\u0002&\u0005I\u0011m\u0019;j_:\u001cV\r\u001e\t\u0006\u0003\u000f\t9C_\u0005\u0005\u0003S\tIAA\u0002TKRDa!!\fs\u0001\u0004)\u0018!\u00027j[&$\bBBA\u0019e\u0002\u0007!0A\u0006m_\u000e\fGNR8mI\u0016\u0014\b&\u0002:\u00026\u0005\u0005\u0003#B\u0017\u00028\u0005m\u0012bAA\u001d]\t1A\u000f\u001b:poN\u00042AXA\u001f\u0013\r\ty\u0004\u001b\u0002\n\u000bb\u001cW\r\u001d;j_:\fdA\b>\u0002D\u0005=\u0014'C\u0012\u0002F\u00055\u0013QMA(+\u0011\t9%!\u0013\u0016\u0003i$q!a\u0013\u0011\u0005\u0004\t)FA\u0001U\u0013\u0011\ty%!\u0015\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\t\u0019FL\u0001\u0007i\"\u0014xn^:\u0012\t\u0005]\u0013Q\f\t\u0004[\u0005e\u0013bAA.]\t9aj\u001c;iS:<\u0007\u0003BA0\u0003Cr!!\f3\n\u0007\u0005\r\u0004NA\u0005UQJ|w/\u00192mKFJ1%a\u001a\u0002j\u0005-\u00141\u000b\b\u0004[\u0005%\u0014bAA*]E*!%\f\u0018\u0002n\t)1oY1mCF\u001aa%a\u000f\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v\u000592m\u001c9z\u001d>t\u0017I]2iSZ,G-\u00138ti\u0006tGo\u001d\u000b\nk\u0006]\u0014QRAP\u0003CC\u0001\"!\u001f\u0002r\u0001\u0007\u00111P\u0001\u000b[\u0016$\u0018m\u00117jK:$\b\u0003BA?\u0003\u0013k!!a \u000b\t\u0005\u0005\u00151Q\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0005\u0003\u000b\u000b9)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f1IA!a#\u0002\u0000\t)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\b\u0002CAH\u0003c\u0002\r!!%\u0002\u0011%t7\u000f^1oiN\u0004b!a\u0002\u0002\u000e\u0005M\u0005\u0003BAK\u00037k!!a&\u000b\t\u0005e\u0015qP\u0001\ti&lW\r\\5oK&!\u0011QTAL\u00055Aun\u001c3jK&s7\u000f^1oi\"9\u0011QFA9\u0001\u0004)\bbBA\u0019\u0003c\u0002\rA\u001f\u0015\u0007\u0003c\n)$!*2\ryQ\u0018qUAWc%\u0019\u0013QIA'\u0003S\u000by%M\u0005$\u0003O\nI'a+\u0002TE*!%\f\u0018\u0002nE\u001aa%a\u000f\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\u0006YqO]5uKR{g)\u001b7f)\u001da\u0013QWA_\u0003\u0003D\u0001\"a\u0006\u00020\u0002\u0007\u0011q\u0017\t\u0005\u0003'\tI,\u0003\u0003\u0002<\u0006U!A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"9\u0011qXAX\u0001\u0004Q\u0018\u0001\u00029bi\"D\u0001\"a1\u00020\u0002\u0007\u0011QY\u0001\u0005I\u0006$\u0018\r\u0005\u0003.\u000f\u0006\u001d\u0007cA\u0017\u0002J&\u0019\u00111\u001a\u0018\u0003\t\tKH/\u001a\u0015\u0007\u0003_\u000b)$a42\ryQ\u0018\u0011[Alc%\u0019\u0013QIA'\u0003'\fy%M\u0005$\u0003O\nI'!6\u0002TE*!%\f\u0018\u0002nE\u001aa%a\u000f\t\u000f\u0005m\u0007\u0001\"\u0011\u0002^\u0006)!-^5mIV\t!eB\u0004\u0002b\nA\t!a9\u0002/\u0015C\bo\u001c:u\u0013:\u001cH/\u00198ugB\u0013xnY3ekJ,\u0007cA\n\u0002f\u001a1\u0011A\u0001E\u0001\u0003O\u001cB!!:\u0002jB\u0019Q&a;\n\u0007\u00055hF\u0001\u0004B]f\u0014VM\u001a\u0005\bA\u0005\u0015H\u0011AAy)\t\t\u0019\u000fC\u0005\u0002v\u0006\u0015(\u0019!C\u0001q\u0005!a*Q'F\u0011!\tI0!:!\u0002\u0013I\u0014!\u0002(B\u001b\u0016\u0003\u0003\u0002CA\u007f\u0003K$\t!a@\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011!\u0011\u0001\t\u0006\u0005\u0007\u0011IAF\u0007\u0003\u0005\u000bQAAa\u0002\u0002\n\u0005Aa-\u001e8di&|g.\u0003\u0003\u0003\f\t\u0015!\u0001C*vaBd\u0017.\u001a:")
public class ExportInstantsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private ProcedureParameter sortByFieldParameter;
    private final String defaultActions;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ExportInstantsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ExportInstantsProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public ProcedureParameter sortByFieldParameter() {
        return this.sortByFieldParameter;
    }

    public void sortByFieldParameter_$eq(ProcedureParameter x$1) {
        this.sortByFieldParameter = x$1;
    }

    public String defaultActions() {
        return this.defaultActions;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Row> call(ProcedureArgs args) {
        void var3_3;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        String localFolder = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get());
        String actions = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get());
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        Path archivePath = new Path(new StringBuilder().append((Object)basePath).append((Object)"/.hoodie/.commits_.archive*").toString());
        java.util.Set actionSet = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])actions.split(",")))).asJava();
        int numExports = limit == -1 ? Integer.MAX_VALUE : limit;
        int numCopied = 0;
        if (new File(localFolder).isDirectory()) {
            List nonArchivedInstants = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().iterator()).asScala()).filter((Function1)new Serializable(this, actionSet){
                public static final long serialVersionUID = 0L;
                private final java.util.Set actionSet$1;

                public final boolean apply(HoodieInstant i) {
                    return this.actionSet$1.contains(i.getAction());
                }
                {
                    this.actionSet$1 = actionSet$1;
                }
            }).toList()).asJava();
            FileStatus[] statuses = FSUtils.getFs(basePath, this.jsc().hadoopConfiguration()).globStatus(archivePath);
            List archivedStatuses = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])statuses)).sortWith((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus f1, FileStatus f2) {
                    return (int)(f1.getModificationTime() - f2.getModificationTime()) > 0;
                }
            })).asJava();
            if (desc) {
                Collections.reverse(nonArchivedInstants);
                numCopied = this.copyNonArchivedInstants(metaClient, nonArchivedInstants, numExports, localFolder);
                if (numCopied < numExports) {
                    Collections.reverse(archivedStatuses);
                    numCopied += this.copyArchivedInstants(basePath, archivedStatuses, actionSet, numExports - numCopied, localFolder);
                }
            } else {
                numCopied = this.copyArchivedInstants(basePath, archivedStatuses, actionSet, numExports, localFolder);
                if (numCopied < numExports) {
                    numCopied += this.copyNonArchivedInstants(metaClient, nonArchivedInstants, numExports - numCopied, localFolder);
                }
            }
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)"Exported ").append((Object)BoxesRunTime.boxToInteger((int)numCopied)).append((Object)" Instants to ").append((Object)localFolder).toString()}))}));
        }
        throw new HoodieException(new StringBuilder().append((Object)var3_3).append((Object)" is not a valid local directory").toString());
    }

    private int copyArchivedInstants(String basePath, List<FileStatus> statuses, java.util.Set<String> actionSet, int limit, String localFolder) throws Exception {
        IntRef copyCount = IntRef.create((int)0);
        FileSystem fileSystem = FSUtils.getFs(basePath, this.jsc().hadoopConfiguration());
        JavaConversions$.MODULE$.asScalaBuffer(statuses).foreach((Function1)new Serializable(this, actionSet, limit, localFolder, copyCount, fileSystem){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExportInstantsProcedure $outer;
            private final java.util.Set actionSet$2;
            private final int limit$1;
            private final String localFolder$2;
            private final IntRef copyCount$1;
            private final FileSystem fileSystem$1;

            public final void apply(FileStatus fs) {
                HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(this.fileSystem$1, new HoodieLogFile(fs.getPath()), HoodieArchivedMetaEntry.getClassSchema());
                block3: while (true) {
                    ClosableIterator<IndexedRecord> recordItr;
                    if (reader.hasNext() && this.copyCount$1.elem < this.limit$1) {
                        block19: {
                            HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                            recordItr = blk.getRecordIterator();
                            do {
                                SpecificRecordBase specificRecordBase;
                                if (!recordItr.hasNext()) continue block3;
                                IndexedRecord ir = (IndexedRecord)recordItr.next();
                                HoodieArchivedMetaEntry archiveEntryRecord = (HoodieArchivedMetaEntry)((Object)SpecificData.get().deepCopy(HoodieArchivedMetaEntry.SCHEMA$, (Object)ir));
                                String action = archiveEntryRecord.get("actionType").toString();
                                if (!this.actionSet$2.contains(action)) break block19;
                                String string = action;
                                if ("clean".equals(string)) {
                                    specificRecordBase = archiveEntryRecord.getHoodieCleanMetadata();
                                } else if ("commit".equals(string)) {
                                    specificRecordBase = archiveEntryRecord.getHoodieCommitMetadata();
                                } else if ("deltacommit".equals(string)) {
                                    specificRecordBase = archiveEntryRecord.getHoodieCommitMetadata();
                                } else if ("rollback".equals(string)) {
                                    specificRecordBase = archiveEntryRecord.getHoodieRollbackMetadata();
                                } else if ("savepoint".equals(string)) {
                                    specificRecordBase = archiveEntryRecord.getHoodieSavePointMetadata();
                                } else if ("compaction".equals(string)) {
                                    specificRecordBase = archiveEntryRecord.getHoodieCompactionMetadata();
                                } else {
                                    this.$outer.logInfo((Function0<String>)new Serializable(this, action){
                                        public static final long serialVersionUID = 0L;
                                        private final String action$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"Unknown type of action ").append((Object)this.action$1).toString();
                                        }
                                        {
                                            this.action$1 = action$1;
                                        }
                                    });
                                    specificRecordBase = null;
                                }
                                HoodieCleanMetadata metadata = specificRecordBase;
                                String instantTime = archiveEntryRecord.get("commitTime").toString();
                                String outPath = new StringBuilder().append((Object)this.localFolder$2).append((Object)"/").append((Object)instantTime).append((Object)".").append((Object)action).toString();
                                if (metadata != null) {
                                    this.$outer.org$apache$spark$sql$hudi$command$procedures$ExportInstantsProcedure$$writeToFile(this.fileSystem$1, outPath, HoodieAvroUtils.avroToJson((GenericRecord)metadata, true));
                                }
                                ++this.copyCount$1.elem;
                            } while (this.copyCount$1.elem != this.limit$1);
                            throw Breaks$.MODULE$.break();
                        }
                        throw Breaks$.MODULE$.break();
                    }
                    reader.close();
                    return;
                    finally {
                        if (recordItr == null) continue;
                        recordItr.close();
                        continue;
                    }
                    break;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.actionSet$2 = actionSet$2;
                this.limit$1 = limit$1;
                this.localFolder$2 = localFolder$2;
                this.copyCount$1 = copyCount$1;
                this.fileSystem$1 = fileSystem$1;
            }
        });
        return copyCount.elem;
    }

    private int copyNonArchivedInstants(HoodieTableMetaClient metaClient, List<HoodieInstant> instants, int limit, String localFolder) throws Exception {
        IntRef copyCount = IntRef.create((int)0);
        if (JavaConversions$.MODULE$.asScalaBuffer(instants).nonEmpty()) {
            HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
            FileSystem fileSystem = FSUtils.getFs(metaClient.getBasePath(), this.jsc().hadoopConfiguration());
            JavaConversions$.MODULE$.asScalaBuffer(instants).foreach((Function1)new Serializable(this, localFolder, copyCount, timeline, fileSystem){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExportInstantsProcedure $outer;
                private final String localFolder$1;
                private final IntRef copyCount$2;
                private final HoodieActiveTimeline timeline$1;
                private final FileSystem fileSystem$2;

                public final void apply(HoodieInstant instant) {
                    byte[] byArray;
                    String localPath = new StringBuilder().append((Object)this.localFolder$1).append((Object)"/").append((Object)instant.getFileName()).toString();
                    String string = instant.getAction();
                    if ("clean".equals(string)) {
                        HoodieCleanMetadata metadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata(this.timeline$1.getInstantDetails(instant).get());
                        byArray = HoodieAvroUtils.avroToJson((GenericRecord)metadata, true);
                    } else if ("deltacommit".equals(string)) {
                        byArray = this.timeline$1.getInstantDetails(instant).get();
                    } else if ("commit".equals(string)) {
                        byArray = this.timeline$1.getInstantDetails(instant).get();
                    } else if ("compaction".equals(string)) {
                        byArray = this.timeline$1.getInstantDetails(instant).get();
                    } else if ("rollback".equals(string)) {
                        HoodieRollbackMetadata metadata = TimelineMetadataUtils.deserializeHoodieRollbackMetadata(this.timeline$1.getInstantDetails(instant).get());
                        byArray = HoodieAvroUtils.avroToJson((GenericRecord)metadata, true);
                    } else if ("savepoint".equals(string)) {
                        HoodieSavepointMetadata metadata = TimelineMetadataUtils.deserializeHoodieSavepointMetadata(this.timeline$1.getInstantDetails(instant).get());
                        byArray = HoodieAvroUtils.avroToJson((GenericRecord)metadata, true);
                    } else {
                        byArray = null;
                    }
                    byte[] data = byArray;
                    if (data != null) {
                        this.$outer.org$apache$spark$sql$hudi$command$procedures$ExportInstantsProcedure$$writeToFile(this.fileSystem$2, localPath, data);
                        ++this.copyCount$2.elem;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.localFolder$1 = localFolder$1;
                    this.copyCount$2 = copyCount$2;
                    this.timeline$1 = timeline$1;
                    this.fileSystem$2 = fileSystem$2;
                }
            });
        }
        return copyCount.elem;
    }

    public void org$apache$spark$sql$hudi$command$procedures$ExportInstantsProcedure$$writeToFile(FileSystem fs, String path, byte[] data) throws Exception {
        FSDataOutputStream out = fs.create(new Path(path));
        out.write(data);
        out.flush();
        out.close();
    }

    @Override
    public ExportInstantsProcedure build() {
        return new ExportInstantsProcedure();
    }

    public ExportInstantsProcedure() {
        Logging.class.$init$((Logging)this);
        this.defaultActions = "clean,commit,deltacommit,rollback,savepoint,restore";
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "local_folder", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)-1)), ProcedureParameter$.MODULE$.optional(3, "actions", DataTypes.StringType, this.defaultActions()), ProcedureParameter$.MODULE$.optional(4, "desc", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("export_detail", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

