/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.avro.AvroRuntimeException;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RepairCorruptedCleanFilesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001E\u0011!EU3qC&\u00148i\u001c:skB$X\rZ\"mK\u0006tg)\u001b7fgB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!CF\r\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\u0011%tG/\u001a:oC2L!AH\u000e\u0003\u000f1{wmZ5oO\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003'\u0001Aq\u0001\n\u0001C\u0002\u0013%Q%\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012A\n\t\u0004O)bS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Mi\u0013B\u0001\u0018\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\rA\u0002\u0001\u0015!\u0003'\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\t\u000fI\u0002!\u0019!C\u0005g\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\t\u0003\u0015!\u0018\u0010]3t\u0013\tIdG\u0001\u0006TiJ,8\r\u001e+za\u0016Daa\u000f\u0001!\u0002\u0013!\u0014\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0003\"B\u001f\u0001\t\u0003)\u0013A\u00039be\u0006lW\r^3sg\")q\b\u0001C\u0001g\u0005Qq.\u001e;qkR$\u0016\u0010]3\t\u000b\u0005\u0003A\u0011\t\"\u0002\t\r\fG\u000e\u001c\u000b\u0003\u0007N\u00032\u0001\u0012'P\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I!\u00051AH]8pizJ\u0011!K\u0005\u0003\u0017\"\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-C\u0003C\u0001)R\u001b\u0005A\u0011B\u0001*\t\u0005\r\u0011vn\u001e\u0005\u0006)\u0002\u0003\r!V\u0001\u0005CJ<7\u000f\u0005\u0002\u0014-&\u0011qK\u0001\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\t\u000be\u0003A\u0011\t.\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003m\u0003\"a\u0005/\n\u0005u\u0013!!\u0003)s_\u000e,G-\u001e:f\u000f\u0015y&\u0001#\u0001a\u0003\t\u0012V\r]1je\u000e{'O];qi\u0016$7\t\\3b]\u001aKG.Z:Qe>\u001cW\rZ;sKB\u00111#\u0019\u0004\u0006\u0003\tA\tAY\n\u0003C\u000e\u0004\"a\n3\n\u0005\u0015D#AB!osJ+g\rC\u0003!C\u0012\u0005q\rF\u0001a\u0011\u001dI\u0017M1A\u0005\u0002)\fAAT!N\u000bV\t1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006!A.\u00198h\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\rM#(/\u001b8h\u0011\u0019!\u0018\r)A\u0005W\u0006)a*Q'FA!)a/\u0019C\u0001o\u00069!-^5mI\u0016\u0014X#\u0001=\u0011\u0007eth#D\u0001{\u0015\tYH0\u0001\u0005gk:\u001cG/[8o\u0015\tix.\u0001\u0003vi&d\u0017BA@{\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class RepairCorruptedCleanFilesProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RepairCorruptedCleanFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RepairCorruptedCleanFilesProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String tablePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(tablePath).build();
        HoodieTimeline cleanerTimeline = metaClient.getActiveTimeline().getCleanerTimeline();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Inspecting pending clean metadata in timeline for corrupted files";
            }
        });
        BooleanRef result = BooleanRef.create((boolean)true);
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(cleanerTimeline.filterInflightsAndRequested().getInstants().iterator()).asScala()).foreach((Function1)new Serializable(this, metaClient, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepairCorruptedCleanFilesProcedure $outer;
            private final HoodieTableMetaClient metaClient$1;
            private final BooleanRef result$1;

            public final Object apply(HoodieInstant instant) {
                HoodieCleanerPlan hoodieCleanerPlan;
                try {
                    hoodieCleanerPlan = CleanerUtils.getCleanerPlan(this.metaClient$1, instant);
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().contains("Not an Avro data file")) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, instant){
                            public static final long serialVersionUID = 0L;
                            private final HoodieInstant instant$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Corruption found. Trying to remove corrupted clean instant file: ").append((Object)this.instant$1).toString();
                            }
                            {
                                this.instant$1 = instant$1;
                            }
                        });
                        HoodieActiveTimeline.deleteInstantFile(this.metaClient$1.getFs(), this.metaClient$1.getMetaPath(), instant);
                        hoodieCleanerPlan = BoxedUnit.UNIT;
                    }
                    this.result$1.elem = false;
                    throw new HoodieIOException(iOException.getMessage(), iOException);
                }
                catch (AvroRuntimeException avroRuntimeException) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, instant){
                        public static final long serialVersionUID = 0L;
                        private final HoodieInstant instant$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Corruption found. Trying to remove corrupted clean instant file: ").append((Object)this.instant$1).toString();
                        }
                        {
                            this.instant$1 = instant$1;
                        }
                    });
                    HoodieActiveTimeline.deleteInstantFile(this.metaClient$1.getFs(), this.metaClient$1.getMetaPath(), instant);
                    hoodieCleanerPlan = BoxedUnit.UNIT;
                }
                return hoodieCleanerPlan;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metaClient$1 = metaClient$1;
                this.result$1 = result$1;
            }
        });
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result.elem)}))}));
    }

    @Override
    public Procedure build() {
        return new RepairCorruptedCleanFilesProcedure();
    }

    public RepairCorruptedCleanFilesProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

