/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RepairMigratePartitionMetaProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001E\u00111EU3qC&\u0014X*[4sCR,\u0007+\u0019:uSRLwN\\'fi\u0006\u0004&o\\2fIV\u0014XM\u0003\u0002\u0004\t\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005\u00151\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\f\u001a!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\bC\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u000b\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001eDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005M\u0001\u0001b\u0002\u0013\u0001\u0005\u0004%I!J\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#\u0001\u0014\u0011\u0007\u001dRC&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0015\t%O]1z!\t\u0019R&\u0003\u0002/\u0005\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0011\u0019\u0001\u0004\u0001)A\u0005M\u0005Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0011\u001d\u0011\u0004A1A\u0005\nM\n1bT+U!V#v\fV-Q\u000bV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\u0011\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BB\u001e\u0001A\u0003%A'\u0001\u0007P+R\u0003V\u000bV0U3B+\u0005\u0005C\u0003>\u0001\u0011\u0005Q%\u0001\u0006qCJ\fW.\u001a;feNDQa\u0010\u0001\u0005\u0002M\n!b\\;uaV$H+\u001f9f\u0011\u0015\t\u0005\u0001\"\u0011C\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005\r\u001b\u0006c\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011B\ta\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005-C\u0013a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tY\u0005\u0006\u0005\u0002Q#6\t\u0001\"\u0003\u0002S\u0011\t\u0019!k\\<\t\u000bQ\u0003\u0005\u0019A+\u0002\t\u0005\u0014xm\u001d\t\u0003'YK!a\u0016\u0002\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0011\u0015I\u0006\u0001\"\u0011[\u0003\u0015\u0011W/\u001b7e+\u0005Y\u0006CA\n]\u0013\ti&AA\u0005Qe>\u001cW\rZ;sK\u001e)qL\u0001E\u0001A\u0006\u0019#+\u001a9bSJl\u0015n\u001a:bi\u0016\u0004\u0016M\u001d;ji&|g.T3uCB\u0013xnY3ekJ,\u0007CA\nb\r\u0015\t!\u0001#\u0001c'\t\t7\r\u0005\u0002(I&\u0011Q\r\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000b\u0001\nG\u0011A4\u0015\u0003\u0001Dq![1C\u0002\u0013\u0005!.\u0001\u0003O\u00036+U#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00027b]\u001eT\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n11\u000b\u001e:j]\u001eDa\u0001^1!\u0002\u0013Y\u0017!\u0002(B\u001b\u0016\u0003\u0003\"\u0002<b\t\u00039\u0018a\u00022vS2$WM]\u000b\u0002qB\u0019\u0011P \f\u000e\u0003iT!a\u001f?\u0002\u0011\u0019,hn\u0019;j_:T!!`8\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fj\u0014\u0001bU;qa2LWM\u001d")
public class RepairMigratePartitionMetaProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RepairMigratePartitionMetaProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RepairMigratePartitionMetaProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        boolean dryRun = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String tablePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(tablePath).build();
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(metaClient.getHadoopConf());
        List<String> partitionPaths = FSUtils.getAllPartitionPaths(engineContext, tablePath, false, false);
        Path basePath = new Path(tablePath);
        ArrayList rows = new ArrayList(partitionPaths.size());
        JavaConversions$.MODULE$.asScalaBuffer(partitionPaths).foreach((Function1)new Serializable(this, dryRun, tablePath, metaClient, basePath, rows){
            public static final long serialVersionUID = 0L;
            private final boolean dryRun$1;
            private final String tablePath$1;
            public final HoodieTableMetaClient metaClient$1;
            private final Path basePath$1;
            private final ArrayList rows$1;

            public final boolean apply(String partitionPath) {
                String action;
                Path partition = FSUtils.getPartitionPath(this.tablePath$1, partitionPath);
                org.apache.hudi.common.util.Option<Path> textFormatFile = HoodiePartitionMetadata.textFormatMetaPathIfExists(this.metaClient$1.getFs(), partition);
                org.apache.hudi.common.util.Option<Path> baseFormatFile = HoodiePartitionMetadata.baseFormatMetaPathIfExists(this.metaClient$1.getFs(), partition);
                String latestCommit = this.metaClient$1.getActiveTimeline().getCommitTimeline().lastInstant().get().getTimestamp();
                String string = action = textFormatFile.isPresent() ? "MIGRATE" : "NONE";
                if (!this.dryRun$1) {
                    if (!baseFormatFile.isPresent()) {
                        HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.metaClient$1.getFs(), latestCommit, this.basePath$1, partition, org.apache.hudi.common.util.Option.of(this.metaClient$1.getTableConfig().getBaseFileFormat()));
                        partitionMetadata.trySave(0);
                    }
                    textFormatFile.ifPresent(new Consumer<Path>(this){
                        private final /* synthetic */ $anonfun$call$1 $outer;

                        public void accept(Path p) {
                            try {
                                this.$outer.metaClient$1.getFs().delete(p, false);
                                return;
                            }
                            catch (IOException iOException) {
                                throw new HoodieIOException(iOException.getMessage(), iOException);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    action = "MIGRATED";
                }
                return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPath, String.valueOf(textFormatFile.isPresent()), String.valueOf(baseFormatFile.isPresent()), action})));
            }
            {
                this.dryRun$1 = dryRun$1;
                this.tablePath$1 = tablePath$1;
                this.metaClient$1 = metaClient$1;
                this.basePath$1 = basePath$1;
                this.rows$1 = rows$1;
            }
        });
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key(), "true");
        HoodieTableConfig.update(metaClient.getFs(), new Path(metaClient.getMetaPath()), props);
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    @Override
    public Procedure build() {
        return new RepairMigratePartitionMetaProcedure();
    }

    public RepairMigratePartitionMetaProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "dry_run", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("text_metafile_present", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_metafile_present", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

