/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RollbackToSavepointProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001E\u0011ADU8mY\n\f7m\u001b+p'\u00064X\r]8j]R\u0004&o\\2fIV\u0014XM\u0003\u0002\u0004\t\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005\u00151\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\f\u001a!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\bC\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u000b\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001eDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005M\u0001\u0001b\u0002\u0013\u0001\u0005\u0004%I!J\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#\u0001\u0014\u0011\u0007\u001dRC&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0015\t%O]1z!\t\u0019R&\u0003\u0002/\u0005\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0011\u0019\u0001\u0004\u0001)A\u0005M\u0005Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0011\u001d\u0011\u0004A1A\u0005\nM\n1bT+U!V#v\fV-Q\u000bV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\u0011\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BB\u001e\u0001A\u0003%A'\u0001\u0007P+R\u0003V\u000bV0U3B+\u0005\u0005C\u0003>\u0001\u0011\u0005Q%\u0001\u0006qCJ\fW.\u001a;feNDQa\u0010\u0001\u0005\u0002M\n!b\\;uaV$H+\u001f9f\u0011\u0015\t\u0005\u0001\"\u0011C\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005\r\u001b\u0006c\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011B\ta\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005-C\u0013a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tY\u0005\u0006\u0005\u0002Q#6\t\u0001\"\u0003\u0002S\u0011\t\u0019!k\\<\t\u000bQ\u0003\u0005\u0019A+\u0002\t\u0005\u0014xm\u001d\t\u0003'YK!a\u0016\u0002\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0011\u0015I\u0006\u0001\"\u0011[\u0003\u0015\u0011W/\u001b7e+\u0005Y\u0006CA\n]\u0013\ti&AA\u0005Qe>\u001cW\rZ;sK\u001e)qL\u0001E\u0001A\u0006a\"k\u001c7mE\u0006\u001c7\u000eV8TCZ,\u0007o\\5oiB\u0013xnY3ekJ,\u0007CA\nb\r\u0015\t!\u0001#\u0001c'\t\t7\r\u0005\u0002(I&\u0011Q\r\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000b\u0001\nG\u0011A4\u0015\u0003\u0001Dq![1C\u0002\u0013\u0005!.\u0001\u0003O\u00036+U#A6\u0011\u00051|gBA\u0014n\u0013\tq\u0007&\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018)\u0011\u0019\u0019\u0018\r)A\u0005W\u0006)a*Q'FA!)Q/\u0019C\u0001m\u00069!-^5mI\u0016\u0014X#A<\u0011\u0007a|h#D\u0001z\u0015\tQ80\u0001\u0005gk:\u001cG/[8o\u0015\taX0\u0001\u0003vi&d'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003I(\u0001C*vaBd\u0017.\u001a:")
public class RollbackToSavepointProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RollbackToSavepointProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RollbackToSavepointProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieTimeline completedInstants = metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
        if (completedInstants.empty()) {
            throw new HoodieException("There are no completed savepoint to run delete");
        }
        HoodieInstant savePoint = new HoodieInstant(false, "savepoint", instantTime);
        if (!completedInstants.containsInstant(savePoint)) throw new HoodieException(new StringBuilder().append((Object)"Commit ").append((Object)instantTime).append((Object)" not found in Commits ").append((Object)completedInstants).toString());
        boolean result = false;
        try (SparkRDDWriteClient<HoodieRecordPayload<?>> client = this.createHoodieClient(this.jsc(), basePath);){
            client.restoreToSavepoint(instantTime);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The commit $instantTime rolled back.";
                }
            });
            result = true;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
        }
    }

    @Override
    public Procedure build() {
        return new RollbackToSavepointProcedure();
    }

    public RollbackToSavepointProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "instant_time", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("rollback_savepoint_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

