/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.StringUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowArchivedCommitsProcedure$;
import org.apache.spark.sql.hudi.command.procedures.ShowArchivedCommitsProcedure$$anonfun$getCommitsWithMetadata$1$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001E\u0011Ad\u00155po\u0006\u00138\r[5wK\u0012\u001cu.\\7jiN\u0004&o\\2fIV\u0014XM\u0003\u0002\u0004\t\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005\u00151\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\f\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0015S:\u001cG.\u001e3f\u000bb$(/Y'fi\u0006$\u0017\r^1\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u000f\t{w\u000e\\3b]\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005M\u0001\u0001\"\u0002\u000e\"\u0001\u0004Y\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#A\u0015\u0011\u0007qQC&\u0003\u0002,;\t)\u0011I\u001d:bsB\u00111#L\u0005\u0003]\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1\u0001\u0007\u0001Q\u0001\n%\n1\u0002U!S\u00036+E+\u0012*TA!9!\u0007\u0001b\u0001\n\u0013\u0019\u0014aC(V)B+Fk\u0018+Z!\u0016+\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o!\tQ\u0001^=qKNL!!\u000f\u001c\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004<\u0001\u0001\u0006I\u0001N\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\b{\u0001\u0011\r\u0011\"\u00034\u0003QiU\tV!E\u0003R\u000bulT+U!V#v\fV-Q\u000b\"1q\b\u0001Q\u0001\nQ\nQ#T#U\u0003\u0012\u000bE+Q0P+R\u0003V\u000bV0U3B+\u0005\u0005C\u0003B\u0001\u0011\u0005\u0001&\u0001\u0006qCJ\fW.\u001a;feNDQa\u0011\u0001\u0005\u0002M\n!b\\;uaV$H+\u001f9f\u0011\u0015)\u0005\u0001\"\u0011G\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005\u001d;\u0006c\u0001%Q':\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019B\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005=k\u0012a\u00029bG.\fw-Z\u0005\u0003#J\u00131aU3r\u0015\tyU\u0004\u0005\u0002U+6\t\u0001\"\u0003\u0002W\u0011\t\u0019!k\\<\t\u000ba#\u0005\u0019A-\u0002\t\u0005\u0014xm\u001d\t\u0003'iK!a\u0017\u0002\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0011\u0015i\u0006\u0001\"\u0011_\u0003\u0015\u0011W/\u001b7e+\u0005y\u0006CA\na\u0013\t\t'AA\u0005Qe>\u001cW\rZ;sK\")1\r\u0001C\u0005I\u00061r-\u001a;D_6l\u0017\u000e^:XSRDW*\u001a;bI\u0006$\u0018\rF\u0002HKFDQA\u001a2A\u0002\u001d\f\u0001\u0002^5nK2Lg.\u001a\t\u0003Q>l\u0011!\u001b\u0006\u0003M*T!a\u001b7\u0002\u000bQ\f'\r\\3\u000b\u00055t\u0017AB2p[6|gN\u0003\u0002\b\u0019%\u0011\u0001/\u001b\u0002\u0016\u0011>|G-[3EK\u001a\fW\u000f\u001c;US6,G.\u001b8f\u0011\u0015\u0011(\r1\u0001t\u0003\u0015a\u0017.\\5u!\taB/\u0003\u0002v;\t\u0019\u0011J\u001c;\t\u000b]\u0004A\u0011\u0002=\u0002\u001d\u001d,GoU8si\u000e{W.\\5ugR\u0019\u00110!\u0005\u0011\u000bqQH0!\u0003\n\u0005ml\"A\u0002+va2,'\u0007\u0005\u0003~\u0003\u000b\u0019V\"\u0001@\u000b\u0007}\f\t!\u0001\u0003vi&d'BAA\u0002\u0003\u0011Q\u0017M^1\n\u0007\u0005\u001daPA\u0005BeJ\f\u0017\u0010T5tiB)Q0!\u0002\u0002\fA\u0019\u0001.!\u0004\n\u0007\u0005=\u0011NA\u0007I_>$\u0017.Z%ogR\fg\u000e\u001e\u0005\u0006MZ\u0004\ra\u001a\u0005\b\u0003+\u0001A\u0011AA\f\u0003)9W\r^\"p[6LGo\u001d\u000b\u0006\u000f\u0006e\u00111\u0004\u0005\u0007M\u0006M\u0001\u0019A4\t\rI\f\u0019\u00021\u0001t\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\tabZ3u)&lW\rR1zg\u0006;w\u000e\u0006\u0003\u0002$\u0005E\u0002\u0003BA\u0013\u0003Wq1\u0001HA\u0014\u0013\r\tI#H\u0001\u0007!J,G-\u001a4\n\t\u00055\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%R\u0004C\u0004\u00024\u0005u\u0001\u0019A:\u0002\u00199,XNY3s\u001f\u001a$\u0015-_:\b\u000f\u0005]\"\u0001#\u0001\u0002:\u0005a2\u000b[8x\u0003J\u001c\u0007.\u001b<fI\u000e{W.\\5ugB\u0013xnY3ekJ,\u0007cA\n\u0002<\u00191\u0011A\u0001E\u0001\u0003{\u0019B!a\u000f\u0002@A\u0019A$!\u0011\n\u0007\u0005\rSD\u0001\u0004B]f\u0014VM\u001a\u0005\bE\u0005mB\u0011AA$)\t\tI\u0004\u0003\u0006\u0002L\u0005m\"\u0019!C\u0001\u0003\u001b\nAAT!N\u000bV\u0011\u0011q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)!\u0011QKA\u0001\u0003\u0011a\u0017M\\4\n\t\u00055\u00121\u000b\u0005\n\u00037\nY\u0004)A\u0005\u0003\u001f\nQAT!N\u000b\u0002B\u0001\"a\u0018\u0002<\u0011\u0005\u0011\u0011M\u0001\bEVLG\u000eZ3s+\t\t\u0019\u0007E\u0003\u0002f\u0005-d#\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e@\u0002\u0011\u0019,hn\u0019;j_:LA!!\u001c\u0002h\tA1+\u001e9qY&,'\u000f")
public class ShowArchivedCommitsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean includeExtraMetadata;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private final StructType METADATA_OUTPUT_TYPE;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowArchivedCommitsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowArchivedCommitsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    private StructType METADATA_OUTPUT_TYPE() {
        return this.METADATA_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.includeExtraMetadata ? this.METADATA_OUTPUT_TYPE() : this.OUTPUT_TYPE();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq<Row> seq;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String startTs = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        String endTs = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        if (StringUtils.isNullOrEmpty(startTs)) {
            startTs = this.getTimeDaysAgo(10);
        }
        if (StringUtils.isNullOrEmpty(endTs)) {
            endTs = this.getTimeDaysAgo(1);
        }
        HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
        try {
            archivedTimeline.loadInstantDetailsInMemory(startTs, endTs);
            HoodieDefaultTimeline timelineRange = archivedTimeline.findInstantsInRange(startTs, endTs);
            seq = this.includeExtraMetadata ? this.getCommitsWithMetadata(timelineRange, limit) : this.getCommits(timelineRange, limit);
            archivedTimeline.clearInstantDetailsFromMemory(startTs, endTs);
        }
        catch (Throwable throwable) {
            void var5_5;
            void var4_4;
            void var9_9;
            var9_9.clearInstantDetailsFromMemory((String)var4_4, (String)var5_5);
            throw throwable;
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new ShowArchivedCommitsProcedure(this.includeExtraMetadata);
    }

    private Seq<Row> getCommitsWithMetadata(HoodieDefaultTimeline timeline, int limit) {
        Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2 = this.getSortCommits(timeline);
        if (tuple2 != null) {
            ArrayList rows = (ArrayList)tuple2._1();
            ArrayList newCommits = (ArrayList)tuple2._2();
            if (rows != null) {
                ArrayList arrayList = rows;
                if (newCommits != null) {
                    Tuple2 tuple22;
                    ArrayList arrayList2 = newCommits;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)arrayList, (Object)arrayList2);
                    ArrayList rows2 = (ArrayList)tuple23._1();
                    ArrayList newCommits2 = (ArrayList)tuple23._2();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach$mVc$sp((Function1)new Serializable(this, timeline, rows2, newCommits2){
                        public static final long serialVersionUID = 0L;
                        private final HoodieDefaultTimeline timeline$1;
                        public final ArrayList rows$1;
                        private final ArrayList newCommits$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            HoodieInstant commit = (HoodieInstant)this.newCommits$1.get(i);
                            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.timeline$1.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
                            JavaConversions$.MODULE$.asScalaSet(commitMetadata.getPartitionToWriteStats().entrySet()).foreach((Function1)new Serializable(this, commit){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$getCommitsWithMetadata$1 $outer;
                                public final HoodieInstant commit$1;

                                public final void apply(Map.Entry<String, List<HoodieWriteStat>> partitionWriteStat) {
                                    JavaConversions$.MODULE$.asScalaBuffer(partitionWriteStat.getValue()).foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$getCommitsWithMetadata$1$$anonfun$apply$mcVI$sp$1 $outer;

                                        public final boolean apply(HoodieWriteStat hoodieWriteStat) {
                                            return this.$outer.org$apache$spark$sql$hudi$command$procedures$ShowArchivedCommitsProcedure$$anonfun$$anonfun$$$outer().rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.commit$1.getTimestamp(), this.$outer.commit$1.getAction(), hoodieWriteStat.getPartitionPath(), hoodieWriteStat.getFileId(), hoodieWriteStat.getPrevCommit(), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumInserts()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumDeletes()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumUpdateWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteErrors()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalCorruptLogBlock()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalRollbackBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogRecords()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalUpdatedRecordsCompacted()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteBytes())})));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$getCommitsWithMetadata$1 org$apache$spark$sql$hudi$command$procedures$ShowArchivedCommitsProcedure$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.commit$1 = commit$1;
                                }
                            });
                        }
                        {
                            this.timeline$1 = timeline$1;
                            this.rows$1 = rows$1;
                            this.newCommits$1 = newCommits$1;
                        }
                    });
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows2.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Row apply(Object r) {
                            return (Row)r;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
                }
            }
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> getSortCommits(HoodieDefaultTimeline timeline) {
        ArrayList rows = new ArrayList();
        List commits = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(timeline.getCommitsTimeline().filterCompletedInstants().getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final HoodieInstant apply(Object instant) {
                return (HoodieInstant)instant;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieInstant.class)))).toList()).asJava();
        ArrayList newCommits = new ArrayList(commits);
        Collections.sort(newCommits, HoodieInstant.COMPARATOR.reversed());
        return new Tuple2(rows, newCommits);
    }

    public Seq<Row> getCommits(HoodieDefaultTimeline timeline, int limit) {
        Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2 = this.getSortCommits(timeline);
        if (tuple2 != null) {
            ArrayList rows = (ArrayList)tuple2._1();
            ArrayList newCommits = (ArrayList)tuple2._2();
            if (rows != null) {
                ArrayList arrayList = rows;
                if (newCommits != null) {
                    Tuple2 tuple22;
                    ArrayList arrayList2 = newCommits;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)arrayList, (Object)arrayList2);
                    ArrayList rows2 = (ArrayList)tuple23._1();
                    ArrayList newCommits2 = (ArrayList)tuple23._2();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach((Function1)new Serializable(this, timeline, rows2, newCommits2){
                        public static final long serialVersionUID = 0L;
                        private final HoodieDefaultTimeline timeline$2;
                        private final ArrayList rows$2;
                        private final ArrayList newCommits$2;

                        public final boolean apply(int i) {
                            return this.apply$mcZI$sp(i);
                        }

                        public boolean apply$mcZI$sp(int i) {
                            HoodieInstant commit = (HoodieInstant)this.newCommits$2.get(i);
                            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.timeline$2.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
                            return this.rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit.getTimestamp(), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalBytesWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesInsert()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesUpdated()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalPartitionsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalUpdateRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalWriteErrors())})));
                        }
                        {
                            this.timeline$2 = timeline$2;
                            this.rows$2 = rows$2;
                            this.newCommits$2 = newCommits$2;
                        }
                    });
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows2.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Row apply(Object r) {
                            return (Row)r;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
                }
            }
        }
        throw new MatchError(tuple2);
    }

    public String getTimeDaysAgo(int numberOfDays) {
        Date date = Date.from(ZonedDateTime.now().minusDays(numberOfDays).toInstant());
        return HoodieActiveTimeline.formatDate(date);
    }

    public ShowArchivedCommitsProcedure(boolean includeExtraMetadata) {
        this.includeExtraMetadata = includeExtraMetadata;
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(2, "start_ts", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(3, "end_ts", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_added", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_partitions_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_update_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
        this.METADATA_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("previous_commit", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("num_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_inserts", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_deletes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_update_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_corrupt_log_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_rollback_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_records", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_updated_records_compacted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }
}

