/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.List;
import java.util.function.Supplier;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowBootstrapPartitionsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0001E\u0011\u0001e\u00155po\n{w\u000e^:ue\u0006\u0004\b+\u0019:uSRLwN\\:Qe>\u001cW\rZ;sK*\u00111\u0001B\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\u0003\u0007\u0003\u001d\u0019w.\\7b]\u0012T!a\u0002\u0005\u0002\t!,H-\u001b\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111cF\u0005\u00031\t\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\n\u0001\u0011\u001dq\u0002A1A\u0005\n}\t!\u0002U!S\u00036+E+\u0012*T+\u0005\u0001\u0003cA\u0011%M5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0014O%\u0011\u0001F\u0001\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'\u000f\u0003\u0004+\u0001\u0001\u0006I\u0001I\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007C\u0001\u0006if\u0004Xm]\u0005\u0003gA\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019)\u0004\u0001)A\u0005]\u0005aq*\u0016+Q+R{F+\u0017)FA!)q\u0007\u0001C\u0001?\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000be\u0002A\u0011A\u0017\u0002\u0015=,H\u000f];u)f\u0004X\rC\u0003<\u0001\u0011\u0005C(\u0001\u0003dC2dGCA\u001fN!\rqd)\u0013\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA##\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0007M+\u0017O\u0003\u0002FEA\u0011!jS\u0007\u0002\u0011%\u0011A\n\u0003\u0002\u0004%><\b\"\u0002(;\u0001\u0004y\u0015\u0001B1sON\u0004\"a\u0005)\n\u0005E\u0013!!\u0004)s_\u000e,G-\u001e:f\u0003J<7\u000fC\u0003T\u0001\u0011%A+\u0001\u000ede\u0016\fG/\u001a\"p_R\u001cHO]1q\u0013:$W\r\u001f*fC\u0012,'\u000f\u0006\u0002VEB\u0011a\u000bY\u0007\u0002/*\u0011\u0001,W\u0001\u000f\u0005>|Go\u001d;sCBLe\u000eZ3y\u0015\tQ6,A\u0003j]\u0012,\u0007P\u0003\u0002];\u0006I!m\\8ugR\u0014\u0018\r\u001d\u0006\u0003=~\u000baaY8n[>t'BA\u0004\r\u0013\t\twKA\u0006J]\u0012,\u0007PU3bI\u0016\u0014\b\"B2S\u0001\u0004!\u0017AC7fi\u0006\u001cE.[3oiB\u0011Q\r[\u0007\u0002M*\u0011q-X\u0001\u0006i\u0006\u0014G.Z\u0005\u0003S\u001a\u0014Q\u0003S8pI&,G+\u00192mK6+G/Y\"mS\u0016tG\u000fC\u0003l\u0001\u0011\u0005C.A\u0003ck&dG-F\u0001\u001d\u000f\u0015q'\u0001#\u0001p\u0003\u0001\u001a\u0006n\\<C_>$8\u000f\u001e:baB\u000b'\u000f^5uS>t7\u000f\u0015:pG\u0016$WO]3\u0011\u0005M\u0001h!B\u0001\u0003\u0011\u0003\t8C\u00019s!\t\t3/\u0003\u0002uE\t1\u0011I\\=SK\u001aDQA\u00079\u0005\u0002Y$\u0012a\u001c\u0005\bqB\u0014\r\u0011\"\u0001z\u0003\u0011q\u0015)T#\u0016\u0003i\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003\u0011a\u0017M\\4\u000b\u0003}\fAA[1wC&\u0019\u00111\u0001?\u0003\rM#(/\u001b8h\u0011\u001d\t9\u0001\u001dQ\u0001\ni\fQAT!N\u000b\u0002Bq!a\u0003q\t\u0003\ti!A\u0004ck&dG-\u001a:\u0016\u0005\u0005=\u0001#BA\t\u000371RBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0011\u0019,hn\u0019;j_:T1!!\u0007\u007f\u0003\u0011)H/\u001b7\n\t\u0005u\u00111\u0003\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class ShowBootstrapPartitionsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("indexed_partitions", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowBootstrapPartitionsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowBootstrapPartitionsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        BootstrapIndex.IndexReader indexReader = this.createBootstrapIndexReader(metaClient);
        List<String> indexedPartitions = indexReader.getIndexedPartitionPaths();
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(indexedPartitions.stream().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    private BootstrapIndex.IndexReader createBootstrapIndexReader(HoodieTableMetaClient metaClient) {
        BootstrapIndex index = BootstrapIndex.getBootstrapIndex(metaClient);
        if (index.useIndex()) {
            return index.createReader();
        }
        throw new HoodieException("This is not a bootstrapped Hudi table. Don't have any index info");
    }

    @Override
    public ShowBootstrapPartitionsProcedure build() {
        return new ShowBootstrapPartitionsProcedure();
    }
}

