/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowFileSystemViewProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001E\u00111d\u00155po\u001aKG.Z*zgR,WNV5foB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!C\u0006\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011QBQ1tKB\u0013xnY3ekJ,\u0007CA\n\u0018\u0013\tA\"A\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0006tQ><H*\u0019;fgR\u0004\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011qAQ8pY\u0016\fg\u000eC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0015\u0002\"a\u0005\u0001\t\u000bi\t\u0003\u0019A\u000e\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005q\u0001+\u0011*B\u001b\u0016#VIU*`\u00032cU#A\u0015\u0011\u0007qQC&\u0003\u0002,;\t)\u0011I\u001d:bsB\u00111#L\u0005\u0003]\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1\u0001\u0007\u0001Q\u0001\n%\nq\u0002U!S\u00036+E+\u0012*T?\u0006cE\n\t\u0005\be\u0001\u0011\r\u0011\"\u00034\u0003=yU\u000b\u0016)V)~#\u0016\fU#`\u00032cU#\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]B\u0011!\u0002;za\u0016\u001c\u0018BA\u001d7\u0005)\u0019FO];diRK\b/\u001a\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001b\u0002!=+F\u000bU+U?RK\u0006+R0B\u00192\u0003\u0003bB\u001f\u0001\u0005\u0004%I\u0001K\u0001\u0012!\u0006\u0013\u0016)T#U\u000bJ\u001bv\fT!U\u000bN#\u0006BB \u0001A\u0003%\u0011&\u0001\nQ\u0003J\u000bU*\u0012+F%N{F*\u0011+F'R\u0003\u0003bB!\u0001\u0005\u0004%IaM\u0001\u0013\u001fV#\u0006+\u0016+`)f\u0003Vi\u0018'B)\u0016\u001bF\u000b\u0003\u0004D\u0001\u0001\u0006I\u0001N\u0001\u0014\u001fV#\u0006+\u0016+`)f\u0003Vi\u0018'B)\u0016\u001bF\u000b\t\u0005\u0006\u000b\u0002!IAR\u0001\u0014EVLG\u000e\u001a$jY\u0016\u001c\u0016p\u001d;f[ZKWm\u001e\u000b\b\u000fJK&\r\u001a4i!\tA\u0005+D\u0001J\u0015\tQ5*\u0001\u0003wS\u0016<(B\u0001'N\u0003\u0015!\u0018M\u00197f\u0015\tqu*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f1I!!U%\u00033!{w\u000eZ5f)\u0006\u0014G.\u001a$jY\u0016\u001c\u0016p\u001d;f[ZKWm\u001e\u0005\u0006\u0019\u0012\u0003\ra\u0015\t\u00049Q3\u0016BA+\u001e\u0005\u0019y\u0005\u000f^5p]B\u0011AdV\u0005\u00031v\u00111!\u00118z\u0011\u0015QF\t1\u0001\\\u0003%9Gn\u001c2SK\u001e,\u0007\u0010\u0005\u0002]?:\u0011A$X\u0005\u0003=v\ta\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011a,\b\u0005\u0006G\u0012\u0003\raW\u0001\u000b[\u0006D\u0018J\\:uC:$\b\"B3E\u0001\u0004Y\u0012!E5oG2,H-Z'bq&s7\u000f^1oi\")q\r\u0012a\u00017\u0005y\u0011N\\2mk\u0012,\u0017J\u001c4mS\u001eDG\u000fC\u0003j\t\u0002\u00071$A\tfq\u000edW\u000fZ3D_6\u0004\u0018m\u0019;j_:DQa\u001b\u0001\u0005\n1\f\u0011c\u001d5po\u0006cGNR5mKNc\u0017nY3t)\ti\u0017\u0010E\u0002ogVl\u0011a\u001c\u0006\u0003aF\fA!\u001e;jY*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0011a\u0015n\u001d;\u0011\u0005Y<X\"\u0001\u0005\n\u0005aD!a\u0001*po\")!P\u001ba\u0001\u000f\u00061am\u001d,jK^DQ\u0001 \u0001\u0005\nu\fAc\u001d5po2\u000bG/Z:u\r&dWm\u00157jG\u0016\u001cH#C7\u007f\u007f\u0006\u0005\u0011QAA\u0004\u0011\u0015Q8\u00101\u0001H\u0011\u0015a5\u00101\u0001T\u0011\u0019\t\u0019a\u001fa\u00017\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\u0006Gn\u0004\ra\u0017\u0005\u0007\u0003\u0013Y\b\u0019A\u000e\u0002\u000b5,'oZ3\t\r\u00055\u0001\u0001\"\u0011)\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\u0007\u0003#\u0001A\u0011I\u001a\u0002\u0015=,H\u000f];u)f\u0004X\rC\u0004\u0002\u0016\u0001!\t%a\u0006\u0002\t\r\fG\u000e\u001c\u000b\u0005\u00033\t\t\u0004E\u0003\u0002\u001c\u0005-RO\u0004\u0003\u0002\u001e\u0005\u001db\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0002#\u0001\u0004=e>|GOP\u0005\u0002=%\u0019\u0011\u0011F\u000f\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005\r\u0019V-\u001d\u0006\u0004\u0003Si\u0002\u0002CA\u001a\u0003'\u0001\r!!\u000e\u0002\t\u0005\u0014xm\u001d\t\u0004'\u0005]\u0012bAA\u001d\u0005\ti\u0001K]8dK\u0012,(/Z!sONDq!!\u0010\u0001\t\u0003\ny$A\u0003ck&dG-\u0006\u0002\u0002BA\u00191#a\u0011\n\u0007\u0005\u0015#AA\u0005Qe>\u001cW\rZ;sK\u0002")
public class ShowFileSystemViewProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean showLatest;
    private final ProcedureParameter[] PARAMETERS_ALL;
    private final StructType OUTPUT_TYPE_ALL;
    private final ProcedureParameter[] PARAMETERS_LATEST;
    private final StructType OUTPUT_TYPE_LATEST;

    private ProcedureParameter[] PARAMETERS_ALL() {
        return this.PARAMETERS_ALL;
    }

    private StructType OUTPUT_TYPE_ALL() {
        return this.OUTPUT_TYPE_ALL;
    }

    private ProcedureParameter[] PARAMETERS_LATEST() {
        return this.PARAMETERS_LATEST;
    }

    private StructType OUTPUT_TYPE_LATEST() {
        return this.OUTPUT_TYPE_LATEST;
    }

    private HoodieTableFileSystemView buildFileSystemView(Option<Object> table, String globRegex, String maxInstant, boolean includeMaxInstant, boolean includeInflight, boolean excludeCompaction) {
        HoodieTimeline timeline;
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieWrapperFileSystem fs = metaClient.getFs();
        String globPath2 = String.format("%s/%s/*", basePath, globRegex);
        List<FileStatus> statuses = FSUtils.getGlobStatusExcludingMetaFolder(fs, new Path(globPath2));
        HoodieTimeline hoodieTimeline = timeline = excludeCompaction ? metaClient.getActiveTimeline().getCommitsTimeline() : metaClient.getActiveTimeline().getWriteTimeline();
        if (!includeInflight) {
            timeline = timeline.filterCompletedInstants();
        }
        Iterator instants = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeline.getInstants().iterator()).asScala();
        if (new StringOps(Predef$.MODULE$.augmentString(maxInstant)).nonEmpty()) {
            BiPredicate<String, String> predicate = includeMaxInstant ? HoodieTimeline.GREATER_THAN_OR_EQUALS : HoodieTimeline.GREATER_THAN;
            instants = instants.filter((Function1)new Serializable(this, maxInstant, predicate){
                public static final long serialVersionUID = 0L;
                private final String maxInstant$1;
                private final BiPredicate predicate$1;

                public final boolean apply(HoodieInstant instant) {
                    return this.predicate$1.test(this.maxInstant$1, instant.getTimestamp());
                }
                {
                    this.maxInstant$1 = maxInstant$1;
                    this.predicate$1 = predicate$1;
                }
            });
        }
        Function<HoodieInstant, org.apache.hudi.common.util.Option<byte[]>> details = new Function<HoodieInstant, org.apache.hudi.common.util.Option<byte[]>>(this, metaClient){
            private final HoodieTableMetaClient metaClient$1;

            public org.apache.hudi.common.util.Option<byte[]> apply(HoodieInstant instant) {
                return this.metaClient$1.getActiveTimeline().getInstantDetails(instant);
            }
            {
                this.metaClient$1 = metaClient$1;
            }
        };
        HoodieDefaultTimeline filteredTimeline = new HoodieDefaultTimeline(new ArrayList(JavaConversions$.MODULE$.asJavaCollection((Iterable)instants.toList())).stream(), details);
        return new HoodieTableFileSystemView(metaClient, (HoodieTimeline)filteredTimeline, (FileStatus[])statuses.toArray((Object[])new FileStatus[0]));
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> showAllFileSlices(HoodieTableFileSystemView fsView) {
        void var2_2;
        ArrayList rows = new ArrayList();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getAllFileGroups().iterator()).asScala()).foreach((Function1)new Serializable(this, rows){
            public static final long serialVersionUID = 0L;
            public final List rows$1;

            public final void apply(HoodieFileGroup fg) {
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fg.getAllFileSlices().iterator()).asScala()).foreach((Function1)new Serializable(this, fg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$showAllFileSlices$1 $outer;
                    private final HoodieFileGroup fg$1;

                    public final boolean apply(FileSlice fs) {
                        String fileId = this.fg$1.getFileGroupId().getFileId();
                        String baseFilePath = "";
                        long baseFileSize = 0L;
                        if (fs.getBaseFile().isPresent()) {
                            baseFilePath = ((BaseFile)fs.getBaseFile().get()).getPath();
                            baseFileSize = ((BaseFile)fs.getBaseFile().get()).getFileSize();
                        }
                        long numLogFiles = fs.getLogFiles().count();
                        long sumLogFileSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(HoodieLogFile x$1) {
                                return x$1.getFileSize();
                            }
                        }).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        String logFiles = fs.getLogFiles().collect(Collectors.toList()).toString();
                        return this.$outer.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fg$1.getPartitionPath(), fileId, fs.getBaseInstantTime(), baseFilePath, BoxesRunTime.boxToLong((long)baseFileSize), BoxesRunTime.boxToLong((long)numLogFiles), BoxesRunTime.boxToLong((long)sumLogFileSize), logFiles})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fg$1 = fg$1;
                    }
                });
            }
            {
                this.rows$1 = rows$1;
            }
        });
        return var2_2;
    }

    private List<Row> showLatestFileSlices(HoodieTableFileSystemView fsView, Option<Object> table, String partition, String maxInstant, boolean merge) {
        Stream<FileSlice> fileSliceStream = null;
        if (merge) {
            String string;
            if (maxInstant.isEmpty()) {
                String basePath = this.getBasePath(table, this.getBasePath$default$2());
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
                string = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants().lastInstant().get().getTimestamp();
            } else {
                string = maxInstant;
            }
            fileSliceStream = fsView.getLatestMergedFileSlicesBeforeOrOn(partition, string);
        } else {
            fileSliceStream = fsView.getLatestFileSlices(partition);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fileSliceStream.iterator()).asScala()).foreach((Function1)new Serializable(this, partition, rows){
            public static final long serialVersionUID = 0L;
            private final String partition$1;
            private final List rows$2;

            public final boolean apply(FileSlice fs) {
                String fileId = fs.getFileId();
                String baseInstantTime = fs.getBaseInstantTime();
                String baseFilePath = "";
                long baseFileSize = 0L;
                if (fs.getBaseFile().isPresent()) {
                    baseFilePath = ((BaseFile)fs.getBaseFile().get()).getPath();
                    baseFileSize = ((BaseFile)fs.getBaseFile().get()).getFileSize();
                }
                long numLogFiles = fs.getLogFiles().count();
                long sumLogFileSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(HoodieLogFile x$2) {
                        return x$2.getFileSize();
                    }
                }).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                long logFilesScheduledForCompactionTotalSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1)new Serializable(this, fs){
                    public static final long serialVersionUID = 0L;
                    private final FileSlice fs$1;

                    public final boolean apply(HoodieLogFile logFile) {
                        return logFile.getBaseCommitTime().equals(this.fs$1.getBaseInstantTime());
                    }
                    {
                        this.fs$1 = fs$1;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(HoodieLogFile x$3) {
                        return x$3.getFileSize();
                    }
                }).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                long logFilesUnscheduledTotalSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1)new Serializable(this, fs){
                    public static final long serialVersionUID = 0L;
                    private final FileSlice fs$1;

                    public final boolean apply(HoodieLogFile logFile) {
                        return !logFile.getBaseCommitTime().equals(this.fs$1.getBaseInstantTime());
                    }
                    {
                        this.fs$1 = fs$1;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(HoodieLogFile x$4) {
                        return x$4.getFileSize();
                    }
                }).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                double logSelectedForCompactionToBaseRatio = baseFileSize > 0L ? (double)logFilesScheduledForCompactionTotalSize / ((double)baseFileSize * 1.0) : -1.0;
                double logUnscheduledToBaseRatio = baseFileSize > 0L ? (double)logFilesUnscheduledTotalSize / ((double)baseFileSize * 1.0) : -1.0;
                String logFilesCommitTimeEqualInstantTime = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1)new Serializable(this, fs){
                    public static final long serialVersionUID = 0L;
                    private final FileSlice fs$1;

                    public final boolean apply(HoodieLogFile logFile) {
                        return logFile.getBaseCommitTime().equals(this.fs$1.getBaseInstantTime());
                    }
                    {
                        this.fs$1 = fs$1;
                    }
                }).mkString("[", ",", "]");
                String logFilesCommitTimeNonEqualInstantTime = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1)new Serializable(this, fs){
                    public static final long serialVersionUID = 0L;
                    private final FileSlice fs$1;

                    public final boolean apply(HoodieLogFile logFile) {
                        return !logFile.getBaseCommitTime().equals(this.fs$1.getBaseInstantTime());
                    }
                    {
                        this.fs$1 = fs$1;
                    }
                }).mkString("[", ",", "]");
                return this.rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1, fileId, baseInstantTime, baseFilePath, BoxesRunTime.boxToLong((long)baseFileSize), BoxesRunTime.boxToLong((long)numLogFiles), BoxesRunTime.boxToLong((long)sumLogFileSize), BoxesRunTime.boxToLong((long)logFilesScheduledForCompactionTotalSize), BoxesRunTime.boxToLong((long)logFilesUnscheduledTotalSize), BoxesRunTime.boxToDouble((double)logSelectedForCompactionToBaseRatio), BoxesRunTime.boxToDouble((double)logUnscheduledToBaseRatio), logFilesCommitTimeEqualInstantTime, logFilesCommitTimeNonEqualInstantTime})));
            }
            {
                this.partition$1 = partition$1;
                this.rows$2 = rows$2;
            }
        });
        return rows;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.showLatest ? this.PARAMETERS_LATEST() : this.PARAMETERS_ALL();
    }

    @Override
    public StructType outputType() {
        return this.showLatest ? this.OUTPUT_TYPE_LATEST() : this.OUTPUT_TYPE_ALL();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        List<Row> list;
        super.checkArgs(this.parameters(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.parameters()[0]);
        String maxInstant = (String)this.getArgValueOrDefault(args, this.parameters()[1]).get();
        boolean includeMax = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[2]).get());
        boolean includeInflight = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[3]).get());
        boolean excludeCompaction = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[4]).get());
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[5]).get());
        if (this.showLatest) {
            String partitionPath = (String)this.getArgValueOrDefault(args, this.parameters()[6]).get();
            boolean merge = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[7]).get());
            HoodieTableFileSystemView fsView = this.buildFileSystemView(table, partitionPath, maxInstant, includeMax, includeInflight, excludeCompaction);
            list = this.showLatestFileSlices(fsView, table, partitionPath, maxInstant, merge);
        } else {
            String globRegex = (String)this.getArgValueOrDefault(args, this.parameters()[6]).get();
            HoodieTableFileSystemView fsView = this.buildFileSystemView(table, globRegex, maxInstant, includeMax, includeInflight, excludeCompaction);
            list = this.showAllFileSlices(fsView);
        }
        List<Row> rows = list;
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowFileSystemViewProcedure(this.showLatest);
    }

    public ShowFileSystemViewProcedure(boolean showLatest) {
        this.showLatest = showLatest;
        this.PARAMETERS_ALL = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "max_instant", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "include_max", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "include_in_flight", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(4, "exclude_compaction", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(5, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(6, "path_regex", DataTypes.StringType, "*/*/*")});
        this.OUTPUT_TYPE_ALL = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_delta_files", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_delta_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_files", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
        this.PARAMETERS_LATEST = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "max_instant", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "include_max", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "include_inflight", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(4, "exclude_compaction", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(5, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(6, "partition_path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(7, "merge", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true))});
        this.OUTPUT_TYPE_LATEST = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_delta_files", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_delta_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_size_compaction_scheduled", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_size_compaction_unscheduled", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_to_base_radio_compaction_scheduled", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("delta_to_base_radio_compaction_unscheduled", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("delta_files_compaction_scheduled", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("delta_files_compaction_unscheduled", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

