/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class JavaLocationStrategySuite
implements Serializable {
    @Test
    public void testLocationStrategyConstructors() {
        String topic1 = "topic1";
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic1", 1);
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        hosts.put(tp1, "node1");
        hosts.put(tp2, "node2");
        Map sHosts = (Map)JavaConverters.mapAsScalaMapConverter(hosts).asScala();
        LocationStrategy c1 = LocationStrategies.PreferConsistent();
        LocationStrategy c2 = LocationStrategies.PreferConsistent();
        Assert.assertSame((Object)c1, (Object)c2);
        LocationStrategy c3 = LocationStrategies.PreferBrokers();
        LocationStrategy c4 = LocationStrategies.PreferBrokers();
        Assert.assertSame((Object)c3, (Object)c4);
        Assert.assertNotSame((Object)c1, (Object)c3);
        LocationStrategy c5 = LocationStrategies.PreferFixed(hosts);
        LocationStrategy c6 = LocationStrategies.PreferFixed((Map<TopicPartition, String>)sHosts);
        Assert.assertEquals((Object)c5, (Object)c6);
    }
}

