/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.tools;

import io.confluent.common.utils.AbstractPerformanceTest;
import io.confluent.common.utils.PerformanceStats;
import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import org.apache.avro.Schema;

public class SchemaRegistryClientPerformance
extends AbstractPerformanceTest {
    long targetRegisteredSchemas;
    long targetSchemasPerSec;
    String baseUrl;
    RestService restService;
    String subject;
    long registeredSchemas = 0L;
    long successfullyRegisteredSchemas = 0L;
    CachedSchemaRegistryClient client;

    public static void main(String[] args2) throws Exception {
        if (args2.length < 4) {
            System.out.println("Usage: java " + SchemaRegistryClientPerformance.class.getName() + " schema_registry_url subject num_schemas target_schemas_per_sec");
            System.exit(1);
        }
        String baseUrl = args2[0];
        String subject = args2[1];
        int numSchemas = Integer.parseInt(args2[2]);
        int targetSchemasPerSec = Integer.parseInt(args2[3]);
        SchemaRegistryClientPerformance perf = new SchemaRegistryClientPerformance(baseUrl, subject, numSchemas, targetSchemasPerSec);
        perf.run(targetSchemasPerSec);
        perf.close();
    }

    public SchemaRegistryClientPerformance(String baseUrl, String subject, long numSchemas, long targetSchemasPerSec) throws Exception {
        super(numSchemas);
        this.baseUrl = baseUrl;
        this.restService = new RestService(baseUrl);
        this.subject = subject;
        this.targetRegisteredSchemas = numSchemas;
        this.targetSchemasPerSec = targetSchemasPerSec;
        this.client = new CachedSchemaRegistryClient(this.restService, Integer.MAX_VALUE);
        this.client.updateCompatibility(null, AvroCompatibilityLevel.NONE.name);
    }

    private static Schema makeSchema(long num) {
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + num + "\"}]}";
        Schema.Parser parser1 = new Schema.Parser();
        Schema schema2 = parser1.parse(schemaString);
        return schema2;
    }

    @Override
    protected void doIteration(PerformanceStats.Callback cb) {
        Schema schema2 = SchemaRegistryClientPerformance.makeSchema(this.registeredSchemas);
        try {
            this.client.register(this.subject, schema2);
            int id = this.client.getId(this.subject, schema2);
            int version = this.client.getVersion(this.subject, schema2);
            ++this.successfullyRegisteredSchemas;
        }
        catch (IOException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        catch (RestClientException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        ++this.registeredSchemas;
        cb.onCompletion(1, 0L);
    }

    protected void close() {
        if ((double)this.successfullyRegisteredSchemas / (double)this.targetRegisteredSchemas < 0.99) {
            throw new RuntimeException("Too many schema registration errors: " + this.successfullyRegisteredSchemas + " registered successfully out of " + this.targetRegisteredSchemas + " attempted");
        }
    }

    @Override
    protected boolean finished(int iteration) {
        return this.targetRegisteredSchemas == this.registeredSchemas;
    }

    @Override
    protected boolean runningFast(int iteration, float elapsed) {
        return (float)iteration / elapsed > (float)this.targetSchemasPerSec;
    }
}

