/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import org.apache.hudi.HoodieDatasetBulkInsertHelper$;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.model.HoodieInternalRow;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BulkInsertDataInternalWriterHelper;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils$;
import org.apache.spark.sql.HoodieUnsafeUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieDatasetBulkInsertHelper$
implements Logging {
    public static final HoodieDatasetBulkInsertHelper$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HoodieDatasetBulkInsertHelper$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Dataset<Row> prepareForBulkInsert(Dataset<Row> df, HoodieWriteConfig config, BulkInsertPartitioner<Dataset<Row>> partitioner, boolean shouldDropPartitionColumns) {
        Dataset<Row> dataset;
        boolean populateMetaFields = config.populateMetaFields();
        StructType schema2 = df.schema();
        Seq metaFields = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("_hoodie_commit_time", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("_hoodie_commit_seqno", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("_hoodie_record_key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("_hoodie_partition_path", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("_hoodie_file_name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        StructType updatedSchema = StructType$.MODULE$.apply((Seq)metaFields.$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])schema2.fields()), Seq$.MODULE$.canBuildFrom()));
        if (populateMetaFields) {
            String keyGeneratorClassName = config.getStringOrThrow(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME, "Key-generator class name is required");
            RDD<InternalRow> prependedRdd = df.queryExecution().toRdd().mapPartitions((Function1)new Serializable(config, schema2, keyGeneratorClassName){
                public static final long serialVersionUID = 0L;
                private final HoodieWriteConfig config$1;
                public final StructType schema$1;
                private final String keyGeneratorClassName$1;

                public final Iterator<HoodieInternalRow> apply(Iterator<InternalRow> iter) {
                    SparkKeyGeneratorInterface keyGenerator = (SparkKeyGeneratorInterface)ReflectionUtils.loadClass(this.keyGeneratorClassName$1, new TypedProperties(this.config$1.getProps()));
                    return iter.map((Function1)new Serializable(this, keyGenerator){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.1 $outer;
                        private final SparkKeyGeneratorInterface keyGenerator$1;

                        public final HoodieInternalRow apply(InternalRow row) {
                            UTF8String recordKey = this.keyGenerator$1.getRecordKey(row, this.$outer.schema$1);
                            UTF8String partitionPath = this.keyGenerator$1.getPartitionPath(row, this.$outer.schema$1);
                            UTF8String commitTimestamp = UTF8String.EMPTY_UTF8;
                            UTF8String commitSeqNo = UTF8String.EMPTY_UTF8;
                            UTF8String filename = UTF8String.EMPTY_UTF8;
                            return new HoodieInternalRow(commitTimestamp, commitSeqNo, recordKey, partitionPath, filename, row, false);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.keyGenerator$1 = keyGenerator$1;
                        }
                    });
                }
                {
                    this.config$1 = config$1;
                    this.schema$1 = schema$1;
                    this.keyGeneratorClassName$1 = keyGeneratorClassName$1;
                }
            }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
            RDD<InternalRow> dedupedRdd = config.shouldCombineBeforeInsert() ? this.dedupeRows(prependedRdd, updatedSchema, config.getPreCombineField(), SparkHoodieIndexFactory.isGlobalIndex(config)) : prependedRdd;
            dataset = HoodieUnsafeUtils$.MODULE$.createDataFrameFromRDD(df.sparkSession(), dedupedRdd, updatedSchema);
        } else {
            LogicalPlan query = df.queryExecution().logical();
            Seq metaFieldsStubs = (Seq)metaFields.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Alias apply(StructField f) {
                    Literal x$2 = new Literal((Object)UTF8String.EMPTY_UTF8, (DataType)StringType$.MODULE$);
                    String x$3 = f.name();
                    ExprId x$4 = Alias$.MODULE$.apply$default$3((Expression)x$2, x$3);
                    Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$2, x$3);
                    Option x$6 = Alias$.MODULE$.apply$default$5((Expression)x$2, x$3);
                    return new Alias((Expression)x$2, x$3, x$4, x$5, x$6);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Project prependedQuery = new Project((Seq)metaFieldsStubs.$plus$plus((GenTraversableOnce)query.output(), Seq$.MODULE$.canBuildFrom()), query);
            dataset = HoodieUnsafeUtils$.MODULE$.createDataFrameFrom(df.sparkSession(), (LogicalPlan)prependedQuery);
        }
        Dataset<Row> updatedDF = dataset;
        Dataset<Row> trimmedDF = shouldDropPartitionColumns ? this.dropPartitionColumns(updatedDF, config) : updatedDF;
        return partitioner.repartitionRecords(trimmedDF, config.getBulkInsertShuffleParallelism());
    }

    public HoodieData<WriteStatus> bulkInsert(Dataset<Row> dataset, String instantTime, HoodieTable<? extends HoodieRecordPayload<? extends HoodieRecordPayload<?>>, ?, ?, ?> table, HoodieWriteConfig writeConfig, BulkInsertPartitioner<Dataset<Row>> partitioner, int parallelism, boolean shouldPreserveHoodieMetadata) {
        Dataset<Row> repartitionedDataset = partitioner.repartitionRecords(dataset, parallelism);
        boolean arePartitionRecordsSorted = partitioner.arePartitionRecordsSorted();
        StructType schema2 = dataset.schema();
        WriteStatus[] writeStatuses = (WriteStatus[])repartitionedDataset.queryExecution().toRdd().mapPartitions((Function1)new Serializable(instantTime, table, writeConfig, shouldPreserveHoodieMetadata, arePartitionRecordsSorted, schema2){
            public static final long serialVersionUID = 0L;
            private final String instantTime$1;
            private final HoodieTable table$1;
            private final HoodieWriteConfig writeConfig$1;
            private final boolean shouldPreserveHoodieMetadata$1;
            private final boolean arePartitionRecordsSorted$1;
            private final StructType schema$2;

            /*
             * WARNING - void declaration
             */
            public final Iterator<WriteStatus> apply(Iterator<InternalRow> iter) {
                TaskContextSupplier taskContextSupplier = this.table$1.getTaskContextSupplier();
                Integer taskPartitionId = taskContextSupplier.getPartitionIdSupplier().get();
                long taskId = Predef$.MODULE$.Integer2int(taskContextSupplier.getStageIdSupplier().get());
                Long taskEpochId = taskContextSupplier.getAttemptIdSupplier().get();
                BulkInsertDataInternalWriterHelper writer = new BulkInsertDataInternalWriterHelper(this.table$1, this.writeConfig$1, this.instantTime$1, Predef$.MODULE$.Integer2int(taskPartitionId), taskId, Predef$.MODULE$.Long2long(taskEpochId), this.schema$2, this.writeConfig$1.populateMetaFields(), this.arePartitionRecordsSorted$1, this.shouldPreserveHoodieMetadata$1);
                try {
                    iter.foreach((Function1)new Serializable(this, writer){
                        public static final long serialVersionUID = 0L;
                        private final BulkInsertDataInternalWriterHelper writer$1;

                        public final void apply(InternalRow row) {
                            this.writer$1.write(row);
                        }
                        {
                            this.writer$1 = writer$1;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var7_6;
                    try {
                        var7_6.abort();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        var7_6.close();
                        throw throwable2;
                    }
                }
                writer.close();
                return ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(writer.getWriteStatuses()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WriteStatus apply(HoodieInternalWriteStatus x$1) {
                        return x$1.toWriteStatus();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).iterator();
            }
            {
                this.instantTime$1 = instantTime$1;
                this.table$1 = table$1;
                this.writeConfig$1 = writeConfig$1;
                this.shouldPreserveHoodieMetadata$1 = shouldPreserveHoodieMetadata$1;
                this.arePartitionRecordsSorted$1 = arePartitionRecordsSorted$1;
                this.schema$2 = schema$2;
            }
        }, repartitionedDataset.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(WriteStatus.class)).collect();
        return table.getContext().parallelize((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])writeStatuses).toList()).asJava());
    }

    private RDD<InternalRow> dedupeRows(RDD<InternalRow> rdd, StructType schema2, String preCombineFieldRef, boolean isGlobalIndex) {
        int recordKeyMetaFieldOrd = schema2.fieldIndex("_hoodie_record_key");
        int partitionPathMetaFieldOrd = schema2.fieldIndex("_hoodie_partition_path");
        HoodieUnsafeRowUtils.NestedFieldPath preCombineFieldPath = HoodieUnsafeRowUtils$.MODULE$.composeNestedFieldPath(schema2, preCombineFieldRef);
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1)new Serializable(isGlobalIndex, recordKeyMetaFieldOrd, partitionPathMetaFieldOrd){
            public static final long serialVersionUID = 0L;
            private final boolean isGlobalIndex$1;
            private final int recordKeyMetaFieldOrd$1;
            private final int partitionPathMetaFieldOrd$1;

            public final Tuple2<String, InternalRow> apply(InternalRow row) {
                String string;
                if (this.isGlobalIndex$1) {
                    string = row.getString(this.recordKeyMetaFieldOrd$1);
                } else {
                    String partitionPath = row.getString(this.partitionPathMetaFieldOrd$1);
                    String recordKey = row.getString(this.recordKeyMetaFieldOrd$1);
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPath, recordKey}));
                }
                String rowKey = string;
                return new Tuple2((Object)rowKey, (Object)row.copy());
            }
            {
                this.isGlobalIndex$1 = isGlobalIndex$1;
                this.recordKeyMetaFieldOrd$1 = recordKeyMetaFieldOrd$1;
                this.partitionPathMetaFieldOrd$1 = partitionPathMetaFieldOrd$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(InternalRow.class), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(preCombineFieldPath){
            public static final long serialVersionUID = 0L;
            private final HoodieUnsafeRowUtils.NestedFieldPath preCombineFieldPath$1;

            public final InternalRow apply(InternalRow oneRow, InternalRow otherRow) {
                Comparable otherPreCombineVal;
                Comparable onePreCombineVal = (Comparable)HoodieUnsafeRowUtils$.MODULE$.getNestedInternalRowValue(oneRow, this.preCombineFieldPath$1);
                return onePreCombineVal.compareTo(otherPreCombineVal = (Comparable)HoodieUnsafeRowUtils$.MODULE$.getNestedInternalRowValue(otherRow, this.preCombineFieldPath$1)) >= 0 ? oneRow : otherRow;
            }
            {
                this.preCombineFieldPath$1 = preCombineFieldPath$1;
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(InternalRow.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private Dataset<Row> dropPartitionColumns(Dataset<Row> df, HoodieWriteConfig config) {
        Set partitionPathFields = this.getPartitionPathFields(config).toSet();
        Set nestedPartitionPathFields = (Set)partitionPathFields.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String f) {
                return new StringOps(Predef$.MODULE$.augmentString(f)).contains((Object)BoxesRunTime.boxToCharacter((char)'.'));
            }
        });
        if (nestedPartitionPathFields.nonEmpty()) {
            this.logWarning((Function0<String>)new Serializable(nestedPartitionPathFields){
                public static final long serialVersionUID = 0L;
                private final Set nestedPartitionPathFields$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not drop nested partition path fields: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nestedPartitionPathFields$1}));
                }
                {
                    this.nestedPartitionPathFields$1 = nestedPartitionPathFields$1;
                }
            });
        }
        Seq partitionPathCols = ((SetLike)partitionPathFields.$minus$minus((GenTraversableOnce)nestedPartitionPathFields)).toSeq();
        return df.drop(partitionPathCols);
    }

    private Seq<String> getPartitionPathFields(HoodieWriteConfig config) {
        String keyGeneratorClassName = config.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME);
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)ReflectionUtils.loadClass(keyGeneratorClassName, new TypedProperties(config.getProps()));
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(keyGenerator.getPartitionPathFields()).asScala();
    }

    private HoodieDatasetBulkInsertHelper$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

