/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.esotericsoftware.kryo.io;

import java.io.InputStream;
import org.apache.hudi.com.esotericsoftware.kryo.KryoException;
import org.apache.hudi.com.esotericsoftware.kryo.io.Input;
import org.apache.hudi.com.esotericsoftware.kryo.util.UnsafeUtil;

public final class UnsafeInput
extends Input {
    private boolean varIntsEnabled = false;

    public UnsafeInput() {
    }

    public UnsafeInput(int bufferSize) {
        super(bufferSize);
    }

    public UnsafeInput(byte[] buffer) {
        super(buffer);
    }

    public UnsafeInput(byte[] buffer, int offset, int count2) {
        super(buffer, offset, count2);
    }

    public UnsafeInput(InputStream inputStream) {
        super(inputStream);
    }

    public UnsafeInput(InputStream inputStream, int bufferSize) {
        super(inputStream, bufferSize);
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        int result = UnsafeUtil.unsafe().getInt(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 4;
        return result;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        float result = UnsafeUtil.unsafe().getFloat(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 4;
        return result;
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        short result = UnsafeUtil.unsafe().getShort(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 2;
        return result;
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        long result = UnsafeUtil.unsafe().getLong(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 8;
        return result;
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        double result = UnsafeUtil.unsafe().getDouble(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 8;
        return result;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        char result = UnsafeUtil.unsafe().getChar(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 2;
        return result;
    }

    @Override
    public int readInt(boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            return this.readInt();
        }
        return super.readInt(optimizePositive);
    }

    @Override
    public long readLong(boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            return this.readLong();
        }
        return super.readLong(optimizePositive);
    }

    @Override
    public final int[] readInts(int length, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = length << 2;
            int[] array2 = new int[length];
            this.readBytes(array2, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
            return array2;
        }
        return super.readInts(length, optimizePositive);
    }

    @Override
    public final long[] readLongs(int length, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = length << 3;
            long[] array2 = new long[length];
            this.readBytes(array2, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
            return array2;
        }
        return super.readLongs(length, optimizePositive);
    }

    @Override
    public final int[] readInts(int length) throws KryoException {
        int bytesToCopy = length << 2;
        int[] array2 = new int[length];
        this.readBytes(array2, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    @Override
    public final long[] readLongs(int length) throws KryoException {
        int bytesToCopy = length << 3;
        long[] array2 = new long[length];
        this.readBytes(array2, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    @Override
    public final float[] readFloats(int length) throws KryoException {
        int bytesToCopy = length << 2;
        float[] array2 = new float[length];
        this.readBytes(array2, UnsafeUtil.floatArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    @Override
    public final short[] readShorts(int length) throws KryoException {
        int bytesToCopy = length << 1;
        short[] array2 = new short[length];
        this.readBytes(array2, UnsafeUtil.shortArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    @Override
    public final char[] readChars(int length) throws KryoException {
        int bytesToCopy = length << 1;
        char[] array2 = new char[length];
        this.readBytes(array2, UnsafeUtil.charArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    @Override
    public final double[] readDoubles(int length) throws KryoException {
        int bytesToCopy = length << 3;
        double[] array2 = new double[length];
        this.readBytes(array2, UnsafeUtil.doubleArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    public final void readBytes(Object dstObj, long offset, long count2) throws KryoException {
        if (!dstObj.getClass().isArray()) {
            throw new KryoException("Only bulk reads of arrays is supported");
        }
        this.readBytes(dstObj, 0L, offset, (int)count2);
    }

    private final void readBytes(Object dstArray, long dstArrayTypeOffset, long offset, int count2) throws KryoException {
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, dstArray, dstArrayTypeOffset + offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += (long)copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
    }

    public boolean getVarIntsEnabled() {
        return this.varIntsEnabled;
    }

    public void setVarIntsEnabled(boolean varIntsEnabled) {
        this.varIntsEnabled = varIntsEnabled;
    }
}

