/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIncompatibleSchemaException;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.hudi.io.storage.HoodieOrcReader;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.util.Lazy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

@ThreadSafe
public class TableSchemaResolver {
    private static final Logger LOG = LogManager.getLogger(TableSchemaResolver.class);
    private final HoodieTableMetaClient metaClient;
    private final Lazy<Boolean> hasOperationField;
    private final Lazy<ConcurrentHashMap<HoodieInstant, HoodieCommitMetadata>> commitMetadataCache;
    private volatile HoodieInstant latestCommitWithValidSchema = null;
    private volatile HoodieInstant latestCommitWithValidData = null;

    public TableSchemaResolver(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.commitMetadataCache = Lazy.lazily(() -> new ConcurrentHashMap(2));
        this.hasOperationField = Lazy.lazily(this::hasOperationField);
    }

    public Schema getTableAvroSchemaFromDataFile() {
        return this.convertParquetSchemaToAvro(this.getTableParquetSchemaFromDataFile());
    }

    public Schema getTableAvroSchema() throws Exception {
        return this.getTableAvroSchema(this.metaClient.getTableConfig().populateMetaFields());
    }

    public Schema getTableAvroSchema(boolean includeMetadataFields) throws Exception {
        return this.getTableAvroSchemaInternal(includeMetadataFields, Option.empty());
    }

    public Schema getTableAvroSchema(String timestamp) throws Exception {
        Option<HoodieInstant> instant = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().findInstantsBeforeOrEquals(timestamp).lastInstant();
        return this.getTableAvroSchemaInternal(this.metaClient.getTableConfig().populateMetaFields(), instant);
    }

    public Schema getTableAvroSchema(HoodieInstant instant, boolean includeMetadataFields) throws Exception {
        return this.getTableAvroSchemaInternal(includeMetadataFields, Option.of(instant));
    }

    public MessageType getTableParquetSchema() throws Exception {
        return this.convertAvroSchemaToParquet(this.getTableAvroSchema(true));
    }

    @Deprecated
    public Schema getTableAvroSchemaWithoutMetadataFields() throws Exception {
        return this.getTableAvroSchema(false);
    }

    private Schema getTableAvroSchemaInternal(boolean includeMetadataFields, Option<HoodieInstant> instantOpt) {
        Schema schema2 = (instantOpt.isPresent() ? this.getTableSchemaFromCommitMetadata(instantOpt.get(), includeMetadataFields) : this.getTableSchemaFromLatestCommitMetadata(includeMetadataFields)).or(() -> this.metaClient.getTableConfig().getTableCreateSchema().map(tableSchema -> includeMetadataFields ? HoodieAvroUtils.addMetadataFields(tableSchema, this.hasOperationField.get()) : tableSchema)).orElseGet(() -> {
            Schema schemaFromDataFile = this.getTableAvroSchemaFromDataFile();
            return includeMetadataFields ? schemaFromDataFile : HoodieAvroUtils.removeMetadataFields(schemaFromDataFile);
        });
        if (this.metaClient.getTableConfig().shouldDropPartitionColumns().booleanValue()) {
            return this.metaClient.getTableConfig().getPartitionFields().map(partitionFields -> TableSchemaResolver.appendPartitionColumns(schema2, Option.ofNullable(partitionFields))).orElse(schema2);
        }
        return schema2;
    }

    private Option<Schema> getTableSchemaFromLatestCommitMetadata(boolean includeMetadataFields) {
        Option<Pair<HoodieInstant, HoodieCommitMetadata>> instantAndCommitMetadata = this.getLatestCommitMetadataWithValidSchema();
        if (instantAndCommitMetadata.isPresent()) {
            HoodieCommitMetadata commitMetadata = instantAndCommitMetadata.get().getRight();
            String schemaStr = commitMetadata.getMetadata("schema");
            Schema schema2 = new Schema.Parser().parse(schemaStr);
            if (includeMetadataFields) {
                schema2 = HoodieAvroUtils.addMetadataFields(schema2, this.hasOperationField.get());
            }
            return Option.of(schema2);
        }
        return Option.empty();
    }

    private Option<Schema> getTableSchemaFromCommitMetadata(HoodieInstant instant, boolean includeMetadataFields) {
        try {
            HoodieCommitMetadata metadata = this.getCachedCommitMetadata(instant);
            String existingSchemaStr = metadata.getMetadata("schema");
            if (StringUtils.isNullOrEmpty(existingSchemaStr)) {
                return Option.empty();
            }
            Schema schema2 = new Schema.Parser().parse(existingSchemaStr);
            if (includeMetadataFields) {
                schema2 = HoodieAvroUtils.addMetadataFields(schema2, this.hasOperationField.get());
            }
            return Option.of(schema2);
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema from commit metadata", e);
        }
    }

    private MessageType getTableParquetSchemaFromDataFile() {
        Option<Pair<HoodieInstant, HoodieCommitMetadata>> instantAndCommitMetadata = this.getLatestCommitMetadataWithValidData();
        try {
            switch (this.metaClient.getTableType()) {
                case COPY_ON_WRITE: 
                case MERGE_ON_READ: {
                    if (instantAndCommitMetadata.isPresent()) {
                        HoodieCommitMetadata commitMetadata = instantAndCommitMetadata.get().getRight();
                        Iterator<String> filePaths = commitMetadata.getFileIdAndFullPaths(this.metaClient.getBasePathV2()).values().iterator();
                        return this.fetchSchemaFromFiles(filePaths);
                    }
                    throw new IllegalArgumentException("Could not find any data file written for commit, so could not get schema for table " + this.metaClient.getBasePath());
                }
            }
            LOG.error((Object)("Unknown table type " + (Object)((Object)this.metaClient.getTableType())));
            throw new InvalidTableException(this.metaClient.getBasePath());
        }
        catch (IOException e) {
            throw new HoodieException("Failed to read data schema", e);
        }
    }

    public static MessageType convertAvroSchemaToParquet(Schema schema2, Configuration hadoopConf) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(hadoopConf);
        return avroSchemaConverter.convert(schema2);
    }

    private Schema convertParquetSchemaToAvro(MessageType parquetSchema) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(this.metaClient.getHadoopConf());
        return avroSchemaConverter.convert(parquetSchema);
    }

    private MessageType convertAvroSchemaToParquet(Schema schema2) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(this.metaClient.getHadoopConf());
        return avroSchemaConverter.convert(schema2);
    }

    public static boolean isSchemaCompatible(Schema oldSchema, Schema newSchema) {
        if (oldSchema.getType() == newSchema.getType() && newSchema.getType() == Schema.Type.RECORD) {
            if (!SchemaCompatibility.schemaNameEquals((Schema)newSchema, (Schema)oldSchema)) {
                return false;
            }
            for (Schema.Field oldSchemaField : oldSchema.getFields()) {
                Schema.Field newSchemaField = SchemaCompatibility.lookupWriterField((Schema)newSchema, (Schema.Field)oldSchemaField);
                if (newSchemaField == null) {
                    return false;
                }
                if (TableSchemaResolver.isSchemaCompatible(oldSchemaField.schema(), newSchemaField.schema())) continue;
                return false;
            }
            for (Schema.Field newSchemaField : newSchema.getFields()) {
                Schema.Field oldSchemaField = SchemaCompatibility.lookupWriterField((Schema)oldSchema, (Schema.Field)newSchemaField);
                if (oldSchemaField != null || newSchemaField.defaultVal() != null) continue;
                return false;
            }
            return true;
        }
        SchemaCompatibility.SchemaPairCompatibility compatResult = SchemaCompatibility.checkReaderWriterCompatibility((Schema)newSchema, (Schema)oldSchema);
        return compatResult.getType() == SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
    }

    public static boolean isSchemaCompatible(String oldSchema, String newSchema) {
        return TableSchemaResolver.isSchemaCompatible(new Schema.Parser().parse(oldSchema), new Schema.Parser().parse(newSchema));
    }

    public Option<Schema> getTableAvroSchemaFromLatestCommit(boolean includeMetadataFields) throws Exception {
        if (this.metaClient.isTimelineNonEmpty()) {
            return Option.of(this.getTableAvroSchemaInternal(includeMetadataFields, Option.empty()));
        }
        return Option.empty();
    }

    @Deprecated
    public Schema getLatestSchema(Schema writeSchema, boolean convertTableSchemaToAddNamespace, Functions.Function1<Schema, Schema> converterFn) {
        Schema latestSchema = writeSchema;
        try {
            if (this.metaClient.isTimelineNonEmpty()) {
                Schema tableSchema = this.getTableAvroSchemaWithoutMetadataFields();
                if (convertTableSchemaToAddNamespace && converterFn != null) {
                    tableSchema = converterFn.apply(tableSchema);
                }
                if (writeSchema.getFields().size() < tableSchema.getFields().size() && TableSchemaResolver.isSchemaCompatible(writeSchema, tableSchema)) {
                    latestSchema = tableSchema;
                    LOG.debug((Object)("Using latest table schema to rewrite incoming records " + tableSchema.toString()));
                }
            }
        }
        catch (IllegalArgumentException | InvalidTableException e) {
            LOG.warn((Object)"Could not find any commits, falling back to using incoming batch's write schema");
        }
        catch (Exception e) {
            LOG.warn((Object)("Unknown exception thrown " + e.getMessage() + ", Falling back to using incoming batch's write schema"));
        }
        return latestSchema;
    }

    private MessageType readSchemaFromParquetBaseFile(Path parquetFilePath) throws IOException {
        LOG.info((Object)("Reading schema from " + parquetFilePath));
        FileSystem fs = this.metaClient.getRawFs();
        ParquetMetadata fileFooter = ParquetFileReader.readFooter((Configuration)fs.getConf(), (Path)parquetFilePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        return fileFooter.getFileMetaData().getSchema();
    }

    private MessageType readSchemaFromHFileBaseFile(Path hFilePath) throws IOException {
        LOG.info((Object)("Reading schema from " + hFilePath));
        FileSystem fs = this.metaClient.getRawFs();
        CacheConfig cacheConfig = new CacheConfig(fs.getConf());
        HoodieHFileReader hFileReader = new HoodieHFileReader(fs.getConf(), hFilePath, cacheConfig);
        return this.convertAvroSchemaToParquet(hFileReader.getSchema());
    }

    private MessageType readSchemaFromORCBaseFile(Path orcFilePath) throws IOException {
        LOG.info((Object)("Reading schema from " + orcFilePath));
        FileSystem fs = this.metaClient.getRawFs();
        HoodieOrcReader orcReader = new HoodieOrcReader(fs.getConf(), orcFilePath);
        return this.convertAvroSchemaToParquet(orcReader.getSchema());
    }

    public MessageType readSchemaFromLastCompaction(Option<HoodieInstant> lastCompactionCommitOpt) throws Exception {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant lastCompactionCommit = lastCompactionCommitOpt.orElseThrow(() -> new Exception("Could not read schema from last compaction, no compaction commits found on path " + this.metaClient));
        HoodieCommitMetadata compactionMetadata = HoodieCommitMetadata.fromBytes(activeTimeline.getInstantDetails(lastCompactionCommit).get(), HoodieCommitMetadata.class);
        String filePath = compactionMetadata.getFileIdAndFullPaths(this.metaClient.getBasePathV2()).values().stream().findAny().orElseThrow(() -> new IllegalArgumentException("Could not find any data file written for compaction " + lastCompactionCommit + ", could not get schema for table " + this.metaClient.getBasePath()));
        return this.readSchemaFromBaseFile(filePath);
    }

    private MessageType readSchemaFromLogFile(Path path) throws IOException {
        return TableSchemaResolver.readSchemaFromLogFile(this.metaClient.getRawFs(), path);
    }

    public static MessageType readSchemaFromLogFile(FileSystem fs, Path path) throws IOException {
        try (HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(fs, new HoodieLogFile(path), null);){
            HoodieDataBlock lastBlock = null;
            while (reader.hasNext()) {
                HoodieLogBlock block = (HoodieLogBlock)reader.next();
                if (!(block instanceof HoodieDataBlock)) continue;
                lastBlock = (HoodieDataBlock)block;
            }
            MessageType messageType = lastBlock != null ? new AvroSchemaConverter().convert(lastBlock.getSchema()) : null;
            return messageType;
        }
    }

    public Option<InternalSchema> getTableInternalSchemaFromCommitMetadata() {
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        return timeline.lastInstant().flatMap(this::getTableInternalSchemaFromCommitMetadata);
    }

    public Option<InternalSchema> getTableInternalSchemaFromCommitMetadata(String timestamp) {
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().findInstantsBeforeOrEquals(timestamp);
        return timeline.lastInstant().flatMap(this::getTableInternalSchemaFromCommitMetadata);
    }

    private Option<InternalSchema> getTableInternalSchemaFromCommitMetadata(HoodieInstant instant) {
        try {
            HoodieCommitMetadata metadata = this.getCachedCommitMetadata(instant);
            String latestInternalSchemaStr = metadata.getMetadata("latest_schema");
            if (latestInternalSchemaStr != null) {
                return SerDeHelper.fromJson(latestInternalSchemaStr);
            }
            return Option.empty();
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema from commit metadata", e);
        }
    }

    public Option<String> getTableHistorySchemaStrFromCommitMetadata() {
        FileBasedInternalSchemaStorageManager manager = new FileBasedInternalSchemaStorageManager(this.metaClient);
        String result = manager.getHistorySchemaStr();
        return result.isEmpty() ? Option.empty() : Option.of(result);
    }

    public boolean hasOperationField() {
        try {
            Schema tableAvroSchema = this.getTableAvroSchemaFromDataFile();
            return tableAvroSchema.getField("_hoodie_operation") != null;
        }
        catch (Exception e) {
            LOG.info((Object)String.format("Failed to read operation field from avro schema (%s)", e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLatestCommitMetadataWithValidSchema() {
        Option<Pair<HoodieInstant, HoodieCommitMetadata>> instantAndCommitMetadata;
        if (this.latestCommitWithValidSchema == null && (instantAndCommitMetadata = this.metaClient.getActiveTimeline().getLastCommitMetadataWithValidSchema()).isPresent()) {
            HoodieInstant instant2 = instantAndCommitMetadata.get().getLeft();
            HoodieCommitMetadata metadata = instantAndCommitMetadata.get().getRight();
            TableSchemaResolver tableSchemaResolver = this;
            synchronized (tableSchemaResolver) {
                if (this.latestCommitWithValidSchema == null) {
                    this.latestCommitWithValidSchema = instant2;
                }
                this.commitMetadataCache.get().putIfAbsent(instant2, metadata);
            }
        }
        return Option.ofNullable(this.latestCommitWithValidSchema).map(instant -> Pair.of(instant, this.commitMetadataCache.get().get(instant)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLatestCommitMetadataWithValidData() {
        Option<Pair<HoodieInstant, HoodieCommitMetadata>> instantAndCommitMetadata;
        if (this.latestCommitWithValidData == null && (instantAndCommitMetadata = this.metaClient.getActiveTimeline().getLastCommitMetadataWithValidData()).isPresent()) {
            HoodieInstant instant2 = instantAndCommitMetadata.get().getLeft();
            HoodieCommitMetadata metadata = instantAndCommitMetadata.get().getRight();
            TableSchemaResolver tableSchemaResolver = this;
            synchronized (tableSchemaResolver) {
                if (this.latestCommitWithValidData == null) {
                    this.latestCommitWithValidData = instant2;
                }
                this.commitMetadataCache.get().putIfAbsent(instant2, metadata);
            }
        }
        return Option.ofNullable(this.latestCommitWithValidData).map(instant -> Pair.of(instant, this.commitMetadataCache.get().get(instant)));
    }

    private HoodieCommitMetadata getCachedCommitMetadata(HoodieInstant instant) {
        return this.commitMetadataCache.get().computeIfAbsent(instant, missingInstant -> {
            HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
            byte[] data = timeline.getInstantDetails((HoodieInstant)missingInstant).get();
            try {
                return HoodieCommitMetadata.fromBytes(data, HoodieCommitMetadata.class);
            }
            catch (IOException e) {
                throw new HoodieIOException(String.format("Failed to fetch HoodieCommitMetadata for instant (%s)", missingInstant), e);
            }
        });
    }

    private MessageType fetchSchemaFromFiles(Iterator<String> filePaths) throws IOException {
        MessageType type = null;
        while (filePaths.hasNext() && type == null) {
            String filePath = filePaths.next();
            if (filePath.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension())) {
                type = this.readSchemaFromLogFile(new Path(filePath));
                continue;
            }
            type = this.readSchemaFromBaseFile(filePath);
        }
        return type;
    }

    private MessageType readSchemaFromBaseFile(String filePath) throws IOException {
        if (filePath.contains(HoodieFileFormat.PARQUET.getFileExtension())) {
            return this.readSchemaFromParquetBaseFile(new Path(filePath));
        }
        if (filePath.contains(HoodieFileFormat.HFILE.getFileExtension())) {
            return this.readSchemaFromHFileBaseFile(new Path(filePath));
        }
        if (filePath.contains(HoodieFileFormat.ORC.getFileExtension())) {
            return this.readSchemaFromORCBaseFile(new Path(filePath));
        }
        throw new IllegalArgumentException("Unknown base file format :" + filePath);
    }

    public static Schema appendPartitionColumns(Schema dataSchema2, Option<String[]> partitionFields) {
        if (!partitionFields.isPresent() || partitionFields.get().length == 0) {
            return dataSchema2;
        }
        boolean hasPartitionColNotInSchema = Arrays.stream((Object[])partitionFields.get()).anyMatch(pf -> !AvroSchemaUtils.containsFieldInSchema(dataSchema2, pf));
        boolean hasPartitionColInSchema = Arrays.stream((Object[])partitionFields.get()).anyMatch(pf -> AvroSchemaUtils.containsFieldInSchema(dataSchema2, pf));
        if (hasPartitionColNotInSchema && hasPartitionColInSchema) {
            throw new HoodieIncompatibleSchemaException("Partition columns could not be partially contained w/in the data schema");
        }
        if (hasPartitionColNotInSchema) {
            ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
            for (String partitionField : partitionFields.get()) {
                newFields.add(new Schema.Field(partitionField, AvroSchemaUtils.createNullableSchema(Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE));
            }
            return AvroSchemaUtils.appendFieldsToSchema(dataSchema2, newFields);
        }
        return dataSchema2;
    }
}

