/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;

public class HoodieCorruptBlock
extends HoodieLogBlock {
    public HoodieCorruptBlock(Option<byte[]> corruptedBytes, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(header, footer, blockContentLocation, corruptedBytes, inputStream, readBlockLazily);
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        if (!this.getContent().isPresent() && this.readBlockLazily) {
            this.inflate();
        }
        return this.getContent().get();
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK;
    }
}

