/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.HoodieHFileInputFormat;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieMergeOnReadTableInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeRecordReader;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieHFileRealtimeInputFormat
extends HoodieMergeOnReadTableInputFormat {
    private static final Logger LOG = LogManager.getLogger(HoodieHFileRealtimeInputFormat.class);
    private final HoodieHFileInputFormat hFileInputFormat = new HoodieHFileInputFormat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split2, JobConf jobConf, Reporter reporter) throws IOException {
        if (jobConf.get("hoodie.read.columns.set") == null) {
            JobConf jobConf2 = jobConf;
            synchronized (jobConf2) {
                LOG.info((Object)("Before adding Hoodie columns, Projections :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
                if (jobConf.get("hoodie.read.columns.set") == null) {
                    HoodieRealtimeInputFormatUtils.addRequiredProjectionFields((Configuration)jobConf, Option.empty());
                    this.conf = jobConf;
                    this.conf.set("hoodie.read.columns.set", "true");
                }
            }
        }
        HoodieRealtimeInputFormatUtils.cleanProjectionColumnIds((Configuration)jobConf);
        LOG.info((Object)("Creating record reader with readCols :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
        ValidationUtils.checkArgument(split2 instanceof HoodieRealtimeFileSplit, "HoodieRealtimeRecordReader can only work on HoodieRealtimeFileSplit and not with " + split2);
        return new HoodieRealtimeRecordReader((HoodieRealtimeFileSplit)split2, jobConf, this.hFileInputFormat.getRecordReader(split2, jobConf, reporter));
    }

    @Override
    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }
}

