/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieEmptyRecordReader;
import org.apache.hudi.hadoop.realtime.HoodieMergeOnReadTableInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeRecordReader;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieParquetRealtimeInputFormat
extends HoodieParquetInputFormat {
    private static final Logger LOG = LogManager.getLogger(HoodieParquetRealtimeInputFormat.class);

    public HoodieParquetRealtimeInputFormat() {
        super(new HoodieMergeOnReadTableInputFormat());
    }

    @Override
    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split2, JobConf jobConf, Reporter reporter) throws IOException {
        ValidationUtils.checkArgument(split2 instanceof RealtimeSplit, "HoodieRealtimeRecordReader can only work on RealtimeSplit and not with " + split2);
        RealtimeSplit realtimeSplit = (RealtimeSplit)split2;
        this.addProjectionToJobConf(realtimeSplit, jobConf);
        LOG.info((Object)("Creating record reader with readCols :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
        if (FSUtils.isLogFile(realtimeSplit.getPath())) {
            return new HoodieRealtimeRecordReader(realtimeSplit, jobConf, new HoodieEmptyRecordReader(realtimeSplit, jobConf));
        }
        return new HoodieRealtimeRecordReader(realtimeSplit, jobConf, super.getRecordReader(split2, jobConf, reporter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProjectionToJobConf(RealtimeSplit realtimeSplit, JobConf jobConf) {
        if (HoodieRealtimeInputFormatUtils.canAddProjectionToJobConf(realtimeSplit, jobConf)) {
            JobConf jobConf2 = jobConf;
            synchronized (jobConf2) {
                LOG.info((Object)("Before adding Hoodie columns, Projections :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
                if (HoodieRealtimeInputFormatUtils.canAddProjectionToJobConf(realtimeSplit, jobConf)) {
                    if (!realtimeSplit.getDeltaLogPaths().isEmpty()) {
                        HoodieRealtimeInputFormatUtils.addRequiredProjectionFields((Configuration)jobConf, realtimeSplit.getVirtualKeyInfo());
                    }
                    jobConf.set("hoodie.read.columns.set", "true");
                    this.setConf((Configuration)jobConf);
                }
            }
        }
        HoodieRealtimeInputFormatUtils.cleanProjectionColumnIds((Configuration)jobConf);
    }
}

