/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.IOException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.HoodieGlobalBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndexHelper;
import org.apache.hudi.index.bucket.HoodieSimpleBucketIndex;
import org.apache.hudi.index.bucket.HoodieSparkConsistentBucketIndex;
import org.apache.hudi.index.hbase.SparkHoodieHBaseIndex;
import org.apache.hudi.index.inmemory.HoodieInMemoryHashIndex;
import org.apache.hudi.index.simple.HoodieGlobalSimpleIndex;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;

public final class SparkHoodieIndexFactory {
    public static HoodieIndex createIndex(HoodieWriteConfig config) {
        if (!StringUtils.isNullOrEmpty(config.getIndexClass())) {
            Object instance = ReflectionUtils.loadClass(config.getIndexClass(), config);
            if (!(instance instanceof HoodieIndex)) {
                throw new HoodieIndexException(config.getIndexClass() + " is not a subclass of HoodieIndex");
            }
            return (HoodieIndex)instance;
        }
        switch (config.getIndexType()) {
            case HBASE: {
                return new SparkHoodieHBaseIndex(config);
            }
            case INMEMORY: {
                return new HoodieInMemoryHashIndex(config);
            }
            case BLOOM: {
                return new HoodieBloomIndex(config, SparkHoodieBloomIndexHelper.getInstance());
            }
            case GLOBAL_BLOOM: {
                return new HoodieGlobalBloomIndex(config, SparkHoodieBloomIndexHelper.getInstance());
            }
            case SIMPLE: {
                return new HoodieSimpleIndex(config, SparkHoodieIndexFactory.getKeyGeneratorForSimpleIndex(config));
            }
            case GLOBAL_SIMPLE: {
                return new HoodieGlobalSimpleIndex(config, SparkHoodieIndexFactory.getKeyGeneratorForSimpleIndex(config));
            }
            case BUCKET: {
                switch (config.getBucketIndexEngineType()) {
                    case SIMPLE: {
                        return new HoodieSimpleBucketIndex(config);
                    }
                    case CONSISTENT_HASHING: {
                        return new HoodieSparkConsistentBucketIndex(config);
                    }
                }
                throw new HoodieIndexException("Unknown bucket index engine type: " + (Object)((Object)config.getBucketIndexEngineType()));
            }
        }
        throw new HoodieIndexException("Index type unspecified, set " + (Object)((Object)config.getIndexType()));
    }

    public static boolean isGlobalIndex(HoodieWriteConfig config) {
        switch (config.getIndexType()) {
            case HBASE: {
                return true;
            }
            case INMEMORY: {
                return true;
            }
            case BLOOM: {
                return false;
            }
            case GLOBAL_BLOOM: {
                return true;
            }
            case SIMPLE: {
                return false;
            }
            case GLOBAL_SIMPLE: {
                return true;
            }
            case BUCKET: {
                return false;
            }
        }
        return SparkHoodieIndexFactory.createIndex(config).isGlobal();
    }

    private static Option<BaseKeyGenerator> getKeyGeneratorForSimpleIndex(HoodieWriteConfig config) {
        try {
            return config.populateMetaFields() ? Option.empty() : Option.of((BaseKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator(new TypedProperties(config.getProps())));
        }
        catch (IOException e) {
            throw new HoodieIOException("KeyGenerator instantiation failed ", e);
        }
    }
}

