/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.convert;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class AvroInternalSchemaConverter {
    public static Schema convert(InternalSchema internalSchema, String tableName, String namespace) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromInternalSchema(internalSchema, tableName, namespace);
    }

    public static Schema convert(InternalSchema internalSchema, String tableName) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromInternalSchema(internalSchema, tableName, "");
    }

    public static Schema convert(Types.RecordType type, String name) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromType(type, name);
    }

    public static Schema convert(Type type, String name) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromType(type, name);
    }

    public static Type convertToField(Schema schema2) {
        return AvroInternalSchemaConverter.buildTypeFromAvroSchema(schema2);
    }

    public static InternalSchema convert(Schema schema2) {
        List<Types.Field> fields = ((Types.RecordType)AvroInternalSchemaConverter.convertToField(schema2)).fields();
        return new InternalSchema(fields);
    }

    public static boolean isOptional(Schema schema2) {
        if (schema2.getType() == Schema.Type.UNION && schema2.getTypes().size() == 2) {
            return ((Schema)schema2.getTypes().get(0)).getType() == Schema.Type.NULL || ((Schema)schema2.getTypes().get(1)).getType() == Schema.Type.NULL;
        }
        return false;
    }

    public static Schema nullableSchema(Schema schema2) {
        if (schema2.getType() == Schema.Type.UNION) {
            if (!AvroInternalSchemaConverter.isOptional(schema2)) {
                throw new HoodieSchemaException(String.format("Union schemas are not supported: %s", schema2));
            }
            return schema2;
        }
        return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema2});
    }

    public static Type buildTypeFromAvroSchema(Schema schema2) {
        LinkedList<String> visited = new LinkedList<String>();
        AtomicInteger nextId = new AtomicInteger(1);
        return AvroInternalSchemaConverter.visitAvroSchemaToBuildType(schema2, visited, true, nextId);
    }

    private static Type visitAvroSchemaToBuildType(Schema schema2, Deque<String> visited, Boolean firstVisitRoot, AtomicInteger nextId) {
        switch (schema2.getType()) {
            case RECORD: {
                String name = schema2.getFullName();
                if (visited.contains(name)) {
                    throw new HoodieSchemaException(String.format("cannot convert recursive avro record %s", name));
                }
                visited.push(name);
                List fields = schema2.getFields();
                ArrayList fieldTypes = new ArrayList(fields.size());
                int nextAssignId = nextId.get();
                if (firstVisitRoot.booleanValue()) {
                    nextAssignId = 0;
                }
                nextId.set(nextAssignId + fields.size());
                fields.stream().forEach(field -> fieldTypes.add(AvroInternalSchemaConverter.visitAvroSchemaToBuildType(field.schema(), visited, false, nextId)));
                visited.pop();
                ArrayList<Types.Field> internalFields = new ArrayList<Types.Field>(fields.size());
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field2 = (Schema.Field)fields.get(i);
                    Type fieldType = (Type)fieldTypes.get(i);
                    internalFields.add(Types.Field.get(nextAssignId, AvroInternalSchemaConverter.isOptional(field2.schema()), field2.name(), fieldType, field2.doc()));
                    ++nextAssignId;
                }
                return Types.RecordType.get(internalFields);
            }
            case UNION: {
                ArrayList fTypes = new ArrayList();
                schema2.getTypes().stream().forEach(t -> fTypes.add(AvroInternalSchemaConverter.visitAvroSchemaToBuildType(t, visited, false, nextId)));
                return fTypes.get(0) == null ? (Type)fTypes.get(1) : (Type)fTypes.get(0);
            }
            case ARRAY: {
                Schema elementSchema = schema2.getElementType();
                int elementId = nextId.get();
                nextId.set(elementId + 1);
                Type elementType = AvroInternalSchemaConverter.visitAvroSchemaToBuildType(elementSchema, visited, false, nextId);
                return Types.ArrayType.get(elementId, AvroInternalSchemaConverter.isOptional(schema2.getElementType()), elementType);
            }
            case MAP: {
                int keyId = nextId.get();
                int valueId = keyId + 1;
                nextId.set(valueId + 1);
                Type valueType = AvroInternalSchemaConverter.visitAvroSchemaToBuildType(schema2.getValueType(), visited, false, nextId);
                return Types.MapType.get(keyId, valueId, Types.StringType.get(), valueType, AvroInternalSchemaConverter.isOptional(schema2.getValueType()));
            }
        }
        return AvroInternalSchemaConverter.visitAvroPrimitiveToBuildInternalType(schema2);
    }

    private static Type visitAvroPrimitiveToBuildInternalType(Schema primitive) {
        LogicalType logical = primitive.getLogicalType();
        if (logical != null) {
            String name = logical.getName();
            if (logical instanceof LogicalTypes.Decimal) {
                return Types.DecimalType.get(((LogicalTypes.Decimal)logical).getPrecision(), ((LogicalTypes.Decimal)logical).getScale());
            }
            if (logical instanceof LogicalTypes.Date) {
                return Types.DateType.get();
            }
            if (logical instanceof LogicalTypes.TimeMillis || logical instanceof LogicalTypes.TimeMicros) {
                return Types.TimeType.get();
            }
            if (logical instanceof LogicalTypes.TimestampMillis || logical instanceof LogicalTypes.TimestampMicros) {
                return Types.TimestampType.get();
            }
            if (LogicalTypes.uuid().getName().equals(name)) {
                return Types.UUIDType.get();
            }
        }
        switch (primitive.getType()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT: {
                return Types.IntType.get();
            }
            case LONG: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case STRING: 
            case ENUM: {
                return Types.StringType.get();
            }
            case FIXED: {
                return Types.FixedType.getFixed(primitive.getFixedSize());
            }
            case BYTES: {
                return Types.BinaryType.get();
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + primitive);
    }

    public static Schema buildAvroSchemaFromType(Type type, String recordName) {
        HashMap<Type, Schema> cache = new HashMap<Type, Schema>();
        return AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(type, cache, recordName, "");
    }

    public static Schema buildAvroSchemaFromInternalSchema(InternalSchema schema2, String recordName, String namespace) {
        HashMap<Type, Schema> cache = new HashMap<Type, Schema>();
        return AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(schema2.getRecord(), cache, recordName, namespace);
    }

    private static Schema visitInternalSchemaToBuildAvroSchema(Type type, Map<Type, Schema> cache, String recordName, String namespace) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                record.fields().forEach(f -> {
                    Schema tempSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(f.type(), cache, recordName + "_" + f.name(), namespace);
                    Schema result = f.isOptional() ? AvroInternalSchemaConverter.nullableSchema(tempSchema) : tempSchema;
                    schemas.add(result);
                });
                Schema recordSchema = cache.get(record);
                if (recordSchema != null) {
                    return recordSchema;
                }
                recordSchema = AvroInternalSchemaConverter.visitInternalRecordToBuildAvroRecord(record, schemas, recordName, namespace);
                cache.put(record, recordSchema);
                return recordSchema;
            }
            case ARRAY: {
                Types.ArrayType array2 = (Types.ArrayType)type;
                Schema elementSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(array2.elementType(), cache, recordName, namespace);
                Schema arraySchema = cache.get(array2);
                if (arraySchema != null) {
                    return arraySchema;
                }
                arraySchema = AvroInternalSchemaConverter.visitInternalArrayToBuildAvroArray(array2, elementSchema);
                cache.put(array2, arraySchema);
                return arraySchema;
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                Schema keySchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(map.keyType(), cache, recordName, namespace);
                Schema valueSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(map.valueType(), cache, recordName, namespace);
                Schema mapSchema = cache.get(map);
                if (mapSchema != null) {
                    return mapSchema;
                }
                mapSchema = AvroInternalSchemaConverter.visitInternalMapToBuildAvroMap(map, keySchema, valueSchema);
                cache.put(map, mapSchema);
                return mapSchema;
            }
        }
        Schema primitiveSchema = AvroInternalSchemaConverter.visitInternalPrimitiveToBuildAvroPrimitiveType((Type.PrimitiveType)type);
        cache.put(type, primitiveSchema);
        return primitiveSchema;
    }

    private static Schema visitInternalRecordToBuildAvroRecord(Types.RecordType record, List<Schema> fieldSchemas, String recordName, String namespace) {
        List<Types.Field> fields = record.fields();
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < fields.size(); ++i) {
            Types.Field f = fields.get(i);
            Schema.Field field = new Schema.Field(f.name(), fieldSchemas.get(i), f.doc(), f.isOptional() ? JsonProperties.NULL_VALUE : null);
            avroFields.add(field);
        }
        return Schema.createRecord((String)recordName, null, (String)namespace, (boolean)false, avroFields);
    }

    private static Schema visitInternalArrayToBuildAvroArray(Types.ArrayType array2, Schema elementSchema) {
        Schema result = array2.isElementOptional() ? Schema.createArray((Schema)AvroInternalSchemaConverter.nullableSchema(elementSchema)) : Schema.createArray((Schema)elementSchema);
        return result;
    }

    private static Schema visitInternalMapToBuildAvroMap(Types.MapType map, Schema keySchema, Schema valueSchema) {
        if (keySchema.getType() != Schema.Type.STRING) {
            throw new HoodieSchemaException("only support StringType key for avro MapType");
        }
        Schema mapSchema = Schema.createMap((Schema)(map.isValueOptional() ? AvroInternalSchemaConverter.nullableSchema(valueSchema) : valueSchema));
        return mapSchema;
    }

    private static Schema visitInternalPrimitiveToBuildAvroPrimitiveType(Type.PrimitiveType primitive) {
        Schema primitiveSchema;
        switch (primitive.typeId()) {
            case BOOLEAN: {
                primitiveSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                break;
            }
            case INT: {
                primitiveSchema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case LONG: {
                primitiveSchema = Schema.create((Schema.Type)Schema.Type.LONG);
                break;
            }
            case FLOAT: {
                primitiveSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
                break;
            }
            case DOUBLE: {
                primitiveSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
                break;
            }
            case DATE: {
                primitiveSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
                break;
            }
            case TIME: {
                primitiveSchema = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
                break;
            }
            case TIMESTAMP: {
                primitiveSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
                break;
            }
            case STRING: {
                primitiveSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case UUID: {
                primitiveSchema = LogicalTypes.uuid().addToSchema(Schema.createFixed((String)"uuid_fixed", null, null, (int)16));
                break;
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                primitiveSchema = Schema.createFixed((String)("fixed_" + fixed.getFixedSize()), null, null, (int)fixed.getFixedSize());
                break;
            }
            case BINARY: {
                primitiveSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
                break;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                primitiveSchema = LogicalTypes.decimal((int)decimal.precision(), (int)decimal.scale()).addToSchema(Schema.createFixed((String)("decimal_" + decimal.precision() + "_" + decimal.scale()), null, null, (int)AvroInternalSchemaConverter.computeMinBytesForPrecision(decimal.precision())));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type ID: " + (Object)((Object)primitive.typeId()));
            }
        }
        return primitiveSchema;
    }

    private static int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

