/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriter;
import org.apache.hudi.io.storage.row.HoodieInternalRowParquetWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.types.StructType;

public class HoodieInternalRowFileWriterFactory {
    public static HoodieInternalRowFileWriter getInternalRowFileWriter(Path path, HoodieTable hoodieTable, HoodieWriteConfig writeConfig, StructType schema2) throws IOException {
        String extension = FSUtils.getFileExtension(path.getName());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieInternalRowFileWriterFactory.newParquetInternalRowFileWriter(path, hoodieTable, writeConfig, schema2, HoodieInternalRowFileWriterFactory.tryInstantiateBloomFilter(writeConfig));
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static HoodieInternalRowFileWriter newParquetInternalRowFileWriter(Path path, HoodieTable table, HoodieWriteConfig writeConfig, StructType structType, Option<BloomFilter> bloomFilterOpt) throws IOException {
        HoodieRowParquetWriteSupport writeSupport = new HoodieRowParquetWriteSupport(table.getHadoopConf(), structType, bloomFilterOpt, writeConfig);
        return new HoodieInternalRowParquetWriter(path, new HoodieParquetConfig<HoodieRowParquetWriteSupport>(writeSupport, writeConfig.getParquetCompressionCodec(), writeConfig.getParquetBlockSize(), writeConfig.getParquetPageSize(), writeConfig.getParquetMaxFileSize(), writeSupport.getHadoopConf(), writeConfig.getParquetCompressionRatio(), writeConfig.parquetDictionaryEnabled()));
    }

    private static Option<BloomFilter> tryInstantiateBloomFilter(HoodieWriteConfig writeConfig) {
        if (writeConfig.populateMetaFields()) {
            BloomFilter bloomFilter = BloomFilterFactory.createBloomFilter(writeConfig.getBloomFilterNumEntries(), writeConfig.getBloomFilterFPP(), writeConfig.getDynamicBloomFilterMaxNumEntries(), writeConfig.getBloomFilterType());
            return Option.of(bloomFilter);
        }
        return Option.empty();
    }
}

